/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.code_clones.normalization;

import com.teamscale.index.code_clones.normalization.ITokenNormalizer;
import com.teamscale.index.code_clones.normalization.ITokenReporter;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.conqat.lib.commons.collections.IdManager;
import org.conqat.lib.commons.regex.Patterns;
import org.conqat.lib.commons.string.StringUtils;

class GenericNormalizer
implements ITokenNormalizer {
    private static final Set<ETokenType> SKIPPED_DELIMITERS = EnumSet.of(ETokenType.LPAREN, ETokenType.RPAREN, ETokenType.LBRACK, ETokenType.RBRACK);
    private static final boolean DISABLE_TOKEN_NORMALIZATION = Boolean.getBoolean("com.teamscale.clones.normalization.disabled");

    GenericNormalizer() {
    }

    @Override
    public int normalize(List<IToken> tokens, int currentIndex, IdManager<String> idManager, ITokenReporter tokenReporter) {
        IToken token = tokens.get(currentIndex);
        ETokenType tokenType = token.getType();
        if (tokenType.getTokenClass() == ETokenType.ETokenClass.COMMENT || this.isSkippedTokenType(tokenType)) {
            return 0;
        }
        int skip = this.getNumTokensToSkip(tokens, currentIndex, tokenReporter);
        if (skip > 0) {
            return skip - 1;
        }
        this.reportNormalizedContent(token, tokenType, idManager, tokenReporter);
        return 0;
    }

    protected int getNumTokensToSkip(List<IToken> tokens, int currentIndex, ITokenReporter tokenReporter) {
        return 0;
    }

    private void reportNormalizedContent(IToken token, ETokenType tokenType, IdManager<String> idManager, ITokenReporter tokenReporter) {
        String content = token.getText();
        if (!token.getLanguage().isCaseSensitive() || tokenType != ETokenType.IDENTIFIER) {
            content = content.toLowerCase();
        }
        if (DISABLE_TOKEN_NORMALIZATION) {
            tokenReporter.report(content);
        } else if (this.supportConservativeNormalization(tokenType)) {
            tokenReporter.report(this.normalizeContent(tokenType, content, idManager), content);
        } else {
            tokenReporter.report(this.normalizeContent(tokenType, content, idManager));
        }
    }

    protected boolean supportConservativeNormalization(ETokenType tokenType) {
        return tokenType == ETokenType.IDENTIFIER || tokenType == ETokenType.STRING_LITERAL;
    }

    protected String normalizeContent(ETokenType tokenType, String content, IdManager<String> idManager) {
        switch (tokenType) {
            case IDENTIFIER: {
                return GenericNormalizer.normalizeString(content, idManager);
            }
            case STRING_LITERAL: {
                return "";
            }
            case CHARACTER_LITERAL: {
                return "char";
            }
            case INTEGER_LITERAL: 
            case FLOATING_POINT_LITERAL: 
            case NUMBER_WORD: {
                return "0";
            }
            case BOOLEAN_LITERAL: {
                return "true";
            }
            case LINE: {
                return StringUtils.replaceAll((String)content, (Pattern)Patterns.WHITESPACE, (String)"");
            }
        }
        return content;
    }

    protected static String normalizeString(String content, IdManager<String> idManager) {
        return "id" + idManager.obtainId((Object)content);
    }

    protected boolean isSkippedTokenType(ETokenType tokenType) {
        return SKIPPED_DELIMITERS.contains(tokenType);
    }
}

