/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.code_clones.normalization;

import com.teamscale.index.code_clones.core.Unit;
import com.teamscale.index.code_clones.normalization.RepetitionDetector;
import com.teamscale.index.code_clones.normalization.SimpleGetterSequenceDetector;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.region.Region;
import org.conqat.lib.commons.region.RegionSet;

public class RepetitionNormalizationAdjuster {
    private static final RepetitionDetector SIZE2_DETECTOR = new RepetitionDetector(2, 6);
    private static final RepetitionDetector SIZE3_DETECTOR = new RepetitionDetector(3, 9);

    public static void normalizeRepetitionsConservative(List<Unit> units, List<Unit> conservativeUnits, List<ShallowEntity> parseTree, Set<String> methodNamesForConservativeNormalization) {
        RepetitionNormalizationAdjuster.normalizeByRepetitiveStatements(units, conservativeUnits);
        if (parseTree != null) {
            RegionSet entityRepetitions = SimpleGetterSequenceDetector.findRegions(parseTree);
            entityRepetitions.addAll(RepetitionNormalizationAdjuster.findMethodRegionsByName(parseTree, methodNamesForConservativeNormalization));
            RepetitionNormalizationAdjuster.applyConservativeRegionsFromParseTree(entityRepetitions, units, conservativeUnits);
        }
    }

    private static void normalizeByRepetitiveStatements(List<Unit> units, List<Unit> conservativeUnits) {
        RegionSet plainRepetitions = RepetitionNormalizationAdjuster.detectRepetitions(units);
        if (plainRepetitions != null && !plainRepetitions.isEmpty()) {
            for (int i = 0; i < units.size(); ++i) {
                if (!plainRepetitions.contains(i)) continue;
                units.set(i, conservativeUnits.get(i));
            }
        }
    }

    private static RegionSet detectRepetitions(List<Unit> units) {
        RegionSet sizeTwoRepetitions = SIZE2_DETECTOR.detectRepetitions(units);
        RegionSet sizeThreeRepetitions = SIZE3_DETECTOR.detectRepetitions(units);
        if (sizeTwoRepetitions == null) {
            return sizeThreeRepetitions;
        }
        if (sizeThreeRepetitions != null) {
            sizeTwoRepetitions.addAll((Collection)sizeThreeRepetitions);
        }
        return sizeTwoRepetitions;
    }

    private static void applyConservativeRegionsFromParseTree(RegionSet conservativeRegions, List<Unit> units, List<Unit> conservativeUnits) {
        if (conservativeRegions != null && !conservativeRegions.isEmpty()) {
            for (int i = 0; i < units.size(); ++i) {
                Unit currentUnit = units.get(i);
                if (!conservativeRegions.contains(currentUnit.getFilteredStartOffset()) && !conservativeRegions.contains(currentUnit.getFilteredEndOffset())) continue;
                units.set(i, conservativeUnits.get(i));
            }
        }
    }

    private static Collection<Region> findMethodRegionsByName(List<ShallowEntity> parseTree, Set<String> methodNames) {
        if (methodNames.isEmpty()) {
            return Collections.emptyList();
        }
        return CollectionUtils.filterAndMap((Collection)ShallowEntityTraversalUtils.listEntitiesOfType(parseTree, (EShallowEntityType)EShallowEntityType.METHOD), method -> methodNames.contains(method.getName()), method -> new Region(method.getStartOffset(), method.getEndOffset()));
    }
}

