/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external.input.external_storage;

import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.config.TeamscaleSystemProperties;
import com.teamscale.index.external.input.external_storage.EExternalStorageBackendProtocol;
import com.teamscale.index.external.input.external_storage.ExternalStorageBackend;
import com.teamscale.index.external.input.external_storage.ExternalStorageBackendIndex;
import com.teamscale.index.s3.S3UriParser;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class ExternalStorageLookup {
    private static final Logger LOGGER = LogManager.getLogger();

    public static @NonNull Optional<ExternalStorageBackend> getStorageBackend(@NonNull ProjectConfiguration project, @NonNull ExternalStorageBackendIndex externalStorageBackendIndex) throws StorageException {
        return ExternalStorageLookup.getStorageBackend(Objects.requireNonNull(project.getInternalId()), project.getExternalStorageBackend(), externalStorageBackendIndex::getExternalStorageBackend);
    }

    public static @NonNull Optional<ExternalStorageBackend> getStorageBackend(@NonNull InternalProjectId projectId, @Nullable String externalStorageName, @NonNull ExternalStorageBackendIndex externalStorageBackendIndex) throws StorageException {
        return ExternalStorageLookup.getStorageBackend(projectId, externalStorageName, externalStorageBackendIndex::getExternalStorageBackend);
    }

    @VisibleForTesting
    static @NonNull Optional<ExternalStorageBackend> getStorageBackend(@NonNull InternalProjectId projectId, @Nullable String externalStorageName, @NonNull IExternalStorageProvider externalStorageProvider) throws StorageException {
        if (EFeatureToggle.OVERWRITE_EXTERNAL_STORAGE.isEnabled()) {
            return ExternalStorageLookup.getOverwrittenExternalStorage(projectId);
        }
        if (StringUtils.isEmpty((String)externalStorageName)) {
            return Optional.empty();
        }
        Optional<ExternalStorageBackend> externalStorageBackend = externalStorageProvider.getExternalStorageBackend(externalStorageName);
        if (externalStorageBackend.isEmpty()) {
            throw new StorageException("Selected external storage '%s' not found in index.".formatted(externalStorageName));
        }
        return externalStorageBackend;
    }

    private static @NonNull Optional<ExternalStorageBackend> getOverwrittenExternalStorage(@NonNull InternalProjectId projectId) {
        Optional uri = TeamscaleSystemProperties.OVERWRITE_EXTERNAL_STORAGE_URI.getValue();
        if (uri.isEmpty()) {
            LOGGER.debug("External storage overwrite is enabled, but no external storage URI is configured. External storage is disabled.");
            return Optional.empty();
        }
        S3UriParser.ParsedUri parsedUri = S3UriParser.parseUri(URI.create((String)uri.get()));
        ExternalStorageBackend externalStorage = new ExternalStorageBackend("##external-storage-overwrite##", "##external-storage-overwrite##", EExternalStorageBackendProtocol.S3, parsedUri.getBucket(), "", false);
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = () -> projectId;
        supplierArray[1] = uri::get;
        LOGGER.debug("Project '{}' is now using external storage '{}'.", supplierArray);
        return Optional.of(externalStorage);
    }

    private ExternalStorageLookup() {
        throw new UnsupportedOperationException("Avoid initializing util class.");
    }

    @FunctionalInterface
    @VisibleForTesting
    static interface IExternalStorageProvider {
        public Optional<ExternalStorageBackend> getExternalStorageBackend(String var1) throws StorageException;
    }
}

