/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings;

import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.index.configuration.CodeScopeUtils;
import com.teamscale.index.findings.FindingsSynchronizingAnalyzingStepBase;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.UnmodifiableCollection;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.filesystem.CanonicalFile;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.function.FunctionWithException;
import org.conqat.lib.commons.string.StringUtils;

public abstract class LintFindingsSynchronizerBase
extends FindingsSynchronizingAnalyzingStepBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private final String partition;

    protected LintFindingsSynchronizerBase(String partition) {
        this.partition = partition;
    }

    public void execute() throws StorageException {
        try {
            CodeScopeAware<Set<BasicTokenElementInfo>> elementsToAnalyze = this.getElementsToAnalyzeByCodeScopes();
            CodeScopeAware<ListMap<String, IndexFinding>> findingsPerCodeScope = this.lintFiles(elementsToAnalyze);
            Set<String> analyzedPaths = elementsToAnalyze.getValues().stream().flatMap(Collection::stream).map(BasicTokenElementInfo::getUniformPath).collect(Collectors.toSet());
            this.synchronizeFindings(findingsPerCodeScope, this.partition, analyzedPaths);
        }
        catch (ConQATException e) {
            LOGGER.error("Error running {}: {}", ((Object)((Object)this)).getClass(), (Object)e, (Object)e);
        }
    }

    private CodeScopeAware<Set<BasicTokenElementInfo>> getElementsToAnalyzeByCodeScopes() throws StorageException {
        Set<BasicTokenElementInfo> elementsToAnalyze = this.determineElementsToAnalyze();
        CodeScopeAware<Set<BasicTokenElementInfo>> elementsToAnalyzeByCodeScope = CodeScopeUtils.groupElementsByCodeScope(elementsToAnalyze);
        for (CodeScopeName codeScope : elementsToAnalyzeByCodeScope.getCodeScopeNames()) {
            UnmodifiableSet elementsInCodeScope = UnmodifiableSet.of((Set)((Set)elementsToAnalyzeByCodeScope.getValue(codeScope)));
            Collection<BasicTokenElementInfo> additionalElements = this.getAdditionalRelevantElements((UnmodifiableCollection<BasicTokenElementInfo>)elementsInCodeScope);
            additionalElements = LintFindingsSynchronizerBase.filterForElementsInSameScope(additionalElements, codeScope, (UnmodifiableSet<BasicTokenElementInfo>)elementsInCodeScope);
            HashSet fullListOfElementsInCodeScope = CollectionUtils.unionSet((Collection)elementsInCodeScope, (Collection[])new Collection[]{additionalElements});
            elementsToAnalyzeByCodeScope.setValue(codeScope, (Object)fullListOfElementsInCodeScope);
        }
        return elementsToAnalyzeByCodeScope;
    }

    protected Set<BasicTokenElementInfo> determineElementsToAnalyze() throws StorageException {
        List<String> contentDeltaRelevantFiles = this.contentDelta.getAddedOrChangedKeysAsStrings().stream().filter(this::pathIsIncludedInAnalysis).toList();
        return this.basicTokenElementIndex.getTokenElements(contentDeltaRelevantFiles).stream().filter(Objects::nonNull).collect(Collectors.toSet());
    }

    protected static Set<BasicTokenElementInfo> filterForElementsInSameScope(Collection<BasicTokenElementInfo> additionalElements, CodeScopeName codeScope, UnmodifiableSet<BasicTokenElementInfo> elementsDependingOnAdditionalElements) {
        CodeScopeAware<Set> additionalElementsPerCodeScope = CodeScopeUtils.groupElementsByCodeScope(additionalElements, HashSet::new);
        LintFindingsSynchronizerBase.logMessageIfOverarchingCodeScopes(additionalElementsPerCodeScope, codeScope, elementsDependingOnAdditionalElements);
        Set<BasicTokenElementInfo> additionalElementsForCodeScope = (Set<BasicTokenElementInfo>)additionalElementsPerCodeScope.getValueOrNull(codeScope);
        if (additionalElementsForCodeScope == null) {
            additionalElementsForCodeScope = Collections.emptySet();
        }
        return additionalElementsForCodeScope;
    }

    private static void logMessageIfOverarchingCodeScopes(CodeScopeAware<Set<BasicTokenElementInfo>> additionalElementsPerCodeScope, CodeScopeName codeScope, UnmodifiableSet<BasicTokenElementInfo> elementsDependingOnAdditionalElements) {
        List<CodeScopeName> overarchingCodeScopes = additionalElementsPerCodeScope.getCodeScopeNames().stream().filter(otherCodeScope -> !otherCodeScope.equals((Object)codeScope)).toList();
        if (overarchingCodeScopes.isEmpty()) {
            return;
        }
        LOGGER.warn("Analysis may produce incomplete or incorrect results because files from code scope '{}' depend on files that reside in these other code scopes: {}", (Object)codeScope, (Object)StringUtils.concat(overarchingCodeScopes, (String)", "));
        Map elementsByOverarchingCodeScope = overarchingCodeScopes.stream().collect(Collectors.toMap(Function.identity(), overarchingCodeScope -> ((Set)additionalElementsPerCodeScope.getValue(overarchingCodeScope)).stream().toList()));
        LOGGER.debug("The files {} from code scope '{}' depend on these files from other code scopes: {}", elementsDependingOnAdditionalElements, (Object)codeScope, elementsByOverarchingCodeScope);
    }

    protected Collection<BasicTokenElementInfo> getAdditionalRelevantElements(UnmodifiableCollection<BasicTokenElementInfo> initialElements) throws StorageException {
        return Collections.emptySet();
    }

    private CodeScopeAware<ListMap<String, IndexFinding>> lintFiles(CodeScopeAware<Set<BasicTokenElementInfo>> tokenElementsPerCodeScope) throws ConQATException {
        CodeScopeAware findingsPerCodeScope = CodeScopeAware.empty();
        for (CodeScopeName codeScopeName : tokenElementsPerCodeScope.getCodeScopeNames()) {
            Set elementsInCodeScope = (Set)tokenElementsPerCodeScope.getValue(codeScopeName);
            ListMap<String, IndexFinding> findings = this.lintFiles(elementsInCodeScope, codeScopeName);
            findingsPerCodeScope.setValue(codeScopeName, findings);
        }
        return findingsPerCodeScope;
    }

    protected ListMap<String, IndexFinding> lintFiles(Collection<BasicTokenElementInfo> elementsInCodeScope, CodeScopeName codeScopeName) throws ConQATException {
        Optional<String> report = this.executeLint(elementsInCodeScope, codeScopeName);
        if (report.isEmpty()) {
            return new ListMap();
        }
        return this.parseReport(report.get());
    }

    protected abstract Optional<String> executeLint(Collection<BasicTokenElementInfo> var1, CodeScopeName var2) throws ConQATException;

    protected abstract ListMap<String, IndexFinding> parseReport(String var1) throws ConQATException;

    protected abstract boolean pathIsIncludedInAnalysis(String var1);

    protected static List<String> createTemporaryFiles(CanonicalFile tempDirectory, Collection<BasicTokenElementInfo> tokenElementInfos, FunctionWithException<String, String, ConQATException> uniformPathTransformer) throws IOException, ConQATException {
        Path tempDirectoryPath = tempDirectory.toPath();
        Files.createDirectories(tempDirectoryPath, new FileAttribute[0]);
        ArrayList<String> relativeFilePaths = new ArrayList<String>();
        for (BasicTokenElementInfo tokenElementInfo : tokenElementInfos) {
            String uniformPath = (String)uniformPathTransformer.apply((Object)tokenElementInfo.getUniformPath());
            Path path = tempDirectoryPath.resolve(uniformPath);
            FileSystemUtils.writeFileUTF8((Path)path, (String)tokenElementInfo.getText());
            relativeFilePaths.add(tempDirectoryPath.relativize(path).toString());
        }
        return relativeFilePaths;
    }
}

