/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.dart_lint;

import com.teamscale.index.configuration.tools.DartLintConfiguration;
import com.teamscale.index.findings.UpdaterUtils;
import com.teamscale.index.findings.dart_lint.DartLintSynchronizer;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.EFindingEnablement;
import eu.cqse.check.framework.core.option.CheckMappingAndCheckOptionTSVUtils;
import eu.cqse.check.framework.core.registry.CheckMapping;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.conqat.lib.commons.error.FormatException;
import org.conqat.lib.commons.filesystem.FileExtensionFilter;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.io.ProcessUtils;
import org.conqat.lib.commons.resources.Resource;
import org.conqat.lib.commons.string.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.jspecify.annotations.NonNull;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

class DartLintUpdater {
    static final String CONFIG_RESOURCE_DIRECTORY = "server/com.teamscale.index/src/main/resources/com/teamscale/index/configuration/tools/dart-lint/";
    static final String DART_LINT_DESCRIPTION_REGEX = "const\\s+_?desc\\s+=\\s+r?['\"]+(.*?)['\"]+;";
    static final String DART_LINT_DETAILS_REGEX = "const\\s+_?details\\s+=\\s+r?['\"]+(.*?(BAD)*.*?(?:GOOD|OK)*.*?)\n['\"]+;";
    static final Set<String> CHECK_IDS = new HashSet<String>();
    private static final String DART_LINT_CONFIG_FILE = "analysis_options.yml";
    private static final Path DESCRIPTION_DIRECTORY = Path.of("server/com.teamscale.index/check-descriptions/dart-lint/", new String[0]);
    private static final String DART_SDK_REPO_URL = "https://github.com/dart-lang/sdk";
    private static final String RULES_DIR_INSIDE_SDK_REPO = "pkg/linter/lib/src/rules";
    private static final String ALL_LINT_RULES_URL = "https://dart.dev/tools/linter-rules/all";
    private static final String ALL_DIAGNOSTIC_MESSAGES_URL = "https://dart.dev/tools/diagnostic-messages";
    private static final String CHECK_MAPPINGS_FILE = "dart-lint/check-mappings.tsv";
    private static final String DESCRIPTION_FORMAT_REGEX = "['\"]\n.*['\"]";
    private static final String TICKS_CAPTURE_REGEX = "`(.*?)`";

    DartLintUpdater() {
    }

    private static Path getTempWorkingDirectory() throws IOException {
        return FileSystemUtils.getTemporaryDirectory((String)"dart-lint").getPath();
    }

    public static void main(String[] args) throws IOException, FormatException, CheckException {
        DartLintUpdater.getAvailableChecks();
        DartLintUpdater.generateConfigFile();
        DartLintUpdater.getCheckDescriptions();
    }

    static void getAvailableChecks() throws IOException {
        Document doc = Jsoup.connect((String)ALL_LINT_RULES_URL).get();
        Elements yamlElements = doc.select(".dash-light .line");
        for (Element element : yamlElements) {
            String prefix;
            String text = element.text();
            if (!text.startsWith(prefix = "-")) continue;
            CHECK_IDS.add("dart." + StringUtils.stripPrefix((String)text, (String)prefix).trim());
        }
    }

    private static void getCheckDescriptions() throws IOException {
        Path tempWorkingDirectory = DartLintUpdater.getTempWorkingDirectory();
        UpdaterUtils.cloneOrUpdateRepository("https://github.com/dart-lang/sdk.git", tempWorkingDirectory, DartLintSynchronizer.DART_SDK_VERSION.toFullString());
        Path pluginDir = tempWorkingDirectory.resolve(RULES_DIR_INSIDE_SDK_REPO);
        List files = FileSystemUtils.listFilesRecursively((File)pluginDir.toFile(), (FileFilter)new FileExtensionFilter(new String[]{"dart"}));
        Map<String, CheckMapping> defaultMapping = DartLintUpdater.loadCategorizationAndDefaultEnablements();
        List<CheckMapping> ignoredMappings = DartLintUpdater.loadDiagnosticMessages();
        List<CheckMapping> checkMappings = DartLintUpdater.generateCheckMappings(files, defaultMapping);
        DartLintUpdater.writeCheckMappings("check-mappings.tsv", checkMappings);
        DartLintUpdater.writeCheckMappings("diagnostic_messages.tsv", ignoredMappings);
    }

    static List<CheckMapping> loadDiagnosticMessages() throws IOException {
        ArrayList<CheckMapping> mappings = new ArrayList<CheckMapping>();
        Document doc = Jsoup.connect((String)ALL_DIAGNOSTIC_MESSAGES_URL).get();
        Elements yamlElements = doc.select(".toc-entry.nav-item > .nav-link");
        for (Element element : yamlElements) {
            mappings.add(new CheckMapping("dart." + element.text(), "TODO", "TODO", "TODO", null));
        }
        return mappings;
    }

    static List<CheckMapping> generateCheckMappings(List<File> files, Map<String, CheckMapping> defaultMapping) throws IOException {
        ArrayList<CheckMapping> mappings = new ArrayList<CheckMapping>();
        for (File file : files) {
            String checkId = "dart." + FilenameUtils.getBaseName((String)file.toString());
            if (!CHECK_IDS.contains(checkId)) continue;
            CheckMapping emptyMapping = new CheckMapping(checkId, "TODO", "TODO", "TODO", null);
            CheckMapping mapping = defaultMapping.getOrDefault(checkId, emptyMapping);
            mappings.add(DartLintUpdater.createMapping(file, mapping));
        }
        return mappings;
    }

    private static void writeCheckMappings(String fileName, List<CheckMapping> mappings) throws IOException {
        File checkMappings = new File(CONFIG_RESOURCE_DIRECTORY + fileName);
        CheckMappingAndCheckOptionTSVUtils.writeCheckMappingsToFile((File)checkMappings, mappings);
    }

    private static Map<String, CheckMapping> loadCategorizationAndDefaultEnablements() {
        List lines = Resource.of(DartLintConfiguration.class, (String)CHECK_MAPPINGS_FILE).getLines();
        lines.remove(0);
        HashMap<String, CheckMapping> result = new HashMap<String, CheckMapping>();
        for (String line : lines) {
            if (line.trim().isEmpty()) continue;
            String[] columns = line.split("\t");
            String checkId = columns[0].trim();
            String comments = "";
            if (columns.length > 5) {
                comments = columns[5].trim();
            }
            String upstreamURL = "";
            if (columns.length > 6) {
                upstreamURL = columns[6].trim();
            }
            result.put(checkId, new CheckMapping(checkId, columns[1].trim(), columns[2].trim(), columns[3].trim(), EFindingEnablement.valueOf((String)columns[4].toUpperCase().trim()), comments, upstreamURL, false));
        }
        return result;
    }

    static @NonNull CheckMapping createMapping(File file, CheckMapping defaultMapping) throws IOException {
        String content = FileSystemUtils.readFile((File)file, (Charset)FileSystemUtils.SYSTEM_CHARSET);
        Matcher matcherDetails = Pattern.compile(DART_LINT_DETAILS_REGEX, 32).matcher(content);
        if (!matcherDetails.find()) {
            throw new IOException("Dart File: " + DartLintUpdater.getLintRulePageUrl(file) + " could not be parsed correctly.");
        }
        String checkId = defaultMapping.checkId;
        Matcher matcherDesc = Pattern.compile(DART_LINT_DESCRIPTION_REGEX, 32).matcher(content);
        FileSystemUtils.writeFile((Path)DESCRIPTION_DIRECTORY.resolve(checkId + ".md"), (String)matcherDetails.group(1), (Charset)FileSystemUtils.SYSTEM_CHARSET);
        String description = DartLintUpdater.handleMissingDescriptions(file, matcherDesc);
        return new CheckMapping(checkId, description, defaultMapping.category, defaultMapping.group, defaultMapping.defaultEnablement, defaultMapping.comments, defaultMapping.upstreamURL, false);
    }

    private static String handleMissingDescriptions(File file, Matcher matcherDesc) throws IOException {
        if (matcherDesc.find()) {
            return DartLintUpdater.formatMatchedGroup(matcherDesc.group(1));
        }
        switch (file.getName()) {
            case "sized_box_shrink_expand.dart": {
                break;
            }
            default: {
                throw new IOException("Description not Found: " + DartLintUpdater.getLintRulePageUrl(file));
            }
        }
        return "Use sized box expand/shrink constructors";
    }

    static @NonNull String formatMatchedGroup(String unformattedDescription) {
        if (unformattedDescription.equals("$_descPrefix.")) {
            return "Avoid unsafe HTML APIs";
        }
        String description = unformattedDescription.replaceAll(DESCRIPTION_FORMAT_REGEX, "").replace("\n", "").replaceAll(TICKS_CAPTURE_REGEX, "'$1'");
        return StringUtils.stripSuffix((String)description, (String)".").trim();
    }

    private static String getLintRulePageUrl(File file) {
        return "https://github.com/dart-lang/sdk/blob/main/pkg/linter/lib/src/rules/" + file.getName();
    }

    static File generateConfigFile() throws IOException {
        Path workingDir = DartLintUpdater.getTempWorkingDirectory();
        FileSystemUtils.ensureDirectoryExists((Path)workingDir);
        File configFile = DartLintUpdater.writeYamlConfigFileToDir(workingDir);
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.directory(workingDir.toFile());
        builder.command("dart", "pub", "add", "--dev", "lints");
        ProcessUtils.execute((ProcessBuilder)builder);
        return configFile;
    }

    private static @NonNull File writeYamlConfigFileToDir(Path workingDir) throws IOException {
        HashMap analysisOptions = new HashMap();
        HashMap<String, Object[]> linter = new HashMap<String, Object[]>();
        linter.put("rules", CHECK_IDS.toArray());
        analysisOptions.put("linter", linter);
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        options.setPrettyFlow(true);
        File configFile = Path.of(workingDir.toFile().getCanonicalPath(), DART_LINT_CONFIG_FILE).toFile();
        try (FileWriter writer = new FileWriter(configFile);){
            new Yaml(options).dump(analysisOptions, (Writer)writer);
        }
        return configFile;
    }
}

