/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.flake8;

import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.index.configuration.tools.Flake8Configuration;
import com.teamscale.index.findings.FindingsSynchronizingAnalyzingStepBase;
import com.teamscale.index.findings.PythonLintingUtils;
import com.teamscale.index.findings.flake8.Flake8Runner;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.scanner.ELanguage;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.filesystem.CanonicalFile;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.filesystem.TemporaryDirectory;
import org.conqat.lib.commons.string.LineOffsetConverter;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.NonNull;

public class Flake8Synchronizer
extends FindingsSynchronizingAnalyzingStepBase {
    private static final String TEMP_DIR_NAME = "TeamscaleFlake8";
    public static final String CHECKS_PARAMETER = "checks";
    public static final String CHECK_OPTIONS_PARAMETER = "check-options";
    public static final String MAX_LINE_LENGTH_OPTION = "max-line-length";
    public static final String INDENT_SIZE_OPTION = "indent-size";
    public static final String MAX_DOC_LINE_LENGTH_OPTION = "max-doc-line-length";
    @VisibleForTesting
    public static final String FINDING_PARTITION = "flake8";
    @StepParameter(value="check-options", optional=true)
    private final CodeScopeAware<PairList<String, String>> checkOptions = CodeScopeAware.defaultCodeScopeWithValue((Object)new PairList());
    @StepParameter(value="checks")
    private final CodeScopeAware<Set<String>> selectedChecks = CodeScopeAware.defaultCodeScopeWithValue(new HashSet());
    @StepParameter(value="max-line-length")
    private CodeScopeAware<Integer> maxLineLength = CodeScopeAware.defaultCodeScopeWithValue((Object)79);
    @StepParameter(value="max-doc-line-length")
    private CodeScopeAware<Integer> maxDocLineLength = CodeScopeAware.defaultCodeScopeWithValue((Object)-1);
    @StepParameter(value="indent-size")
    private CodeScopeAware<Integer> indentSize = CodeScopeAware.defaultCodeScopeWithValue((Object)4);
    private static final Logger LOGGER = LogManager.getLogger();

    public void execute() throws Exception {
        CodeScopeAware<List<TokenElementInfo>> elementsByCodeScope = this.getAddedOrChangedTokenElementsByCodeScope(Set.of(ELanguage.PYTHON));
        CodeScopeAware findingsByCodeScope = CodeScopeAware.empty();
        for (CodeScopeName codeScopeName : elementsByCodeScope.getCodeScopeNames()) {
            List elementsToAnalyze = (List)elementsByCodeScope.getValue(codeScopeName);
            if (elementsToAnalyze.isEmpty()) {
                LOGGER.info("No Python files in change set for code scope '{}'. Skipping Flake8 execution.", (Object)codeScopeName);
                findingsByCodeScope.setValue(codeScopeName, (Object)new ListMap());
                continue;
            }
            Set selectedChecksForCodeScope = (Set)this.selectedChecks.getValue(codeScopeName);
            if (selectedChecksForCodeScope.isEmpty()) {
                LOGGER.info("No checks activated for code scope '{}'. Skipping Flake8 execution.", (Object)codeScopeName);
                findingsByCodeScope.setValue(codeScopeName, (Object)new ListMap());
                continue;
            }
            findingsByCodeScope.setValue(codeScopeName, this.executeForCodeScope(codeScopeName, elementsToAnalyze, selectedChecksForCodeScope));
        }
        this.synchronizeFindingsForTokenElementIndexDelta((CodeScopeAware<ListMap<String, IndexFinding>>)findingsByCodeScope, FINDING_PARTITION);
    }

    private ListMap<String, IndexFinding> executeForCodeScope(CodeScopeName codeScopeName, List<TokenElementInfo> elementsToAnalyze, Set<String> selectedChecks) throws IOException {
        try (TemporaryDirectory tmpDir = Flake8Synchronizer.getTempDirectory((String)TEMP_DIR_NAME);){
            CanonicalFile tempDirectory = new CanonicalFile(tmpDir.getPath().toFile());
            LOGGER.info("Processing {} files from code scope '{}' with {} enabled checks in temporary directory {}", (Object)elementsToAnalyze.size(), (Object)codeScopeName, (Object)selectedChecks.size(), (Object)tempDirectory.getCanonicalPath());
            Flake8Runner.prepareWorkingDirAndConfig(tempDirectory, selectedChecks, this.getCheckOptions(codeScopeName));
            Map<String, TokenElementInfo> generatedFilenameToElement = PythonLintingUtils.prepareFilesForAnalysis(elementsToAnalyze, tempDirectory);
            List<Flake8Runner.FindingInfo> reportedResults = Flake8Runner.executeAnalysis(tempDirectory);
            ListMap<String, IndexFinding> listMap = this.processResults(reportedResults, generatedFilenameToElement, codeScopeName);
            return listMap;
        }
    }

    private @NonNull Map<String, String> getCheckOptions(CodeScopeName codeScopeName) {
        HashMap<String, String> options = new HashMap<String, String>();
        if ((Integer)this.maxLineLength.getValue(codeScopeName) > 0) {
            options.put(MAX_LINE_LENGTH_OPTION, String.valueOf(this.maxLineLength.getValue(codeScopeName)));
        }
        if ((Integer)this.maxDocLineLength.getValue(codeScopeName) > 0) {
            options.put("max-doc-length", String.valueOf(this.maxDocLineLength.getValue(codeScopeName)));
        }
        if ((Integer)this.indentSize.getValue(codeScopeName) > 0) {
            options.put(INDENT_SIZE_OPTION, String.valueOf(this.indentSize.getValue(codeScopeName)));
        }
        ((PairList)this.checkOptions.getValue(codeScopeName)).forEach(options::put);
        return options;
    }

    private ListMap<String, IndexFinding> processResults(@NonNull List<Flake8Runner.FindingInfo> reportedResults, @NonNull Map<String, TokenElementInfo> generatedFilenameToElement, CodeScopeName codeScopeName) {
        Map<String, List<Flake8Runner.FindingInfo>> groupedResults = reportedResults.stream().collect(Collectors.groupingBy(Flake8Runner.FindingInfo::path));
        ListMap indexFindings = new ListMap();
        for (Map.Entry<String, List<Flake8Runner.FindingInfo>> resultsPerFile : groupedResults.entrySet()) {
            CCSMAssert.isFalse((StringUtils.isEmpty((String)resultsPerFile.getKey()) || CollectionUtils.isNullOrEmpty((Collection)resultsPerFile.getValue()) ? 1 : 0) != 0, (String)"Result group must not be empty");
            String fileName = FileSystemUtils.getLastPathSegment((String)resultsPerFile.getKey());
            TokenElementInfo tokenElement = generatedFilenameToElement.get(fileName);
            if (tokenElement == null) {
                LOGGER.error("Unmapped file '{}' in Flake8 results. Skipping file.", (Object)fileName);
                continue;
            }
            this.convertResultsToIndexFindings(resultsPerFile.getValue(), tokenElement, (ListMap<String, IndexFinding>)indexFindings, codeScopeName);
        }
        return indexFindings;
    }

    private void convertResultsToIndexFindings(@NonNull List<Flake8Runner.FindingInfo> fileResults, @NonNull TokenElementInfo tokenElement, @NonNull ListMap<String, IndexFinding> indexFindings, CodeScopeName codeScopeName) {
        LineOffsetConverter offsetConverter = new LineOffsetConverter(tokenElement.getText());
        for (Flake8Runner.FindingInfo finding : fileResults) {
            String checkId = Flake8Configuration.addCheckIdPrefix(finding.checkId());
            String uniformPath = tokenElement.getUniformPath();
            if (!((Set)this.selectedChecks.getValue(codeScopeName)).contains(checkId)) {
                LOGGER.error("Flake8 result with unknown checkID '{}' in file '{}'. Skipping finding.", (Object)checkId, (Object)uniformPath);
                continue;
            }
            int lineNumber = finding.row();
            String message = Flake8Runner.shortenAndFilterFindingMessage(finding.message());
            IndexFinding indexFinding = Flake8Synchronizer.createIndexFindingWithGuidelineMapping(message, uniformPath, checkId, "Flake8", lineNumber, lineNumber, offsetConverter, (UnmodifiableSet<ELanguage>)EAnalysisTool.FLAKE8.getSupportedLanguages());
            indexFindings.add((Object)uniformPath, (Object)indexFinding);
        }
    }

    public static void verifyFlake8Version() throws ConQATException {
        Flake8Runner.verifyFlake8Version();
    }
}

