/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.golangcilint;

import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.index.findings.LintFindingsSynchronizerBase;
import com.teamscale.index.findings.golangcilint.GoLangCILintConfigurationFile;
import com.teamscale.index.findings.golangcilint.GoLangCILintException;
import com.teamscale.index.findings.golangcilint.GoLangCILintReportReader;
import com.teamscale.index.findings.golangcilint.GoLangCILintRunner;
import com.teamscale.index.findings.golangcilint.GoLangCILintUtils;
import eu.cqse.check.framework.scanner.ELanguage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.filesystem.CanonicalFile;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.filesystem.TemporaryDirectory;
import org.conqat.lib.commons.resources.Resource;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.NonNull;

@AnalysisStep(hints={EAnalysisStepParameter.MERGE_INPUT_DELTAS})
public class GoLangCILintSynchronizer
extends LintFindingsSynchronizerBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String BASE_CONFIGURATION_FILE = ".golangci.json";
    private static final String LINTER_TEMPORARY_FOLDER = "golangci-lint-executor";
    private static final String GO_MODULES_FILE = "go.mod";
    private static final String MISSING_GO_FILE_ERROR = "Running error: context loading failed: no go files to analyze: running `go mod tidy` may solve the problem";
    private static final String GO_VERISON_IN_MODULES_FILE = "1.23.1";
    public static final String FINDING_PARTITION = "golangci-lint-internal";
    public static final String CHECKS_PARAMETER = "checks";
    public static final String CHECK_OPTIONS_PARAMETER = "check-options";
    public static final String CHECK_OPTION_TYPES_PARAMETER = "check-option-types";
    public static final String CHECK_OPTIONS_VALUES_PARAMETER = "check-option-values";
    private static final Set<String> SUPPORTED_FILE_EXTENSIONS = Set.of(ELanguage.GO.getFileExtensions());
    @StepParameter(value="checks")
    private final CodeScopeAware<List<String>> selectedChecks = CodeScopeAware.defaultCodeScopeWithValue(new ArrayList());
    @StepParameter(value="check-options", optional=true)
    private final CodeScopeAware<List<String>> selectedOptions = CodeScopeAware.defaultCodeScopeWithValue(new ArrayList());
    @StepParameter(value="check-option-types", optional=true)
    private final CodeScopeAware<List<String>> checkOptionTypes = CodeScopeAware.defaultCodeScopeWithValue(new ArrayList());
    @StepParameter(value="check-option-values", optional=true)
    private final CodeScopeAware<List<String>> checkOptionValues = CodeScopeAware.defaultCodeScopeWithValue(new ArrayList());
    private static final String TEMP_CACHE_DIRECTORY_PREFIX = "golangci-lint-cache";

    public GoLangCILintSynchronizer() {
        super(FINDING_PARTITION);
    }

    @Override
    protected boolean pathIsIncludedInAnalysis(String uniformPath) {
        return SUPPORTED_FILE_EXTENSIONS.contains(UniformPathUtils.getExtension((String)uniformPath));
    }

    public static String getContentOfBaseConfigurationFile() {
        Resource resource = Resource.of(GoLangCILintSynchronizer.class, (String)BASE_CONFIGURATION_FILE);
        return resource.getContent();
    }

    private static void createTemporaryFiles(BasicTokenElementInfo tokenElement, CanonicalFile tempDirectory) throws IOException {
        CanonicalFile file = new CanonicalFile((File)tempDirectory, tokenElement.getUniformPath());
        String content = GoLangCILintSynchronizer.getContent(tokenElement);
        FileSystemUtils.writeFileUTF8((Path)file.toPath(), (String)content);
        CanonicalFile goModFile = new CanonicalFile((File)tempDirectory, GO_MODULES_FILE);
        if (!goModFile.exists()) {
            FileSystemUtils.writeFileUTF8((Path)goModFile.toPath(), (String)"module %s\ngo %s".formatted(LINTER_TEMPORARY_FOLDER, GO_VERISON_IN_MODULES_FILE));
        }
    }

    private static String getContent(BasicTokenElementInfo tokenElement) {
        if (tokenElement.getText().contains("internal/") || tokenElement.getText().contains("/internal")) {
            String text = tokenElement.getText().replace("/internal", "/teamscale");
            return text.replace("internal/", "teamscale/");
        }
        return tokenElement.getText();
    }

    private String generateGoLangCILintConfigFile(CodeScopeName codeScopeName) throws JsonSerializationException {
        GoLangCILintConfigurationFile configuration = GoLangCILintUtils.generateConfiguration((List)this.selectedChecks.getValue(codeScopeName), (List)this.selectedOptions.getValue(codeScopeName), (List)this.checkOptionTypes.getValue(codeScopeName), (List)this.checkOptionValues.getValue(codeScopeName));
        return JsonUtils.serializeToJSON((Object)configuration);
    }

    @Override
    protected Optional<String> executeLint(Collection<BasicTokenElementInfo> tokenElements, CodeScopeName codeScopeName) throws ConQATException {
        Optional<String> optional;
        block8: {
            TemporaryDirectory tempCacheDir = FileSystemUtils.getTemporaryDirectory((String)TEMP_CACHE_DIRECTORY_PREFIX);
            try {
                optional = this.executeLint(tokenElements, codeScopeName, tempCacheDir);
                if (tempCacheDir == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (tempCacheDir != null) {
                        try {
                            tempCacheDir.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.error("Could not create temporary directory", (Throwable)e);
                    return Optional.empty();
                }
            }
            tempCacheDir.close();
        }
        return optional;
    }

    private @NonNull Optional<String> executeLint(Collection<BasicTokenElementInfo> tokenElements, CodeScopeName codeScopeName, TemporaryDirectory tempCacheDir) throws JsonSerializationException {
        try {
            GoLangCILintRunner.verifyLinterInstallation();
        }
        catch (GoLangCILintException e) {
            LOGGER.error("Could not run GoLangCILint over changed files.", (Throwable)e);
            return Optional.empty();
        }
        StringBuffer output = new StringBuffer();
        String configFileContent = this.generateGoLangCILintConfigFile(codeScopeName);
        try {
            this.executeInParallelBatches(new ArrayList<BasicTokenElementInfo>(tokenElements), inputKeyBatch -> {
                String result = GoLangCILintSynchronizer.lintSingleFile(inputKeyBatch, configFileContent, tempCacheDir);
                output.append(result + "\n");
            }, 1);
        }
        catch (ExecutionException e) {
            LOGGER.error("Could not perform parallel execution of GoLangCILintSynchronizer", (Throwable)e);
        }
        return Optional.of(output.toString());
    }

    private static String lintSingleFile(List<BasicTokenElementInfo> inputKeyBatch, String configFileContent, TemporaryDirectory tempCacheDir) {
        String string;
        block9: {
            BasicTokenElementInfo tokenElement = (BasicTokenElementInfo)CollectionUtils.getAny(inputKeyBatch);
            CCSMAssert.isNotNull((Object)tokenElement);
            TemporaryDirectory tmpDir = GoLangCILintSynchronizer.getTempDirectory((String)LINTER_TEMPORARY_FOLDER);
            try {
                CanonicalFile tempSrcDirectory = new CanonicalFile(tmpDir.getPath().toFile());
                GoLangCILintSynchronizer.createTemporaryFiles(tokenElement, tempSrcDirectory);
                CanonicalFile configFile = new CanonicalFile((File)tempSrcDirectory, BASE_CONFIGURATION_FILE);
                FileSystemUtils.writeFileUTF8((Path)configFile.toPath(), (String)configFileContent);
                GoLangCILintRunner.ExecutionResult lintingResult = GoLangCILintRunner.runLinterOnFiles(tempSrcDirectory, tempCacheDir);
                if (!lintingResult.succeeded()) {
                    GoLangCILintSynchronizer.reportLintingErrorsAndWarnings(lintingResult);
                }
                string = lintingResult.output();
                if (tmpDir == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (tmpDir != null) {
                        try {
                            tmpDir.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.error("Could not run GoLangCILint over changed files.", (Throwable)e);
                    return "";
                }
            }
            tmpDir.close();
        }
        return string;
    }

    private static void reportLintingErrorsAndWarnings(GoLangCILintRunner.ExecutionResult result) {
        for (String line : StringUtils.splitLines((String)result.errorsAndWarnings())) {
            if (line.startsWith("level=warning")) {
                LOGGER.warn(line);
                continue;
            }
            if (line.contains(MISSING_GO_FILE_ERROR)) continue;
            LOGGER.error(line);
        }
    }

    @Override
    protected ListMap<String, IndexFinding> parseReport(String reportContent) throws ConQATException {
        GoLangCILintReportReader reportReader = new GoLangCILintReportReader(this.pathLookupIndex.createLoggingPreloadedLookup());
        return reportReader.parseReport(reportContent);
    }
}

