/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issue_reference;

import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfigurationUtils;
import com.teamscale.index.issue_reference.SpecItemReferenceElement;
import com.teamscale.index.issue_reference.SpecItemRelationReference;
import com.teamscale.index.requirements_tracing.index.SpecItemIndex;
import com.teamscale.index.resource.retrieval_strategy.WorkItemHistoryAccessOptionExpander;
import com.teamscale.wia.SpecItem;
import com.teamscale.wia.TeamscaleIssueId;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.wia.LinkRule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class SpecItemVerificationRetriever {
    private final ProjectStorageSystem projectStorage;
    private final VerifiesRetriever givenVerifiesRetriever;
    private final VerifiedByRetriever verifiedByGivenRetriever;
    private final WorkItemHistoryAccessOptionExpander historyOptionExpander;

    public SpecItemVerificationRetriever(GlobalStorageSystem globalStorage, ProjectStorageSystem projectStorage) {
        this.projectStorage = projectStorage;
        this.givenVerifiesRetriever = new VerifiesRetriever(globalStorage, projectStorage);
        this.verifiedByGivenRetriever = new VerifiedByRetriever(globalStorage, projectStorage);
        this.historyOptionExpander = new WorkItemHistoryAccessOptionExpander(projectStorage);
    }

    public Set<SpecItemReferenceElement> retrieveSpecItemsAreVerifiedBy(TeamscaleIssueId specItemId, HistoryAccessOption historyOption) throws StorageException {
        return this.targetsOrNull(this.retrieveSpecItemReferences(List.of(specItemId), historyOption, this.givenVerifiesRetriever, false));
    }

    public List<SpecItemRelationReference> retrieveSpecItemsAreVerifiedBy(List<TeamscaleIssueId> specItemIds, HistoryAccessOption historyOption, boolean addEmptyOrNull) throws StorageException {
        return this.retrieveSpecItemReferences(specItemIds, historyOption, this.givenVerifiesRetriever, addEmptyOrNull);
    }

    public List<SpecItemRelationReference> retrieveSpecItemsAreVerifying(List<TeamscaleIssueId> specItemIds, HistoryAccessOption historyOption, boolean addEmptyOrNull) throws StorageException {
        return this.retrieveSpecItemReferences(specItemIds, historyOption, this.verifiedByGivenRetriever, addEmptyOrNull);
    }

    public Set<SpecItemReferenceElement> retrieveSpecItemsAreVerifying(TeamscaleIssueId specItemId, HistoryAccessOption historyOption) throws StorageException {
        return this.targetsOrNull(this.retrieveSpecItemReferences(List.of(specItemId), historyOption, this.verifiedByGivenRetriever, false));
    }

    private Set<SpecItemReferenceElement> targetsOrNull(List<SpecItemRelationReference> result) {
        if (result == null) {
            return null;
        }
        return result.stream().filter(Objects::nonNull).map(SpecItemRelationReference::targets).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private List<@Nullable SpecItemRelationReference> retrieveSpecItemReferences(Collection<TeamscaleIssueId> specItemIds, HistoryAccessOption historyAccessOption, SpecItemReferenceRetriever referenceRetriever, boolean addEmptyOrNull) throws StorageException {
        ArrayList<SpecItemRelationReference> result = null;
        for (TeamscaleIssueId specItemId : specItemIds) {
            HistoryAccessOption specItemHistoryOption;
            @Nullable SpecItemRelationReference relation = this.retrieveSpecItemReferencesFromHistory(specItemId, specItemHistoryOption = this.historyAccessOptionsFor(specItemId, historyAccessOption), referenceRetriever);
            if (relation == null && !addEmptyOrNull) continue;
            if (result == null) {
                result = new ArrayList<SpecItemRelationReference>();
            }
            if (!addEmptyOrNull && relation.targets().isEmpty()) continue;
            result.add(relation);
        }
        return result;
    }

    private HistoryAccessOption historyAccessOptionsFor(TeamscaleIssueId specItemId, HistoryAccessOption originalOption) throws StorageException {
        return this.historyOptionExpander.resolveHistoryAccessOptionForConnector(originalOption, specItemId.getConnectorId());
    }

    private @Nullable SpecItemRelationReference retrieveSpecItemReferencesFromHistory(TeamscaleIssueId specItemId, HistoryAccessOption specItemHistoryOption, SpecItemReferenceRetriever referenceRetriever) throws StorageException {
        SpecItemIndex specItemIndex = (SpecItemIndex)this.projectStorage.openProjectIndex(SpecItemIndex.class, specItemHistoryOption);
        SpecItem sourceSpecItem = (SpecItem)specItemIndex.getIssue(specItemId);
        if (sourceSpecItem == null) {
            return null;
        }
        return referenceRetriever.retrieve(sourceSpecItem.getId(), specItemHistoryOption);
    }

    private static class VerifiesRetriever
    extends VerifiesRetrieverBase {
        private VerifiesRetriever(GlobalStorageSystem globalStorage, ProjectStorageSystem projectStorage) {
            super(globalStorage, projectStorage);
        }

        @Override
        protected SpecItemRelationReference retrieveFor(SpecItem specItem, SpecItemIndex index) throws StorageException {
            List<LinkRule> verifiesRelations = this.getVerifiesRelationsFor(specItem);
            Set<SpecItem> verifiedItems = this.retrieveLinkedItemsWithMatchingRelationAndTargetType(specItem, verifiesRelations, index);
            return new SpecItemRelationReference(SpecItemReferenceElement.of(specItem), verifiedItems.stream().map(SpecItemReferenceElement::of).collect(Collectors.toSet()));
        }
    }

    private static class VerifiedByRetriever
    extends VerifiesRetrieverBase {
        private VerifiedByRetriever(GlobalStorageSystem globalStorage, ProjectStorageSystem projectStorage) {
            super(globalStorage, projectStorage);
        }

        @Override
        protected SpecItemRelationReference retrieveFor(SpecItem specItem, SpecItemIndex index) throws StorageException {
            List<LinkRule> isVerifiedByRelations = this.getInverseRules(this.getVerifiesRelationsFor(specItem));
            Set<SpecItem> verifiedBy = this.retrieveLinkedItemsWithMatchingRelationAndTargetType(specItem, isVerifiedByRelations, index);
            return new SpecItemRelationReference(SpecItemReferenceElement.of(specItem), verifiedBy.stream().map(SpecItemReferenceElement::of).collect(Collectors.toSet()));
        }
    }

    private static interface SpecItemReferenceRetriever {
        public @Nullable SpecItemRelationReference retrieve(TeamscaleIssueId var1, HistoryAccessOption var2) throws StorageException;
    }

    private static abstract class VerifiesRetrieverBase
    implements SpecItemReferenceRetriever {
        protected final Map<String, List<LinkRule>> verifiesRulesByRepository;
        protected final GlobalStorageSystem globalStorage;
        protected final ProjectStorageSystem projectStorage;

        private VerifiesRetrieverBase(GlobalStorageSystem globalStorage, ProjectStorageSystem projectStorage) {
            this.globalStorage = globalStorage;
            this.projectStorage = projectStorage;
            this.verifiesRulesByRepository = new HashMap<String, List<LinkRule>>();
        }

        protected @NonNull Set<SpecItem> retrieveLinkedItemsWithMatchingRelationAndTargetType(SpecItem specItem, List<LinkRule> linkRules, SpecItemIndex specItemIndex) throws StorageException {
            HashSet<SpecItem> result = new HashSet<SpecItem>();
            for (LinkRule rule : linkRules) {
                if (!rule.hasSourceItemType(specItem)) continue;
                Set linkedIssuesIds = rule.getRelations().stream().flatMap(relation -> specItem.getLinkedSpecItems(relation).stream()).collect(Collectors.toSet());
                for (TeamscaleIssueId linkedIssueId : linkedIssuesIds) {
                    SpecItem linkedItem = (SpecItem)specItemIndex.getIssue(linkedIssueId);
                    if (linkedItem == null || !rule.hasTargetItemType(linkedItem)) continue;
                    result.add(linkedItem);
                }
            }
            return result;
        }

        protected List<LinkRule> getInverseRules(List<LinkRule> ofRules) {
            return ofRules.stream().map(LinkRule::inverse).collect(Collectors.toList());
        }

        protected List<LinkRule> getVerifiesRelationsFor(SpecItem item) throws StorageException {
            String connectorId = item.getId().getConnectorId();
            List result = this.verifiesRulesByRepository.get(connectorId);
            if (result == null) {
                ConnectorConfiguration connector = Objects.requireNonNull(ProjectConfigurationUtils.getProjectConfiguration((ProjectStorageSystem)this.projectStorage)).getConnectorByIdentifier(connectorId);
                List optionList = CollectionUtils.parseMultiValueStringToList((String)connector.getOptionValue("Verifies Relationships"), (boolean)true);
                try {
                    result = LinkRule.parse((Collection)optionList);
                }
                catch (CheckException e) {
                    throw new IllegalArgumentException("No valid rule from mapping spec item relations to verifies relations configured.", e);
                }
                this.verifiesRulesByRepository.put(connectorId, result);
            }
            return result;
        }

        @Override
        public @Nullable SpecItemRelationReference retrieve(TeamscaleIssueId specItemId, HistoryAccessOption historyOption) throws StorageException {
            SpecItemIndex specItemIndex = (SpecItemIndex)this.projectStorage.openProjectIndex(SpecItemIndex.class, historyOption);
            @Nullable SpecItem specItem = (SpecItem)specItemIndex.getIssue(specItemId);
            if (specItem == null) {
                return null;
            }
            return this.retrieveFor(specItem, specItemIndex);
        }

        protected abstract SpecItemRelationReference retrieveFor(SpecItem var1, SpecItemIndex var2) throws StorageException;
    }
}

