/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues;

import com.teamscale.wia.ETextValueMode;
import com.teamscale.wia.TeamscaleIssue;
import com.teamscale.wia.TeamscaleIssueId;
import com.teamscale.wia.WorkItemDescriberBase;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.conqat.engine.persistence.index.keyed.EKeyedObjectType;
import org.conqat.engine.persistence.index.keyed.KeyedObjectDescriberBase;
import org.conqat.lib.commons.string.StringUtils;

public class IssueDescriber<T extends TeamscaleIssue>
extends KeyedObjectDescriberBase<T> {
    private final WorkItemDescriberBase<T> delegate;
    public static final String AFFECTED_FILES_KEY = "affectedFiles";
    private static final Set<String> FILTERED_KEYS = Set.of("description");

    public IssueDescriber() {
        this(new WorkItemDescriberBase());
    }

    protected IssueDescriber(WorkItemDescriberBase<T> delegate) {
        this.delegate = delegate;
    }

    public List<String> getUnmanagedKeys() {
        return List.of(AFFECTED_FILES_KEY);
    }

    public EKeyedObjectType getType(String key) {
        if (AFFECTED_FILES_KEY.equals(key)) {
            return EKeyedObjectType.NUMBER;
        }
        return super.getType(key);
    }

    public String getId(T issue) {
        return IssueDescriber.getId(issue.getId());
    }

    public static String getId(TeamscaleIssueId id) {
        return id.getInternalId();
    }

    public String ensureIsAbsoluteId(String objectId, String relativeId) {
        if (StringUtils.isEmpty((String)relativeId) || TeamscaleIssueId.isValidInternalId((String)relativeId)) {
            return relativeId;
        }
        return TeamscaleIssueId.fromInternalId((String)objectId).withExternalId(relativeId).getInternalId();
    }

    public List<String> getKeys(T issue) {
        List keys = this.delegate.getKeys(issue);
        keys.removeAll(FILTERED_KEYS);
        return keys;
    }

    public Function<T, String> getValueAccessor(String key) {
        return t -> (String)this.delegate.getValueAccessor(key).apply(t, ETextValueMode.RAW);
    }

    public Comparator<T> getValueComparator(String key) {
        Comparator valueComparator = this.delegate.getValueComparator(key);
        if (valueComparator == null) {
            return Comparator.comparing(issue -> issue.getAdditionalFieldValue(key), Comparator.nullsFirst(IssueDescriber.getComparator((EKeyedObjectType)this.getType(key))));
        }
        return valueComparator;
    }
}

