/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues.codebeamer.client;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.rest.client.IRetrofitApi;
import com.teamscale.index.issues.codebeamer.client.model.Association;
import com.teamscale.index.issues.codebeamer.client.model.AssociationType;
import com.teamscale.index.issues.codebeamer.client.model.MarkupRequest;
import com.teamscale.index.issues.codebeamer.client.model.Tracker;
import com.teamscale.index.issues.codebeamer.client.model.TrackerItemField;
import com.teamscale.index.issues.codebeamer.client.model.TrackerItemRelationsResult;
import com.teamscale.index.issues.codebeamer.client.model.TrackerItemSearchResult;
import com.teamscale.index.issues.codebeamer.client.model.TrackerItemsRequest;
import com.teamscale.index.issues.codebeamer.client.model.User;
import com.teamscale.index.issues.codebeamer.client.model.references.ProjectReference;
import java.util.List;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;

public interface ICodebeamerClient
extends IRetrofitApi {
    public static final String API_BASE_PATH = "api/v3";

    @GET(value="api/v3/items/query")
    public TrackerItemSearchResult getTrackerItemsByQueryString(@Query(value="queryString") String var1, @Query(value="page") int var2, @Query(value="pageSize") int var3) throws ServiceCallException;

    @POST(value="api/v3/items/relations")
    public Call<List<TrackerItemRelationsResult>> getTrackerItemRelations(@Body TrackerItemsRequest var1);

    @GET(value="api/v3/associations/types")
    public Call<List<AssociationType>> getAssociationTypes();

    @GET(value="api/v3/items/{trackerItemId}/fields")
    public Call<TrackerItemField> getTrackerItemFields(@Path(value="trackerItemId") int var1);

    @GET(value="api/v3/associations/{associationId}")
    public Call<Association> getAssociation(@Path(value="associationId") int var1);

    @GET(value="api/v3/projects")
    public Call<List<ProjectReference>> getProjects();

    @GET(value="api/v3/trackers/{trackerId}")
    public Call<Tracker> getTracker(@Path(value="trackerId") int var1);

    @GET(value="api/v3/users/findByName")
    public Call<User> getUser(@Query(value="name") String var1);

    @POST(value="api/v3/projects/{projectId}/wiki2html")
    @Headers(value={"Content-Type: application/json", "Accept: text/html"})
    public Call<String> wiki2html(@Path(value="projectId") int var1, @Body MarkupRequest var2);
}

