/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues.updater;

import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.index.requirements_tracing.index.SpecItemChangesIndex;
import com.teamscale.index.requirements_tracing.index.TempWorkItemIndex;
import com.teamscale.wia.TeamscaleIssue;
import com.teamscale.wia.TeamscaleIssueId;
import java.util.ArrayList;
import java.util.List;
import org.conqat.engine.persistence.store.StorageException;

public abstract class IssueTrackerContentUpdaterBase<T extends TeamscaleIssue>
extends ChangeProcessorAnalysisStep {
    public static final String WORK_ITEM_INDEX_PLACEHOLDER = "<workItemIndexNamePlaceholder>";
    @IndexAccess(value=EIndexAccessMode.READ_ONLY, indexName="temp-spec-items")
    private TempWorkItemIndex tempWorkItemIndex;
    @DeltaSource(value=SpecItemChangesIndex.class, indexName="single-specitemchanges")
    private KeyDelta changeDelta;
    public static final String CONNECTOR_ID_PARAMETER = "connector-id";
    @StepParameter(value="connector-id")
    private String connectorId;

    public String getConnectorIdentifier() {
        return this.connectorId;
    }

    public void execute() throws Exception {
        List<TempWorkItemIndex.WorkItemChange> changes = this.tempWorkItemIndex.getChangesForCommit(this.getSchedulingCommit());
        if (changes.isEmpty()) {
            return;
        }
        this.handleWorkItemChanges(changes);
    }

    private void handleWorkItemChanges(List<TempWorkItemIndex.WorkItemChange> changes) throws StorageException {
        GroupedWorkItemChanges<T> groupedWorkItemChanges = IssueTrackerContentUpdaterBase.groupChangesIntoUpdatesAndDeletions(changes);
        this.handleWorkItemUpdates(groupedWorkItemChanges.updatedItems(), groupedWorkItemChanges.deletedItemIds());
    }

    public static <T extends TeamscaleIssue> GroupedWorkItemChanges<T> groupChangesIntoUpdatesAndDeletions(List<TempWorkItemIndex.WorkItemChange> changes) {
        ArrayList<TeamscaleIssue> updatedItems = new ArrayList<TeamscaleIssue>();
        ArrayList<TeamscaleIssueId> deletedItemIds = new ArrayList<TeamscaleIssueId>();
        block4: for (TempWorkItemIndex.WorkItemChange change : changes) {
            switch (change.getChangeType()) {
                case UPDATE: {
                    TeamscaleIssue updatedItem = change.getUpdatedItem();
                    updatedItems.add(updatedItem);
                    continue block4;
                }
                case DELETION: {
                    deletedItemIds.add(change.getWorkItemId());
                    continue block4;
                }
            }
            throw new UnsupportedOperationException("Unexpected value: " + String.valueOf((Object)change.getChangeType()));
        }
        return new GroupedWorkItemChanges(updatedItems, deletedItemIds);
    }

    protected abstract void handleWorkItemUpdates(List<T> var1, List<TeamscaleIssueId> var2) throws StorageException;

    public record GroupedWorkItemChanges<T extends TeamscaleIssue>(List<T> updatedItems, List<TeamscaleIssueId> deletedItemIds) {
    }
}

