/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.metrics.threshold;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.analysis.configuration.index.model.EvaluatedMetricThreshold;
import com.teamscale.core.analysis.configuration.index.model.MetricThresholdConfigurationException;
import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.metrics.schema.MetricSchemaRetrieverFactory;
import com.teamscale.index.metrics.threshold.MetricThresholdEvaluator;
import com.teamscale.index.thresholds.ProjectThresholdConfigurationUtils;
import org.conqat.engine.persistence.store.StorageException;

public class EvaluatedMetricThresholdPath {
    @JsonProperty(value="thresholdConfigurationName")
    private final String thresholdConfigurationName;
    @JsonProperty(value="thresholdGroupName")
    private final String thresholdGroupName;
    @JsonProperty(value="thresholdDisplayName")
    private final String thresholdDisplayName;
    @JsonProperty(value="metricThreshold")
    private final EvaluatedMetricThreshold metricThreshold;

    private EvaluatedMetricThresholdPath(String thresholdConfigurationName, String thresholdGroupName, String thresholdDisplayName, EvaluatedMetricThreshold metricThreshold) {
        this.thresholdConfigurationName = thresholdConfigurationName;
        this.thresholdGroupName = thresholdGroupName;
        this.thresholdDisplayName = thresholdDisplayName;
        this.metricThreshold = metricThreshold;
    }

    public static EvaluatedMetricThresholdPath create(String thresholdConfigurationName, String thresholdGroupName, String thresholdDisplayName, IStorageInfo storageInfo, MetricSchemaRetrieverFactory schemaRetrieverFactory) throws MetricThresholdConfigurationException, StorageException {
        MetricThresholdEvaluator thresholdEvaluator = ProjectThresholdConfigurationUtils.getThresholdEvaluator(thresholdConfigurationName, storageInfo, schemaRetrieverFactory);
        return new EvaluatedMetricThresholdPath(thresholdConfigurationName, thresholdGroupName, thresholdDisplayName, thresholdEvaluator.evaluateThreshold(thresholdDisplayName, thresholdGroupName).orElseThrow(() -> new MetricThresholdConfigurationException("Failed to evaluate threshold configuration for '" + thresholdGroupName + "' and '" + thresholdDisplayName + "'")));
    }
}

