/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.notifications.project;

import com.teamscale.core.analysis.configuration.index.model.MetricThresholdConfigurationException;
import com.teamscale.core.mail.MailSender;
import com.teamscale.core.user.User;
import com.teamscale.core.user.UserGroup;
import com.teamscale.index.notifications.ENotificationThresholdViolationResult;
import com.teamscale.index.notifications.InvalidNotificationRuleException;
import com.teamscale.index.notifications.NotificationContext;
import com.teamscale.index.notifications.NotificationThresholdViolationInfo;
import com.teamscale.index.notifications.NotifierBase;
import com.teamscale.index.notifications.project.ProjectNotificationMailHelper;
import com.teamscale.index.notifications.project.ProjectNotificationRule;
import com.teamscale.index.notifications.project.ProjectNotificationRuleIndex;
import com.teamscale.index.user.UserAliasLookup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.string.StringUtils;

public class ProjectNotifier
extends NotifierBase {
    private static final Logger LOGGER = LogManager.getLogger();

    public ProjectNotifier(NotificationContext notificationContext, UserAliasLookup userAliasLookup) {
        super(notificationContext, userAliasLookup);
    }

    @Override
    public void checkRulesAndNotify() throws StorageException {
        ProjectNotificationRuleIndex projectNotificationRuleIndex = (ProjectNotificationRuleIndex)this.notificationContext.getGlobalStorageSystem().openGlobalIndex(ProjectNotificationRuleIndex.class);
        LOGGER.info("Start matching project notification rules.");
        ArrayList<ProjectNotificationRule> rules = new ArrayList<ProjectNotificationRule>();
        if (projectNotificationRuleIndex.getNotificationRules().isPresent()) {
            rules.addAll((Collection<ProjectNotificationRule>)projectNotificationRuleIndex.getNotificationRules().get().getRules());
        }
        for (ProjectNotificationRule rule : rules) {
            this.safelyMatchRule(rule);
        }
        LOGGER.info("Finished matching project notification rules.");
    }

    private void safelyMatchRule(ProjectNotificationRule rule) {
        try {
            this.matchRule(rule);
        }
        catch (InvalidNotificationRuleException e) {
            LOGGER.warn("Encountered invalid project notification rule '" + rule.getRuleName() + "'.", (Throwable)e);
        }
        catch (MetricThresholdConfigurationException | StorageException e) {
            LOGGER.error("Encountered exception, when processing notification rule '" + rule.getRuleName() + "'.", e);
        }
    }

    private void matchRule(ProjectNotificationRule rule) throws StorageException, InvalidNotificationRuleException, MetricThresholdConfigurationException {
        NotificationThresholdViolationInfo info = rule.matches(this.notificationContext);
        LOGGER.debug("Rule '{}' match result: {}", (Object)rule.getRuleName(), (Object)info);
        if (info.getResult() != ENotificationThresholdViolationResult.NO_MATCH) {
            this.sendMails(rule, info);
        }
    }

    private void sendMails(ProjectNotificationRule rule, NotificationThresholdViolationInfo info) throws StorageException {
        Set<User> recipients = this.getRecipientUsers(rule);
        Set<String> recipientEmailAddresses = ProjectNotifier.getEmailAddressesFromUsers(recipients);
        ProjectNotificationMailHelper builder = new ProjectNotificationMailHelper(this.notificationContext, rule, info);
        try {
            String subject = builder.buildSubject();
            String content = builder.buildContent();
            LOGGER.debug("Sending mail with subject {} to recipients: {}", (Object)subject, recipientEmailAddresses);
            this.notificationContext.getMailUtils().sendHtmlMail(recipientEmailAddresses, subject, content, this.notificationContext.getGlobalStorageSystem());
        }
        catch (MailSender.MailException e) {
            LOGGER.error("Email sending failed: " + e.getMessage(), (Throwable)e);
        }
    }

    private Set<User> getRecipientUsers(ProjectNotificationRule rule) throws StorageException {
        HashSet<User> recipients = new HashSet<User>();
        List<String> recipientUsernames = rule.getRecipientUsers();
        this.addEmailUsersToSet(recipientUsernames, recipients);
        List<String> recipientGroups = rule.getRecipientGroups();
        for (String group : recipientGroups) {
            UserGroup userGroup = this.notificationContext.getUserGroupIndex().getUserGroup(group);
            this.addEmailUsersToSet((Collection<String>)userGroup.getUserNames(), recipients);
        }
        return recipients;
    }

    private void addEmailUsersToSet(Collection<String> usernames, Set<User> recipients) {
        for (String username : usernames) {
            Optional<User> user = this.userAliasLookup.resolveUser(username);
            if (user.isEmpty()) {
                LOGGER.warn("Unknown notification user " + username);
                continue;
            }
            if (StringUtils.isEmpty((String)user.get().getEmailAddress())) {
                LOGGER.warn("Notification user " + username + " has no email address");
                continue;
            }
            recipients.add(user.get());
        }
    }

    private static Set<String> getEmailAddressesFromUsers(Set<User> users) {
        HashSet<String> emailAddresses = new HashSet<String>();
        for (User user : users) {
            emailAddresses.add(user.getEmailAddress());
        }
        return emailAddresses;
    }
}

