/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.project;

import com.teamscale.core.metrics.schema.EMetricProperty;
import com.teamscale.core.metrics.schema.MetricDirectorySchemaEntry;
import com.teamscale.core.metrics.values.EMetricValueType;
import com.teamscale.index.project.ExternalMetricsDescriptionIndexBase;
import com.teamscale.index.project.MetricSchemaChangeEntry;
import java.util.EnumSet;
import java.util.List;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.DelegatingPartitionStore;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;

@Index(name="external-non-code-metrics", options={EStorageOption.COMPRESSED, EStorageOption.BACKUP}, valueClasses={MetricSchemaChangeEntry.class})
public class ExternalNonCodeMetricsDescriptionIndex
extends ExternalMetricsDescriptionIndexBase {
    public static final String INDEX_NAME = "external-non-code-metrics";
    private static final byte[] INITIALIZED_PREDEFINED_METRICS = StringUtils.stringToBytes((String)"initialized_predefined_metrics");

    public ExternalNonCodeMetricsDescriptionIndex(IStore store) throws StorageException {
        super((IStore)new DelegatingPartitionStore(store, "values"));
        DelegatingPartitionStore metadataStore = new DelegatingPartitionStore(store, "metadata");
        if (metadataStore.get(INITIALIZED_PREDEFINED_METRICS) == null) {
            List<MetricSchemaChangeEntry> predefinedMetrics = ExternalNonCodeMetricsDescriptionIndex.getPredefinedMetrics();
            this.putMetrics(predefinedMetrics);
            metadataStore.put(INITIALIZED_PREDEFINED_METRICS, new byte[0]);
        }
    }

    @VisibleForTesting
    public static List<MetricSchemaChangeEntry> getPredefinedMetrics() {
        MetricSchemaChangeEntry predefinedCountMetric = new MetricSchemaChangeEntry("count", "Custom Artifacts Metrics", new MetricDirectorySchemaEntry("Count", "Counts the number of process steps.", MetricDirectorySchemaEntry.EAggregation.SUM, EMetricValueType.NUMERIC, EnumSet.of(EMetricProperty.SIZE_METRIC)));
        MetricSchemaChangeEntry predefinedAssessmentMetric = new MetricSchemaChangeEntry("assessment", "Custom Artifacts Metrics", new MetricDirectorySchemaEntry("Assessment", "An assessment of the success of the process step.", MetricDirectorySchemaEntry.EAggregation.SUM, EMetricValueType.ASSESSMENT, EnumSet.noneOf(EMetricProperty.class)));
        MetricSchemaChangeEntry predefinedExecutionTimeMetric = new MetricSchemaChangeEntry("time", "Custom Artifacts Metrics", new MetricDirectorySchemaEntry("Execution Time", "The execution time of the process step.", MetricDirectorySchemaEntry.EAggregation.SUM, EMetricValueType.NUMERIC, EnumSet.of(EMetricProperty.SIZE_METRIC)));
        return List.of(predefinedCountMetric, predefinedAssessmentMetric, predefinedExecutionTimeMetric);
    }
}

