/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository;

import com.teamscale.core.committree.CommitTreeRevision;
import com.teamscale.core.committree.IChangeRetrieverCommitTree;
import com.teamscale.index.repository.ERepositoryChangeType;
import com.teamscale.index.repository.RepositoryChangeSet;
import com.teamscale.index.repository.base.CommitTreeExpansionResult;
import com.teamscale.index.repository.history.EChangeEntryOrigin;
import java.util.List;
import java.util.Set;
import org.conqat.engine.core.cancel.RescheduleRequestedException;
import org.conqat.engine.core.stream.IStreamWithException;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public interface IRepositoryConnection
extends AutoCloseable {
    public static final long INVALID_TIMESTAMP = -1L;

    public String getDefaultBranchName() throws RepositoryException;

    public String getLocationDescription() throws RepositoryException;

    public CommitTreeExpansionResult expandCommitTree(IChangeRetrieverCommitTree var1) throws RepositoryException, RescheduleRequestedException;

    public @Nullable RepositoryChangeSet getChangeSet(CommitTreeRevision var1, CommitTreeRevision var2) throws RepositoryException;

    public Set<String> crawl(CommitTreeRevision var1) throws RepositoryException;

    public IStreamWithException<byte[], RepositoryException> getContent(List<String> var1, CommitTreeRevision var2) throws RepositoryException;

    public boolean isIncluded(String var1);

    public boolean isTestCode(String var1);

    public String getConnectionIdentifier();

    @Override
    public void close() throws RepositoryException;

    public Pair<String, String> getAuthorAndCommitMessage(CommitTreeRevision var1, List<CommitTreeRevision> var2) throws RepositoryException;

    public @Nullable String getEmail(CommitTreeRevision var1, List<CommitTreeRevision> var2) throws RepositoryException;

    default public boolean shouldCacheContent() {
        return false;
    }

    default public String getRevisionIdentifier(CommitTreeRevision revision) {
        return revision.toString();
    }

    public boolean shouldInheritForkInformation();

    public int getPollingIntervalSeconds();

    default public boolean isCodeRepository() {
        return true;
    }

    public boolean supportsSkipping();

    default public boolean fileExistsAfterForkMerge(UniformPath path, CommitTreeRevision revision, @NonNull EChangeEntryOrigin changeEntryOrigin, ERepositoryChangeType changeType) {
        return true;
    }
}

