/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.common;

import com.teamscale.core.analysis.configuration.ConnectorUtils;
import com.teamscale.core.analysis.configuration.ConnectorValidationException;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.model.ConfigurationInitializationContext;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.core.analysis.configuration.model.connectors.ConnectorDescriptorBase;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.runtime.api.progress.EAnalysisState;
import com.teamscale.index.merge_request.MergeRequestDeltaIndex;
import com.teamscale.index.merge_request.MergeRequestIndex;
import com.teamscale.index.merge_request.voting.PostponedVotingIndex;
import com.teamscale.index.merge_request.voting.VotingRecordIndex;
import com.teamscale.index.repository.git.GitRepositoryConnectorDescriptor;
import com.teamscale.index.repository.git.common.CcpIntegrationFeatureEnablements;
import com.teamscale.index.repository.git.common.CommitVotingTriggerBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;

public abstract class VoteSupportingGitRepositoryConnectorDescriptorBase
extends GitRepositoryConnectorDescriptor {
    public static final String ENABLE_FINDINGS_INTEGRATION_OPTION_NAME = "Enable Findings integration for merge requests";
    public static final boolean ENABLE_FINDINGS_INTEGRATION_DEFAULT = true;
    public static final String ENABLE_FINDINGS_BADGES_OPTION_NAME = "Enable Findings Badges";
    public static final boolean ENABLE_FINDINGS_BADGES_DEFAULT = true;
    public static final String ENABLE_VOTING_FOR_FINDINGS_OPTION_NAME = "Enable Voting for Findings";
    public static final boolean ENABLE_VOTING_FOR_FINDINGS_DEFAULT = true;
    public static final String ENABLE_DETAILED_LINE_COMMENTS_FOR_FINDINGS_OPTION_NAME = "Enable Detailed Line Comments for Findings";
    public static final boolean ENABLE_DETAILED_LINE_COMMENTS_FOR_FINDINGS_DEFAULT = true;
    public static final String ENABLE_TESTING_INTEGRATION_OPTION_NAME = "Enable Testing integration for merge requests";
    public static final boolean ENABLE_TESTING_INTEGRATION_DEFAULT = true;
    public static final String ENABLE_TEST_GAP_INTEGRATION_OPTION_NAME = "Enable Test Gap integration for merge requests";
    public static final boolean ENABLE_TEST_GAP_INTEGRATION_DEFAULT = true;
    public static final String ENABLE_TEST_GAP_BADGE_OPTION_NAME = "Enable Test Gap Badges";
    public static final boolean ENABLE_TEST_GAP_BADGE_DEFAULT = true;
    public static final String ENABLE_TEST_GAP_LINE_COMMENTS_OPTION_NAME = "Add Detailed Line Comments for Test Gaps";
    public static final boolean ENABLE_TEST_GAP_LINE_COMMENTS_DEFAULT = false;
    public static final String ENABLE_TEST_GAP_SUMMARY_MR_COMMENT_OPTION_NAME = "Add Test Gaps Summary in a Single Comment";
    public static final boolean ENABLE_TEST_GAP_SUMMARY_MR_COMMENT_DEFAULT = false;
    public static final String ENABLE_VOTING_FOR_TEST_GAPS_OPTION_NAME = "Enable Voting for Test Gaps";
    public static final boolean ENABLE_VOTING_FOR_TEST_GAPS_DEFAULT = false;
    public static final String IGNORE_YELLOW_TEST_GAPS_FOR_VOTING_OPTION_NAME = "Ignore yellow Test Gaps for voting";
    public static final boolean IGNORE_YELLOW_TEST_GAPS_FOR_VOTING_DEFAULT = false;
    public static final String ENABLE_VOTING_FOR_TEST_COVERAGE_OPTION_NAME = "Enable Voting for Test Coverage";
    public static final boolean ENABLE_VOTING_FOR_TEST_COVERAGE_DEFAULT = false;
    public static final String ENABLE_COMMIT_ALERTS_INTEGRATION_OPTION_NAME = "Enable Commit Alerts for merge requests";
    public static final boolean ENABLE_COMMIT_ALERTS_INTEGRATION_DEFAULT = true;
    public static final String FINDINGS_LINE_COMMENTS_LIMIT_OPTION_NAME = "Detailed Line Comments Limit for Findings";
    private static final int FINDINGS_LINE_COMMENTS_LIMIT_DEFAULT = 25;
    public static final String LINE_COVERAGE_THRESHOLD_OPTION_NAME = "Line coverage threshold";
    public static final int LINE_COVERAGE_THRESHOLD_DEFAULT = 60;
    public static final String TEST_GAPS_LINE_COMMENTS_LIMIT_OPTION_NAME = "Limit for Test Gap Comments";
    private static final int TEST_GAPS_LINE_COMMENTS_LIMIT_DEFAULT = 10;
    public static final String ENABLE_COMMENT_AGGREGATION_OPTION_NAME = "Aggregate Findings in Single Comment";
    public static final boolean ENABLE_COMMENT_AGGREGATION_DEFAULT = true;
    public static final String ENABLE_IGNORE_YELLOW_FINDINGS_FOR_VOTES_OPTION_NAME = "Ignore Yellow Findings For Votes";
    public static final String ENABLE_IGNORE_YELLOW_FINDINGS_FOR_COMMENTS_OPTION_NAME = "Ignore Yellow Findings For Comments";
    public static final boolean ENABLE_IGNORE_YELLOW_FINDINGS_FOR_VOTES_DEFAULT = false;
    public static final boolean ENABLE_IGNORE_YELLOW_FINDINGS_FOR_COMMENTS_DEFAULT = false;
    public static final String VOTE_REQUIRED_UPLOADS_OPTION_NAME = "Partitions Required for Voting";
    public static final String VOTE_INCLUDE_PATTERNS_OPTIONS_NAME = "Vote Include Patterns";
    public static final String VOTE_EXCLUDE_PATTERNS_OPTIONS_NAME = "Vote Exclude Patterns";
    public static final String METRIC_THRESHOLD_BADGES_OPTION_NAME = "Badges for Metrics";
    public static final String METRIC_THRESHOLD_BADGES_DESCRIPTION = "Metrics which should be tracked in merge requests via badges.";
    public static final String METRIC_THRESHOLD_GROUP_BADGES_OPTION_NAME = "Badges for Metric Groups";
    public static final String METRIC_THRESHOLD_GROUP_BADGES_DESCRIPTION = "Metrics which should be included in a summarized badge for their group in merge requests.";
    @ConfigExposed(name="Enable Findings integration for merge requests", visibility=ConfigExposed.EConfigVisibility.DEFAULT, changeRequiresReAnalysis=false, description="Enables the integration of Teamscale Findings in merge requests. This is a prerequisite for other options involving findings, such as the findings badge or voting.", dependentOptions={"Enable Findings Badges", "Enable Voting for Findings", "Enable Detailed Line Comments for Findings"})
    protected boolean findingsIntegrationEnabled = true;
    @ConfigExposed(name="Enable Findings Badges", visibility=ConfigExposed.EConfigVisibility.DEFAULT, changeRequiresReAnalysis=false, description="When enabled Teamscale will add a Findings Badge to the merge request.")
    protected boolean findingsBadgesEnabled = true;
    @ConfigExposed(name="Enable Detailed Line Comments for Findings", visibility=ConfigExposed.EConfigVisibility.DEFAULT, changeRequiresReAnalysis=false, description="When enabled, a Teamscale vote will carry a detailed comment for each generated finding that is annotated to the relevant line in the reviewed file.", dependentOptions={"Detailed Line Comments Limit for Findings", "Aggregate Findings in Single Comment"})
    protected boolean findingsDetailedLineCommentsEnabled = true;
    @ConfigExposed(name="Aggregate Findings in Single Comment", visibility=ConfigExposed.EConfigVisibility.DEFAULT, changeRequiresReAnalysis=false, description="When enabled, Teamscale will aggregate all related findings in a commit into a single comment before annotating it to the reviewed file.\nThe aggregated findings could be multiple identical findings or different findings sharing the same type (e.g. structure findings).\nThis aims to reduce redundancy and not to overcrowd the merge request with repetitive comments.\n\nExample: if a commit introduced 20 \"Interface comment missing\" findings, instead of adding 20 individual comments to the merge request,\nTeamscale will only add a single comment \"This file contains 20 instances of: Interface comment missing\".\n")
    protected boolean commentAggregationEnabled = true;
    @ConfigExposed(name="Detailed Line Comments Limit for Findings", visibility=ConfigExposed.EConfigVisibility.DEFAULT, changeRequiresReAnalysis=false, description="Maximum allowed number of detailed line comments for findings when annotating merge requests, in case the \"Enable Detailed Line Comments for Findings\" option is enabled. If the number of added findings exceeds the limit, no line comments will be added to the merge request and a warning message is displayed.")
    private int mergeRequestFindingsLimit = this.getFindingsLineCommentsLimitDefault();
    @ConfigExposed(name="Enable Voting for Findings", visibility=ConfigExposed.EConfigVisibility.DEFAULT, changeRequiresReAnalysis=false, description="When enabled, Teamscale will vote on the merge request based on the findings being present.")
    protected boolean findingsVotingEnabled = true;
    @ConfigExposed(name="Enable Commit Alerts for merge requests", visibility=ConfigExposed.EConfigVisibility.DEFAULT, changeRequiresReAnalysis=false, description="When enabled, a Teamscale vote will carry a detailed comment for each commit alert that is annotated to the relevant file.")
    protected boolean commitAlertsIntegrationEnabled = true;
    @ConfigExposed(name="Enable Testing integration for merge requests", visibility=ConfigExposed.EConfigVisibility.DEFAULT, changeRequiresReAnalysis=false, description="Enables the integration of Teamscale test gaps in merge requests. This is a prerequisite for other options regarding testing, such as voting on Test Gaps or Test Coverage on supported platforms.", dependentOptions={"Enable Voting for Test Coverage", "Enable Test Gap integration for merge requests"})
    protected boolean testingIntegrationEnabled = true;
    @ConfigExposed(name="Enable Test Gap integration for merge requests", visibility=ConfigExposed.EConfigVisibility.DEFAULT, changeRequiresReAnalysis=false, description="Enables the integration of Teamscale test gaps in merge requests.", dependentOptions={"Enable Test Gap Badges", "Add Detailed Line Comments for Test Gaps", "Add Test Gaps Summary in a Single Comment", "Limit for Test Gap Comments", "Enable Voting for Test Gaps"})
    protected boolean testGapIntegrationEnabled = true;
    @ConfigExposed(name="Enable Test Gap Badges", visibility=ConfigExposed.EConfigVisibility.DEFAULT, changeRequiresReAnalysis=false, description="When enabled, Teamscale will add a Test Gaps Badge to the merge request.")
    protected boolean testGapBadgesEnabled = true;
    @ConfigExposed(name="Add Detailed Line Comments for Test Gaps", visibility=ConfigExposed.EConfigVisibility.DEFAULT, changeRequiresReAnalysis=false, description="When enabled, Teamscale will add a detailed comment for each method or function that is untested. Other constraints may have to be met before comments are added, such as pending build results or uploads.")
    protected boolean testGapLineCommentsEnabled = false;
    @ConfigExposed(name="Limit for Test Gap Comments", visibility=ConfigExposed.EConfigVisibility.DEFAULT, changeRequiresReAnalysis=false, description="Maximum allowed number of test gap comments when annotating merge requests, in case the \"Add Detailed Line Comments for Test Gaps\" option or the \"Add Test Gaps Summary in a Single Comment\" option is enabled.For the \"Add Detailed Line Comments for Test Gaps\" option, if the number of test gaps exceeds the limit, no line comments will be added to the merge request and a warning message is displayed. As for the \"Add Test Gaps Summary in a Single Comment\" option, the maximum number of test gaps listed in the comment will not exceed the set limit. Any test gaps beyond the limit will not be explicitly displayed.")
    private int mergeRequestTestGapsLimit = this.getTestGapsLineCommentsLimitDefault();
    @ConfigExposed(name="Add Test Gaps Summary in a Single Comment", visibility=ConfigExposed.EConfigVisibility.DEFAULT, changeRequiresReAnalysis=false, description="When enabled Teamscale will add a summarized list of the untested methods or functions as a merge request comment. Other constraints may have to be met before the comment is added, such as pending build results or uploads.")
    protected boolean testGapSummaryCommentEnabled = false;
    @ConfigExposed(name="Enable Voting for Test Gaps", visibility=ConfigExposed.EConfigVisibility.DEFAULT, changeRequiresReAnalysis=false, description="When enabled, Teamscale will vote on the merge request based on the test gaps being present.", dependentOptions={"Ignore yellow Test Gaps for voting"})
    protected boolean enableVotingForTestGaps = false;
    @ConfigExposed(name="Ignore yellow Test Gaps for voting", visibility=ConfigExposed.EConfigVisibility.DEFAULT, changeRequiresReAnalysis=false, description="When enabled, test gaps in changed code are ignored and only test gaps in new code are considered for the vote")
    protected boolean isIgnoreYellowTestGapsForVoting = false;
    @ConfigExposed(name="Enable Voting for Test Coverage", visibility=ConfigExposed.EConfigVisibility.DEFAULT, changeRequiresReAnalysis=false, description="When enabled, Teamscale will vote on the merge request based on the line coverage of the changes. The threshold can be configured in the option \"Line coverage threshold\".")
    protected boolean enableVotingForTestCoverage = false;
    @ConfigExposed(name="Line coverage threshold", visibility=ConfigExposed.EConfigVisibility.DEFAULT, changeRequiresReAnalysis=false, description="The required line coverage for added and changed lines (in percent, 0-100). Merge requests with a lower line coverage will receive a negative vote if the \"Enable Voting for Test Coverage\" option is enabled.")
    protected int lineCoverageThreshold = 60;
    @ConfigExposed(name="Ignore Yellow Findings For Votes", visibility=ConfigExposed.EConfigVisibility.EXPERT, changeRequiresReAnalysis=false, description="When enabled, Teamscale will only consider red findings when voting.")
    protected boolean ignoreYellowFindingsForVotesEnabled = false;
    @ConfigExposed(name="Ignore Yellow Findings For Comments", visibility=ConfigExposed.EConfigVisibility.EXPERT, changeRequiresReAnalysis=false, description="When enabled, Teamscale will only consider red findings when commenting.")
    protected boolean ignoreYellowFindingsForCommentsEnabled = false;
    @ConfigExposed(name="Partitions Required for Voting", visibility=ConfigExposed.EConfigVisibility.EXPERT, changeRequiresReAnalysis=false, description="Comma separated list of external upload partitions that are expected to be present after a code commit to actually vote. This is used to prevent too early voting when further external uploads are expected.")
    protected String voteRequiredUploads = "";
    @ConfigExposed(name="Vote Include Patterns", visibility=ConfigExposed.EConfigVisibility.EXPERT, changeRequiresReAnalysis=false, description="Only the files that match one of these include patterns will be voted on.", multilineText=true)
    protected final List<String> voteIncludePatterns = new ArrayList<String>();
    @ConfigExposed(name="Vote Exclude Patterns", visibility=ConfigExposed.EConfigVisibility.EXPERT, changeRequiresReAnalysis=false, description="Files which are matched by these exclude patterns will not be voted on.", multilineText=true)
    protected final List<String> voteExcludePatterns = new ArrayList<String>();

    protected VoteSupportingGitRepositoryConnectorDescriptorBase(ERepositoryConnector type) {
        super(type);
        if (!this.supportsTestRelatedVoting()) {
            this.hideOption(ENABLE_VOTING_FOR_TEST_GAPS_OPTION_NAME);
            this.hideOption(IGNORE_YELLOW_TEST_GAPS_FOR_VOTING_OPTION_NAME);
            this.hideOption(ENABLE_VOTING_FOR_TEST_COVERAGE_OPTION_NAME);
        }
    }

    @Override
    protected boolean branchingEnabledDefaultValue() {
        return true;
    }

    protected int getFindingsLineCommentsLimitDefault() {
        return 25;
    }

    protected int getTestGapsLineCommentsLimitDefault() {
        return 10;
    }

    @Override
    public void validate() throws ConnectorValidationException {
        super.validate();
        if ((this.findingsIntegrationEnabled || this.testingIntegrationEnabled || this.commitAlertsIntegrationEnabled) && !this.branchingEnabled) {
            throw new ConnectorValidationException("Integration of findings, test gaps and commit alerts will only work if your branches are analyzed as well, so you should enable branch analysis!");
        }
        if (this.findingsIntegrationEnabled || this.testingIntegrationEnabled || this.commitAlertsIntegrationEnabled) {
            this.checkForOverlappingConnectors();
        }
        if (this.lineCoverageThreshold < 0 || this.lineCoverageThreshold > 100) {
            throw new ConnectorValidationException("Line Coverage Threshold must be between 0 and 100.");
        }
    }

    private void checkForOverlappingConnectors() throws ConnectorValidationException {
        IndexLayer indexLayer = this.getContext().getIndexLayer();
        String overlapCriteria = this.getOverlapCriteria();
        try {
            ProjectIndex projectIndex = (ProjectIndex)indexLayer.openGlobalIndex(ProjectIndex.class);
            List projectInfos = projectIndex.getAllProjectInfos();
            for (InternalProjectId projectId : CollectionUtils.map((Collection)projectInfos, ProjectInfo::getInternalId)) {
                if (projectId.equals((Object)this.getProjectId())) continue;
                this.checkForOverlappingConnectors(indexLayer, projectId, overlapCriteria);
            }
        }
        catch (ProjectConfigurationException | StorageException e) {
            throw new ConnectorValidationException(e);
        }
    }

    private void checkForOverlappingConnectors(IndexLayer indexLayer, InternalProjectId projectId, String overlapCriteria) throws StorageException, ConnectorValidationException {
        MetaIndex projectMetaIndex = (MetaIndex)indexLayer.openProjectStorageSystem((IProjectId)projectId).openProjectIndex(MetaIndex.class, null);
        ProjectConfiguration projectConfiguration = (ProjectConfiguration)projectMetaIndex.getValue(ProjectConfiguration.class);
        for (ConnectorConfiguration connectorConfiguration : projectConfiguration.getConnectors()) {
            Optional<String> connectorOverlapCriteria;
            if (!VoteSupportingGitRepositoryConnectorDescriptorBase.hasMergeRequestIntegrationEnabled(connectorConfiguration) || !this.isSameMergeRequestIntegrationEnabled(connectorConfiguration) || !(connectorOverlapCriteria = this.determineOverlapCriteria(connectorConfiguration, projectId, projectMetaIndex)).isPresent() || !overlapCriteria.equals(connectorOverlapCriteria.get())) continue;
            throw new ConnectorValidationException("The project '" + projectConfiguration.getName() + "' already contains a connector that is configured to vote on the same repository as this connector. This is not supported, please make sure that only one voting connector is configured for any repository in any other project.");
        }
    }

    public static boolean hasMergeRequestIntegrationEnabled(ConnectorConfiguration connectorConfiguration) {
        return VoteSupportingGitRepositoryConnectorDescriptorBase.isVotingConnector(connectorConfiguration) && CcpIntegrationFeatureEnablements.isAnyIntegrationEnabled(connectorConfiguration);
    }

    private static boolean isVotingConnector(ConnectorConfiguration connectorConfiguration) {
        return connectorConfiguration.getOptionValue(ENABLE_FINDINGS_INTEGRATION_OPTION_NAME) != null || connectorConfiguration.getOptionValue(ENABLE_TESTING_INTEGRATION_OPTION_NAME) != null || connectorConfiguration.getOptionValue(ENABLE_COMMIT_ALERTS_INTEGRATION_OPTION_NAME) != null;
    }

    private boolean isSameMergeRequestIntegrationEnabled(ConnectorConfiguration connectorConfiguration) {
        return CcpIntegrationFeatureEnablements.isFindingsIntegrationEnabled(connectorConfiguration) && this.findingsIntegrationEnabled || CcpIntegrationFeatureEnablements.isTestingIntegrationEnabled(connectorConfiguration) && this.testingIntegrationEnabled || CcpIntegrationFeatureEnablements.isCommitAlertsIntegrationEnabled(connectorConfiguration) && this.commitAlertsIntegrationEnabled;
    }

    private Optional<String> determineOverlapCriteria(ConnectorConfiguration connectorConfiguration, InternalProjectId projectId, MetaIndex projectMetaIndex) throws StorageException {
        String metaIndexKey = VoteSupportingGitRepositoryConnectorDescriptorBase.getConnectorOverlapCriteriaKey(connectorConfiguration.getIdentifier());
        Optional overlapValue = projectMetaIndex.getStringValue(metaIndexKey);
        if (overlapValue.isPresent()) {
            return overlapValue;
        }
        try {
            ConnectorDescriptorBase connectorDescriptor = ConnectorUtils.loadConnector((ConnectorConfiguration)connectorConfiguration, (ConfigurationInitializationContext)this.getContext(), (InternalProjectId)projectId);
            if (connectorDescriptor instanceof VoteSupportingGitRepositoryConnectorDescriptorBase) {
                String overlapCriteria = ((VoteSupportingGitRepositoryConnectorDescriptorBase)connectorDescriptor).getOverlapCriteria();
                projectMetaIndex.setStringValue(metaIndexKey, overlapCriteria);
                return Optional.of(overlapCriteria);
            }
            return Optional.empty();
        }
        catch (ProjectConfigurationException e) {
            return Optional.empty();
        }
    }

    protected String getOverlapCriteria() throws ConnectorValidationException {
        return "type: " + ((Object)((Object)this)).getClass().getSimpleName() + "\nrepositoryUri: " + String.valueOf(this.getRepositoryUri()) + "\ncodeIncludePatterns: " + String.valueOf(CollectionUtils.sort((Collection)this.codeIncludePatterns)) + "\nbranchIncludePatterns: " + String.valueOf(CollectionUtils.sort((Collection)this.branchIncludePatterns)) + "\nbranchExcludePatterns: " + String.valueOf(CollectionUtils.sort((Collection)this.branchExcludePatterns));
    }

    @Override
    protected void configureIndices(ConnectorDescriptorBase.IIndexCreator indexCreator) {
        super.configureIndices(indexCreator);
        indexCreator.createProjectIndex(VotingRecordIndex.class);
        indexCreator.createProjectIndex(PostponedVotingIndex.class);
        if (!indexCreator.isProjectIndexAlreadyCreated(MergeRequestIndex.class)) {
            indexCreator.createProjectIndex(MergeRequestIndex.class);
        }
        if (!indexCreator.isProjectIndexAlreadyCreated(MergeRequestDeltaIndex.class)) {
            indexCreator.createProjectIndex(MergeRequestDeltaIndex.class);
        }
    }

    @Override
    protected void configureTriggers(ConnectorDescriptorBase.ITriggerCreator triggerCreator) throws ProjectConfigurationException {
        super.configureTriggers(triggerCreator);
        for (EAnalysisState state : EAnalysisState.values()) {
            triggerCreator.addPostRevisionAnalysisTrigger(state, this.getMergeRequestAnnotationTriggerClass());
        }
        triggerCreator.addMetaIndexStringValue(VoteSupportingGitRepositoryConnectorDescriptorBase.getConnectorOverlapCriteriaKey(this.repositoryIdentifier), this.getOverlapCriteria());
        triggerCreator.addMetaIndexStringValue(VoteSupportingGitRepositoryConnectorDescriptorBase.getLineCoverageThresholdKey(this.repositoryIdentifier), String.valueOf(this.lineCoverageThreshold));
    }

    public static String getLineCoverageThresholdKey(String repositoryIdentifier) {
        return "changed-lines-coverage-threshold-" + repositoryIdentifier;
    }

    private static String getConnectorOverlapCriteriaKey(String repositoryIdentifier) {
        return "connector-overlap-" + repositoryIdentifier;
    }

    protected boolean supportsTestRelatedVoting() {
        return false;
    }

    public abstract Class<? extends CommitVotingTriggerBase<?>> getMergeRequestAnnotationTriggerClass();
}

