/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.svn;

import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.index.repository.retrievers.ICommitMessagesRetriever;
import com.teamscale.index.repository.svn.SVNUtils;
import java.util.List;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.io.SVNRepository;

public class SVNCommitMessageRetriever
implements ICommitMessagesRetriever {
    @Override
    public List<String> fetchCommitMessages(String branchName, boolean projectExists, String username, ExternalCredentials credentials, ConnectorConfiguration connectorConfiguration) throws RepositoryException {
        String repositoryUri = UniformPathUtils.concatenate((String[])new String[]{credentials.uri, connectorConfiguration.getOptionValue("Path suffix")});
        String branchUri = SVNUtils.createBranchUri(repositoryUri, connectorConfiguration.getOptionValue("Branches directory"), branchName);
        try {
            SVNRepository repository = SVNUtils.createRepository(repositoryUri, credentials.username, credentials.password);
            return SVNUtils.getLatestLogEntries(branchUri, repository, 10).stream().map(SVNLogEntry::getMessage).toList();
        }
        catch (SVNException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
    }
}

