/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.requirements_tracing.tools.polarion.client.wrapper;

import com.polarion.alm.ws.client.planning.PlanningWebService;
import com.polarion.alm.ws.client.planning.PlanningWebServiceServiceLocator;
import com.polarion.alm.ws.client.projects.ProjectWebService;
import com.polarion.alm.ws.client.projects.ProjectWebServiceServiceLocator;
import com.polarion.alm.ws.client.security.SecurityWebService;
import com.polarion.alm.ws.client.security.SecurityWebServiceServiceLocator;
import com.polarion.alm.ws.client.session.SessionWebService;
import com.polarion.alm.ws.client.session.SessionWebServiceServiceLocator;
import com.polarion.alm.ws.client.tracker.TrackerWebService;
import com.polarion.alm.ws.client.tracker.TrackerWebServiceServiceLocator;
import com.teamscale.index.requirements_tracing.tools.polarion.client.exception.PolarionSessionException;
import com.teamscale.index.requirements_tracing.tools.polarion.client.util.PolarionClientSessionHandlerInfo;
import com.teamscale.index.requirements_tracing.tools.util.WorkItemUtils;
import java.rmi.Remote;
import java.util.Iterator;
import java.util.function.BiConsumer;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.HandlerRegistry;
import org.apache.axis.client.Service;
import org.conqat.lib.commons.function.FunctionWithException;

public class PolarionWebServiceFactory {
    private final String connectionString;
    private final HandlerInfo sessionHandler = new PolarionClientSessionHandlerInfo();

    public PolarionWebServiceFactory(String uri) {
        this.connectionString = WorkItemUtils.buildPolarionConnectionString(uri);
    }

    public SessionWebService getSessionService() throws PolarionSessionException {
        return (SessionWebService)this.getService(new SessionWebServiceServiceLocator(), "/SessionWebService", SessionWebServiceServiceLocator::setSessionWebServiceEndpointAddress, SessionWebServiceServiceLocator::getSessionWebService);
    }

    public TrackerWebService getTrackerService() throws PolarionSessionException {
        return (TrackerWebService)this.getService(new TrackerWebServiceServiceLocator(), "/TrackerWebService", TrackerWebServiceServiceLocator::setTrackerWebServiceEndpointAddress, TrackerWebServiceServiceLocator::getTrackerWebService);
    }

    public ProjectWebService getProjectService() throws PolarionSessionException {
        return (ProjectWebService)this.getService(new ProjectWebServiceServiceLocator(), "/ProjectWebService", ProjectWebServiceServiceLocator::setProjectWebServiceEndpointAddress, ProjectWebServiceServiceLocator::getProjectWebService);
    }

    public SecurityWebService getSecurityService() throws PolarionSessionException {
        return (SecurityWebService)this.getService(new SecurityWebServiceServiceLocator(), "/SecurityWebService", SecurityWebServiceServiceLocator::setSecurityWebServiceEndpointAddress, SecurityWebServiceServiceLocator::getSecurityWebService);
    }

    public PlanningWebService getPlanningService() throws PolarionSessionException {
        return (PlanningWebService)this.getService(new PlanningWebServiceServiceLocator(), "/PlanningWebService", PlanningWebServiceServiceLocator::setPlanningWebServiceEndpointAddress, PlanningWebServiceServiceLocator::getPlanningWebService);
    }

    private <_LOCATOR extends Service, _SERVICE extends Remote> _SERVICE getService(_LOCATOR locator, String endpoint, BiConsumer<_LOCATOR, String> endpointSetter, FunctionWithException<_LOCATOR, _SERVICE, ServiceException> serviceGetter) throws PolarionSessionException {
        try {
            locator.setMaintainSession(true);
            this.addSessionHandler(locator);
            endpointSetter.accept(locator, this.connectionString + endpoint);
            return (_SERVICE)((Remote)serviceGetter.apply(locator));
        }
        catch (ServiceException ex) {
            throw new PolarionSessionException("Cannot create a web service. Malformed URL provided?", ex);
        }
    }

    private void addSessionHandler(Service service) throws PolarionSessionException {
        HandlerRegistry handlerRegistry = service.getHandlerRegistry();
        try {
            Iterator it = service.getPorts();
            while (it.hasNext()) {
                handlerRegistry.getHandlerChain((QName)it.next()).add(this.sessionHandler);
            }
        }
        catch (ServiceException e) {
            throw new PolarionSessionException("Unexpected initialization error.", e);
        }
    }
}

