/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.requirements_tracing.triggers.azure_devops;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.tfs.IWorkItemRestClient;
import com.teamscale.index.issues.BugTrackerException;
import com.teamscale.index.requirements_tracing.index.SpecItemIndex;
import com.teamscale.wia.SpecItem;
import com.teamscale.wia.TeamscaleIssueId;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ImmutablePair;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.function.FunctionWithException;
import org.conqat.lib.commons.function.SupplierWithException;
import org.conqat.lib.commons.string.StringUtils;

class AzureDevOpsAdditionalLinkResolver {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Pattern LINK_ROLE_SUFFIX_PATTERN = Pattern.compile("-[^-]+$");
    private final IWorkItemRestClient workItemRestClient;
    private final SpecItemIndex previousSpecItemIndex;
    private final String connectorId;
    private final Map<String, String> includedWorkItemLinkRoles;
    private final SupplierWithException<Map<String, String>, BugTrackerException> oppositeWorkItemLinkRoles;
    private final Set<String> projects;

    public AzureDevOpsAdditionalLinkResolver(IWorkItemRestClient workItemRestClient, SpecItemIndex previousSpecItemIndex, String connectorId, Collection<String> projects, PairList<String, String> includedWorkItemLinkRoles) {
        this.workItemRestClient = workItemRestClient;
        this.previousSpecItemIndex = previousSpecItemIndex;
        this.connectorId = connectorId;
        this.projects = new HashSet<String>(projects);
        this.includedWorkItemLinkRoles = includedWorkItemLinkRoles.stream().collect(Collectors.toMap(ImmutablePair::getSecond, ImmutablePair::getFirst));
        this.oppositeWorkItemLinkRoles = SupplierWithException.memoize(() -> AzureDevOpsAdditionalLinkResolver.buildOppositeLinkRolesMapping(workItemRestClient));
    }

    private static Map<String, String> buildOppositeLinkRolesMapping(IWorkItemRestClient workItemRestClient) throws BugTrackerException {
        HashMap<String, String> result = new HashMap<String, String>();
        Map<String, List<String>> rolesWithoutDirection = AzureDevOpsAdditionalLinkResolver.getWorkItemRelationTypes(workItemRestClient).collect(Collectors.groupingBy(AzureDevOpsAdditionalLinkResolver::calculateLinkRoleWithoutDirection));
        for (Map.Entry<String, List<String>> entry : rolesWithoutDirection.entrySet()) {
            String undirectedRole = entry.getKey();
            List<String> directedRoles = entry.getValue();
            result.putAll(AzureDevOpsAdditionalLinkResolver.buildOppositeLinkRoleMapping(undirectedRole, directedRoles));
        }
        return result;
    }

    private static Map<String, String> buildOppositeLinkRoleMapping(String undirectedRole, List<String> directedRoles) {
        switch (directedRoles.size()) {
            case 1: {
                String directedRole = directedRoles.get(0);
                if (undirectedRole.equals(directedRole)) {
                    return Map.of(undirectedRole, undirectedRole);
                }
                LOGGER.warn("Link role {} has no opposite, but is marked as directed?", (Object)directedRole);
                return Collections.emptyMap();
            }
            case 2: {
                return Map.ofEntries(Map.entry(directedRoles.get(0), directedRoles.get(1)), Map.entry(directedRoles.get(1), directedRoles.get(0)));
            }
        }
        throw new IllegalStateException("Got multiple directed roles %s that mapped to the same undirected role %s".formatted(directedRoles, undirectedRole));
    }

    private static Stream<String> getWorkItemRelationTypes(IWorkItemRestClient workItemRestClient) throws BugTrackerException {
        try {
            return workItemRestClient.getWorkItemRelationTypes().getRelations().stream().map(IWorkItemRestClient.GetWorkItemRelationTypesResponse.WorkItemRelationType::getReferenceName);
        }
        catch (ServiceCallException e) {
            throw new BugTrackerException("Could not retrieve work item relation types", e);
        }
    }

    public PairList<SpecItem, String> withAdditionalUpdatedItems(long lastScanTimestamp, PairList<SpecItem, String> issueUpdates) throws BugTrackerException, StorageException {
        if (this.includedWorkItemLinkRoles.isEmpty()) {
            return issueUpdates;
        }
        Map<String, NavigableMap<Long, Pair<SpecItem, String>>> specItemsByExternalIdAndUpdateTimestamp = AzureDevOpsAdditionalLinkResolver.groupSpecItemsByExternalIdAndUpdateTimestamp(issueUpdates);
        for (IWorkItemRestClient.GetWorkItemLinkUpdatesResponse.WorkItemLinkUpdate linkUpdate : this.getLinkUpdates(lastScanTimestamp)) {
            for (Pair additionalUpdate : this.extractAdditionalUpdates(specItemsByExternalIdAndUpdateTimestamp, linkUpdate)) {
                specItemsByExternalIdAndUpdateTimestamp.computeIfAbsent(((SpecItem)additionalUpdate.getFirst()).getId().getExternalId(), ignored -> new TreeMap()).put(((SpecItem)additionalUpdate.getFirst()).getUpdated(), additionalUpdate);
            }
        }
        return (PairList)specItemsByExternalIdAndUpdateTimestamp.values().stream().map(SortedMap::values).flatMap(Collection::stream).collect(PairList.toPairList());
    }

    private static Map<String, NavigableMap<Long, Pair<SpecItem, String>>> groupSpecItemsByExternalIdAndUpdateTimestamp(PairList<SpecItem, String> issueUpdates) {
        return issueUpdates.stream().collect(Collectors.groupingBy(pair -> ((SpecItem)pair.getFirst()).getId().getExternalId(), Collectors.toMap(pair -> ((SpecItem)pair.getFirst()).getUpdated(), Function.identity(), CollectionUtils.throwingMerger(pair -> ((SpecItem)pair.getFirst()).getUpdated()), TreeMap::new)));
    }

    private PairList<SpecItem, String> extractAdditionalUpdates(Map<String, NavigableMap<Long, Pair<SpecItem, String>>> specItemsByExternalIdAndUpdateTimestamp, IWorkItemRestClient.GetWorkItemLinkUpdatesResponse.WorkItemLinkUpdate linkUpdate) throws StorageException, BugTrackerException {
        long timestamp = linkUpdate.getAttributes().getChangedDate().toInstant().toEpochMilli();
        int sourceItemId = linkUpdate.getAttributes().getSourceItemId();
        int targetItemId = linkUpdate.getAttributes().getTargetItemId();
        boolean relationWasAdded = linkUpdate.getAttributes().isActive();
        String linkType = linkUpdate.getAttributes().getLinkType();
        String changedBy = linkUpdate.getAttributes().getChangedBy().toString();
        SpecItem lastKnownSourceItem = this.getLastKnownItem(sourceItemId, timestamp, specItemsByExternalIdAndUpdateTimestamp);
        SpecItem lastKnownTargetItem = this.getLastKnownItem(targetItemId, timestamp, specItemsByExternalIdAndUpdateTimestamp);
        PairList result = new PairList(2);
        this.calculateAdditionalUpdate(lastKnownSourceItem, targetItemId, linkType, timestamp, relationWasAdded).ifPresent(item -> result.add(item, (Object)changedBy));
        this.calculateAdditionalUpdate(lastKnownTargetItem, sourceItemId, (String)((Map)this.oppositeWorkItemLinkRoles.get()).get(linkType), timestamp, relationWasAdded).ifPresent(item -> result.add(item, (Object)changedBy));
        return result;
    }

    private Optional<SpecItem> calculateAdditionalUpdate(SpecItem lastKnownSourceItem, int targetItemId, String linkType, long timestamp, boolean relationWasAdded) {
        if (this.updateItemRelations(lastKnownSourceItem, targetItemId, linkType, relationWasAdded)) {
            lastKnownSourceItem.setUpdated(timestamp);
            return Optional.of(lastKnownSourceItem);
        }
        return Optional.empty();
    }

    private boolean updateItemRelations(SpecItem item, int targetItemId, String internalLinkType, boolean relationWasAdded) {
        if (item == null || internalLinkType == null) {
            return false;
        }
        String humanReadableLinkType = this.includedWorkItemLinkRoles.get(internalLinkType);
        if (humanReadableLinkType == null) {
            return false;
        }
        TeamscaleIssueId otherElementId = new TeamscaleIssueId(this.connectorId, String.valueOf(targetItemId));
        if ("System.LinkTypes.Hierarchy-Reverse".equals(internalLinkType)) {
            return AzureDevOpsAdditionalLinkResolver.updateParentId(item, relationWasAdded, otherElementId);
        }
        List linkedItems = item.getLinkedSpecItems(humanReadableLinkType);
        if (linkedItems.contains(otherElementId) == relationWasAdded) {
            return false;
        }
        if (relationWasAdded) {
            return linkedItems.add(otherElementId);
        }
        return linkedItems.remove(otherElementId);
    }

    private static boolean updateParentId(SpecItem item, boolean relationWasAdded, TeamscaleIssueId otherElementId) {
        Optional existingParentId = item.getParentId();
        if (relationWasAdded) {
            if (existingParentId.isEmpty() || !((TeamscaleIssueId)existingParentId.get()).equals((Object)otherElementId)) {
                item.setParentId(otherElementId);
                return true;
            }
        } else if (existingParentId.isPresent() && ((TeamscaleIssueId)existingParentId.get()).equals((Object)otherElementId)) {
            item.setParentId(null);
            return true;
        }
        return false;
    }

    private SpecItem getLastKnownItem(int itemId, long timestamp, Map<String, NavigableMap<Long, Pair<SpecItem, String>>> specItemsByExternalIdAndUpdateTimestamp) throws StorageException {
        Map.Entry latestEntry = specItemsByExternalIdAndUpdateTimestamp.getOrDefault(String.valueOf(itemId), Collections.emptyNavigableMap()).floorEntry(timestamp);
        if (latestEntry != null) {
            return ((SpecItem)((Pair)latestEntry.getValue()).getFirst()).copy();
        }
        return (SpecItem)this.previousSpecItemIndex.getIssue(new TeamscaleIssueId(this.connectorId, String.valueOf(itemId)));
    }

    private List<IWorkItemRestClient.GetWorkItemLinkUpdatesResponse.WorkItemLinkUpdate> getLinkUpdates(long lastScanTimestamp) throws BugTrackerException {
        try {
            String workItemTypes = null;
            String linkTypesString = String.join((CharSequence)",", this.getIncludedLinkTypesWithoutDirection());
            Instant lastScan = Instant.ofEpochMilli(lastScanTimestamp);
            if (this.projects.isEmpty()) {
                return this.getLinkUpdatesForAllProjects(linkTypesString, workItemTypes, lastScan);
            }
            ArrayList<IWorkItemRestClient.GetWorkItemLinkUpdatesResponse.WorkItemLinkUpdate> result = new ArrayList<IWorkItemRestClient.GetWorkItemLinkUpdatesResponse.WorkItemLinkUpdate>();
            for (String project : this.projects) {
                result.addAll(this.getLinkUpdatesForProject(project, linkTypesString, workItemTypes, lastScan));
            }
            return result;
        }
        catch (ServiceCallException e) {
            throw new BugTrackerException("Retrieving the work item link updates from the repository failed", e);
        }
    }

    private List<IWorkItemRestClient.GetWorkItemLinkUpdatesResponse.WorkItemLinkUpdate> getLinkUpdatesForProject(String project, String linkTypes, String workItemTypes, Instant lastScan) throws ServiceCallException {
        return this.getWorkItemLinkUpdates((SupplierWithException<IWorkItemRestClient.GetWorkItemLinkUpdatesResponse, ServiceCallException>)((SupplierWithException)() -> this.workItemRestClient.getWorkItemLinkUpdatesForProject(project, linkTypes, workItemTypes, lastScan, null)), (FunctionWithException<String, IWorkItemRestClient.GetWorkItemLinkUpdatesResponse, ServiceCallException>)((FunctionWithException)token -> this.workItemRestClient.getWorkItemLinkUpdatesForProject(project, linkTypes, workItemTypes, lastScan, token)));
    }

    private List<IWorkItemRestClient.GetWorkItemLinkUpdatesResponse.WorkItemLinkUpdate> getLinkUpdatesForAllProjects(String linkTypes, String workItemTypes, Instant lastScan) throws ServiceCallException {
        return this.getWorkItemLinkUpdates((SupplierWithException<IWorkItemRestClient.GetWorkItemLinkUpdatesResponse, ServiceCallException>)((SupplierWithException)() -> this.workItemRestClient.getWorkItemLinkUpdates(linkTypes, workItemTypes, lastScan, null)), (FunctionWithException<String, IWorkItemRestClient.GetWorkItemLinkUpdatesResponse, ServiceCallException>)((FunctionWithException)token -> this.workItemRestClient.getWorkItemLinkUpdates(linkTypes, workItemTypes, lastScan, token)));
    }

    private List<IWorkItemRestClient.GetWorkItemLinkUpdatesResponse.WorkItemLinkUpdate> getWorkItemLinkUpdates(SupplierWithException<IWorkItemRestClient.GetWorkItemLinkUpdatesResponse, ServiceCallException> initialCallProvider, FunctionWithException<String, IWorkItemRestClient.GetWorkItemLinkUpdatesResponse, ServiceCallException> continuationCallProvider) throws ServiceCallException {
        IWorkItemRestClient.GetWorkItemLinkUpdatesResponse response = (IWorkItemRestClient.GetWorkItemLinkUpdatesResponse)initialCallProvider.get();
        ArrayList<IWorkItemRestClient.GetWorkItemLinkUpdatesResponse.WorkItemLinkUpdate> linkUpdates = new ArrayList<IWorkItemRestClient.GetWorkItemLinkUpdatesResponse.WorkItemLinkUpdate>(response.getLinkUpdates());
        while (!response.isLastBatch()) {
            response = (IWorkItemRestClient.GetWorkItemLinkUpdatesResponse)continuationCallProvider.apply((Object)response.getContinuationToken());
            linkUpdates.addAll(response.getLinkUpdates());
        }
        return linkUpdates;
    }

    private List<String> getIncludedLinkTypesWithoutDirection() {
        return this.includedWorkItemLinkRoles.keySet().stream().map(AzureDevOpsAdditionalLinkResolver::calculateLinkRoleWithoutDirection).distinct().toList();
    }

    private static String calculateLinkRoleWithoutDirection(String role) {
        return StringUtils.replaceAll((String)role, (Pattern)LINK_ROLE_SUFFIX_PATTERN, (String)"");
    }
}

