/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource.reparsing_dependency;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.capability.IAbbreviationStoreCapability;
import org.conqat.engine.persistence.store.util.IStorageAbbreviator;
import org.conqat.engine.persistence.store.util.StorageAbbreviation;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.test.IndexValueClass;

@Index(name="preprocessor-rerun-relevant-define-trees", options={EStorageOption.BRANCHED, EStorageOption.ABBREVIATE_STRINGS}, valueClasses={DefineTree.class})
public class PreprocessorRerunDefineTreesIndex
extends IndexBase
implements IProjectIndex {
    public static final String INDEX_NAME = "preprocessor-rerun-relevant-define-trees";

    public PreprocessorRerunDefineTreesIndex(IStore store) {
        super(store, false);
    }

    public void putUpdatedDefineTrees(Map<String, DefineTree> defineTreesPerUniformPath) throws StorageException {
        IStorageAbbreviator abbreviator = this.loadAbbreviator();
        Map uniformPathAbbreviationMap = abbreviator.abbreviateAsMap(defineTreesPerUniformPath.keySet());
        PairList serializedData = new PairList();
        for (Map.Entry<String, DefineTree> entry : defineTreesPerUniformPath.entrySet()) {
            byte[] key = ((StorageAbbreviation)uniformPathAbbreviationMap.get(entry.getKey())).toByteArray();
            serializedData.add((Object)key, (Object)StorageUtils.serialize((Serializable)entry.getValue()));
        }
        this.store.put(serializedData);
    }

    public Map<String, DefineTree> getDefineTrees(List<String> uniformPaths) throws StorageException {
        IStorageAbbreviator abbreviator = this.loadAbbreviator();
        List abbreviatedPaths = CollectionUtils.map((Collection)abbreviator.abbreviateAll(uniformPaths), StorageAbbreviation::toByteArray);
        List values = StorageUtils.deserializeValues((List)this.store.get(abbreviatedPaths));
        HashMap<String, DefineTree> defineTrees = new HashMap<String, DefineTree>();
        for (int i = 0; i < values.size(); ++i) {
            String uniformPath = uniformPaths.get(i);
            if (values.get(i) == null) continue;
            defineTrees.put(uniformPath, (DefineTree)values.get(i));
        }
        return defineTrees;
    }

    private IStorageAbbreviator loadAbbreviator() {
        return ((IAbbreviationStoreCapability)this.store.getCapability(IAbbreviationStoreCapability.class).get()).abbreviator();
    }

    public void remove(List<String> deletedUniformPaths) throws StorageException {
        IStorageAbbreviator abbreviator = this.loadAbbreviator();
        List abbreviatedPaths = CollectionUtils.map((Collection)abbreviator.abbreviateAll(deletedUniformPaths), StorageAbbreviation::toByteArray);
        this.store.remove(abbreviatedPaths);
    }

    @IndexValueClass(containedInBackup=false)
    public record DefineTree(String defineTree) implements Serializable
    {
        private static final long serialVersionUID = 1L;
    }
}

