/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap.treemap;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.teamscale.index.testgap.treemap.TreeMapNodeDeserializer;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.test.IndexValueClass;
import org.conqat.lib.commons.treemap.ITreeMapNode;
import org.jspecify.annotations.Nullable;

@JsonDeserialize(using=TreeMapNodeDeserializer.class)
@IndexValueClass(containedInBackup=true)
public abstract class TreeMapNodeBase<T>
implements ITreeMapNode<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static final String UNIFORM_PATH_PROPERTY = "uniformPath";
    protected static final String AREA_PROPERTY = "area";
    private static final String CHILDREN_PROPERTY = "children";
    @JsonProperty(value="uniformPath")
    protected final String uniformPath;
    @JsonProperty(value="x")
    protected double x;
    @JsonProperty(value="y")
    protected double y;
    @JsonProperty(value="width")
    protected double width;
    @JsonProperty(value="height")
    protected double height;
    @JsonProperty(value="area")
    protected double area;
    @JsonProperty(value="children")
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @ArraySchema(schema=@Schema(implementation=TreeMapNodeBase.class))
    @JsonDeserialize(as=ArrayList.class, contentUsing=TreeMapNodeDeserializer.class)
    private @Nullable List<ITreeMapNode<T>> children;
    @JsonIgnore
    private Map<String, TreeMapNodeBase<T>> namedChildrenMap;

    protected TreeMapNodeBase(String uniformPath) {
        this.uniformPath = uniformPath;
    }

    protected String getElementName() {
        return UniformPathUtils.getElementName((String)this.uniformPath);
    }

    public String getText() {
        return this.uniformPath;
    }

    public List<ITreeMapNode<T>> getChildren() {
        if (this.children == null) {
            return CollectionUtils.emptyList();
        }
        return this.children;
    }

    @JsonSetter(value="children")
    public <S extends TreeMapNodeBase<T>> void addAllChildren(List<S> children) {
        for (TreeMapNodeBase child : children) {
            this.addChild(child);
        }
    }

    public <S extends TreeMapNodeBase<T>> void addChild(S child) {
        if (this.children == null) {
            this.children = new ArrayList<ITreeMapNode<T>>();
            this.namedChildrenMap = new HashMap<String, TreeMapNodeBase<T>>();
        }
        this.children.add(child);
        this.namedChildrenMap.put(child.getElementName(), child);
    }

    public <S extends TreeMapNodeBase<T>> S getChild(String elementName) {
        if (this.namedChildrenMap != null) {
            return (S)this.namedChildrenMap.get(elementName);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreeMapNodeBase<T> getOrCreateChild(String uniformPath, Function<String, ? extends TreeMapNodeBase<T>> nodeFactory) {
        if (uniformPath.isEmpty()) {
            return this;
        }
        String[] parts = UniformPathUtils.splitPath((String)uniformPath);
        TreeMapNodeBase<Object> currentNode = this;
        for (String part : parts) {
            TreeMapNodeBase treeMapNodeBase = currentNode;
            synchronized (treeMapNodeBase) {
                Object child = currentNode.getChild(part);
                if (child == null) {
                    String childUniformPath = UniformPathUtils.concatenate((String[])new String[]{currentNode.getUniformPath(), part});
                    child = nodeFactory.apply(childUniformPath);
                    currentNode.addChild(child);
                }
                currentNode = child;
            }
        }
        return currentNode;
    }

    public double getArea() {
        return this.area;
    }

    public double recalculateAreaAggregates() {
        if (this.children != null && !this.children.isEmpty()) {
            this.area = 0.0;
            for (ITreeMapNode<T> child : this.children) {
                this.area += child.recalculateAreaAggregates();
            }
        }
        return this.area;
    }

    public String getUniformPath() {
        return this.uniformPath;
    }

    public Rectangle2D getLayoutRectangle() {
        return new Rectangle2D.Double(this.x, this.y, this.width, this.height);
    }

    public void setLayoutRectangle(Rectangle2D rect) {
        this.x = rect.getX();
        this.y = rect.getY();
        this.width = rect.getWidth();
        this.height = rect.getHeight();
    }

    public String toString() {
        return this.uniformPath;
    }
}

