/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testimpact;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.index.resource.path_lookup.PathLookupOptions;
import com.teamscale.index.resource.path_lookup.PreloadedMatchingPathsLookup;
import com.teamscale.index.testimpact.TestHistorySynchronizer;
import com.teamscale.index.testimpact.TestImplementationIndex;
import com.teamscale.index.testimpact.TestLinks;
import com.teamscale.index.testimpact.TestLinksIndex;
import com.teamscale.index.tests.TestExecutionIndex;
import com.teamscale.index.tests.TestExecutionIndexDelta;
import com.teamscale.index.tests.TestExecutionWithPartition;
import com.teamscale.index.tests.TestImplementationPathToExecutionPathIndex;
import com.teamscale.index.tests.extractor.TestPathLookupIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.index.PartitionAndPath;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.filesystem.AntPatternUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.RelativeUniformPath;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@AnalysisStep(hints={EAnalysisStepParameter.MERGE_INPUT_DELTAS})
public class TestLinksSynchronizer
extends ChangeProcessorAnalysisStep {
    private static final Logger LOGGER = LogManager.getLogger();
    @DeltaSource(value=TestImplementationIndex.class)
    private KeyDelta keyDeltaTestImplementations;
    @DeltaSource(value=TestExecutionIndex.class)
    private TestExecutionIndexDelta keyDeltaTestExecutions;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private TestExecutionIndex testExecutionIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private TestPathLookupIndex testPathLookupIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private TestImplementationPathToExecutionPathIndex testImplementationPathToExecutionPathIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private TestLinksIndex testLinksIndex;
    private PreloadedMatchingPathsLookup testMatchingPathsLookup;
    private static final Pattern BOOST_PARAMETERIZED_TEST_PATTERN = Pattern.compile("^[_]\\d+$");

    public void execute() throws StorageException {
        this.testMatchingPathsLookup = this.testPathLookupIndex.createPreloadedLookup();
        LOGGER.trace(TestHistorySynchronizer.TS33927_LOG_MARKER, () -> "Test execution added/changed keys: " + String.valueOf(this.keyDeltaTestExecutions.getAddedOrChangedPartitionsAndPaths()));
        LOGGER.trace(TestHistorySynchronizer.TS33927_LOG_MARKER, () -> "Test execution deleted keys: " + String.valueOf(this.keyDeltaTestExecutions.getDeletedPartitionsAndPaths()));
        LOGGER.trace(TestHistorySynchronizer.TS33927_LOG_MARKER, () -> "Test implementation added/changed keys: " + String.valueOf(this.keyDeltaTestImplementations.getAddedOrChangedKeysAsStrings()));
        LOGGER.trace(TestHistorySynchronizer.TS33927_LOG_MARKER, () -> "Test implementation deleted keys: " + String.valueOf(this.keyDeltaTestImplementations.getDeletedKeysAsStrings()));
        Set<String> executionsForDeletedTestImplementations = this.testImplementationPathToExecutionPathIndex.getExecutionPathsForImplementationPathsFlat(this.keyDeltaTestImplementations.getDeletedKeysAsStrings());
        PairList<UniformPath, TestLinks> testExecutionsWithTestLinks = this.calculateLinksFromTestExecutionsToTestImplementations(executionsForDeletedTestImplementations, (List<PartitionAndPath>)this.keyDeltaTestExecutions.getAddedOrChangedPartitionsAndPaths());
        Map<String, HashSet<String>> testImplementationsToExecutions = TestLinksSynchronizer.buildTestImplementationToExecutionsMapping(testExecutionsWithTestLinks);
        this.testImplementationPathToExecutionPathIndex.addTestExecutionPaths(testImplementationsToExecutions);
        this.updateTestLinksIndex(testExecutionsWithTestLinks);
        this.testImplementationPathToExecutionPathIndex.deleteTestImplementationPaths(this.keyDeltaTestImplementations.getDeletedKeysAsStrings());
    }

    private static @NonNull Map<String, HashSet<String>> buildTestImplementationToExecutionsMapping(PairList<UniformPath, TestLinks> testExecutionsWithTestLinks) {
        HashMap<String, HashSet<String>> testImplementationsToExecutions = new HashMap<String, HashSet<String>>();
        for (Pair testExecutionWithTestLink : testExecutionsWithTestLinks) {
            TestLinks testLinks;
            String testImplementation;
            UniformPath key = (UniformPath)testExecutionWithTestLink.getFirst();
            if (!key.isTestExecutionPath() || (testImplementation = (testLinks = (TestLinks)testExecutionWithTestLink.getSecond()).getTestImplementation()) == null) continue;
            testImplementationsToExecutions.computeIfAbsent(testImplementation, k -> new HashSet()).add(key.toString());
        }
        return testImplementationsToExecutions;
    }

    private void updateTestLinksIndex(PairList<UniformPath, TestLinks> testExecutionsWithTestLinks) throws StorageException {
        this.testLinksIndex.addTestExecutions(testExecutionsWithTestLinks);
        this.unlinkDeletedTestExecutions();
        this.updateTestsWithoutExecutions();
        this.unlinkDeletedTestImplementations(testExecutionsWithTestLinks);
    }

    private void unlinkDeletedTestExecutions() throws StorageException {
        PairList<String, String> removedTestExecutionPathsAndImplementation = this.testLinksIndex.removeTestExecutions((List<PartitionAndPath>)this.keyDeltaTestExecutions.getDeletedPartitionsAndPaths());
        this.testImplementationPathToExecutionPathIndex.deleteTestExecutionPaths(removedTestExecutionPathsAndImplementation);
    }

    private void unlinkDeletedTestImplementations(PairList<UniformPath, TestLinks> testExecutionsWithTestLinks) throws StorageException {
        HashSet deletedTests = CollectionUtils.unionSet((Collection)this.keyDeltaTestImplementations.getDeletedKeysAsStrings(), (Collection[])new Collection[]{CollectionUtils.filterAndMap((Collection)testExecutionsWithTestLinks.extractSecondList(), links -> links.getTestImplementation() != null, TestLinks::getTestImplementation)});
        this.keyDeltaTestImplementations.getAddedOrChangedKeysAsStrings().forEach(deletedTests::remove);
        this.testLinksIndex.removeTestImplementations(deletedTests);
    }

    private void updateTestsWithoutExecutions() throws StorageException {
        List changedTestImplementations = this.keyDeltaTestImplementations.getAddedOrChangedKeysAsStrings();
        ArrayList<String> updatedTestImplementationPathsWithoutTestExecutions = new ArrayList<String>();
        List<HashSet<String>> executionsForImplementationPaths = this.testImplementationPathToExecutionPathIndex.getExecutionPathsForImplementationPaths(changedTestImplementations);
        CollectionUtils.forEach((Iterable)changedTestImplementations, executionsForImplementationPaths, (changedTestImplementation, executionPaths) -> {
            if (executionPaths == null) {
                updatedTestImplementationPathsWithoutTestExecutions.add((String)changedTestImplementation);
            }
        });
        this.testLinksIndex.addNewTestImplementationsWithoutExecution(updatedTestImplementationPathsWithoutTestExecutions);
    }

    @Nonnull
    private PairList<UniformPath, TestLinks> calculateLinksFromTestExecutionsToTestImplementations(Set<String> executionsForDeletedTestImplementations, List<PartitionAndPath> testExecutionPathsUpdated) throws StorageException {
        UniformPath testExecutionPath;
        ListMap<UniformPath, TestExecutionWithPartition> testExecutionByUniformPath = this.getTestExecutionByPathMap(testExecutionPathsUpdated);
        PairList testExecutionsWithImplementations = new PairList();
        for (Map.Entry testExecution : testExecutionByUniformPath.entrySet()) {
            testExecutionPath = (UniformPath)testExecution.getKey();
            List testExecutionsWithPartition = (List)testExecution.getValue();
            List testLocations = ((TestExecutionWithPartition)testExecutionsWithPartition.getFirst()).getTestExecution().getTestLocations();
            UniformPath testImplementationPath = this.resolveTestImplementationPath(testExecutionPath, testLocations);
            Set<String> partitions = testExecutionsWithPartition.stream().map(TestExecutionWithPartition::getPartition).collect(Collectors.toSet());
            testExecutionsWithImplementations.add((Object)testExecutionPath, (Object)new TestLinks(testImplementationPath, partitions));
        }
        for (String executionForDeletedTestImplementation : executionsForDeletedTestImplementations) {
            testExecutionPath = UniformPathCompatibilityUtil.convert((String)executionForDeletedTestImplementation);
            UniformPath testImplementationPath = this.resolveTestImplementationPath(testExecutionPath, null);
            testExecutionsWithImplementations.add((Object)testExecutionPath, (Object)new TestLinks(testImplementationPath, Set.of()));
        }
        return testExecutionsWithImplementations;
    }

    private @Nullable UniformPath resolveTestImplementationPath(UniformPath testExecutionPath, @Nullable List<String> testLocations) {
        Preconditions.checkArgument((boolean)testExecutionPath.isTestExecutionPath());
        if (TestLinksSynchronizer.isParameterizedPath(testExecutionPath)) {
            String testNameWithoutParameter = StringUtils.getFirstPart((String)testExecutionPath.getLastSegment(), (String)"[");
            testExecutionPath = testExecutionPath.getParent().resolve(RelativeUniformPath.of((String[])new String[]{testNameWithoutParameter}));
        }
        if (TestLinksSynchronizer.isBoostParameterizedPath(testExecutionPath)) {
            UnmodifiableList pathSegments = testExecutionPath.getPathSegments();
            int testNameIndex = pathSegments.size() - 2;
            String testNameWithoutParameter = (String)pathSegments.get(testNameIndex);
            testExecutionPath = testExecutionPath.getParent().getParent().resolve(RelativeUniformPath.of((String[])new String[]{testNameWithoutParameter}));
        }
        if (TestLinksSynchronizer.containsCallSignature(testExecutionPath)) {
            String testNameWithoutSignature = StringUtils.getFirstPart((String)testExecutionPath.getLastSegment(), (String)"(");
            testExecutionPath = testExecutionPath.getParent().resolve(RelativeUniformPath.of((String[])new String[]{testNameWithoutSignature}));
        }
        String testNameSuffix = testExecutionPath.getSubPath(0).toString();
        ImmutableList<String> bestPath = this.testMatchingPathsLookup.lookupAllPaths(testNameSuffix, PathLookupOptions.defaults());
        if (testLocations != null) {
            return TestLinksSynchronizer.resolveTestImplementationPathWithLocations(testLocations, bestPath);
        }
        if (bestPath.size() == 1) {
            return UniformPathCompatibilityUtil.convert((String)((String)bestPath.iterator().next()));
        }
        return null;
    }

    private static @Nullable UniformPath resolveTestImplementationPathWithLocations(@NonNull List<String> testLocations, Collection<String> bestPaths) {
        List<Pattern> testLocationPatterns = testLocations.stream().map(testLocation -> AntPatternUtils.convertPattern((String)testLocation, (boolean)true)).toList();
        for (String path : bestPaths) {
            long numberOfMatchingPatterns = testLocationPatterns.stream().filter(pattern -> pattern.matcher(path).find()).count();
            if (numberOfMatchingPatterns != 1L) continue;
            return UniformPathCompatibilityUtil.convert((String)path);
        }
        return null;
    }

    private ListMap<UniformPath, TestExecutionWithPartition> getTestExecutionByPathMap(List<PartitionAndPath> testExecutionPathsUpdated) throws StorageException {
        List<TestExecutionWithPartition> testExecutionsUpdated = this.testExecutionIndex.getTestExecutionsForPartitionAndPaths(testExecutionPathsUpdated);
        ListMap testExecutionsByUniformPath = new ListMap();
        for (int i = 0; i < testExecutionsUpdated.size(); ++i) {
            TestExecutionWithPartition executionWithPartition = testExecutionsUpdated.get(i);
            if (executionWithPartition == null) {
                LOGGER.error("Encountered added or changed test execution with null value for path and partition '{}'. This is unexpected since all added or changed test executions should exist in the TestExecutionIndex. Skipping the test execution.", (Object)testExecutionPathsUpdated.get(i));
                continue;
            }
            UniformPath uniformPath = executionWithPartition.getTestExecution().toUniformPath();
            testExecutionsByUniformPath.add((Object)uniformPath, (Object)executionWithPartition);
        }
        return testExecutionsByUniformPath;
    }

    private static boolean isParameterizedPath(UniformPath testExecutionPath) {
        int parameterIndex = testExecutionPath.getLastSegment().indexOf("[");
        return parameterIndex > 0;
    }

    private static boolean isBoostParameterizedPath(UniformPath testExecutionPath) {
        return testExecutionPath.getPathSegments().size() >= 2 && BOOST_PARAMETERIZED_TEST_PATTERN.matcher(testExecutionPath.getLastSegment()).find();
    }

    private static boolean containsCallSignature(UniformPath testExecutionPath) {
        int parameterIndex = testExecutionPath.getLastSegment().indexOf("(");
        return parameterIndex > 0;
    }
}

