/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.tests;

import com.teamscale.index.tests.TestHistoryEntry;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.conqat.engine.persistence.index.keyed.EKeyedObjectType;
import org.conqat.engine.persistence.index.keyed.KeyedObjectDescriberBase;
import org.conqat.engine.sourcecode.coverage.TestUniformPathUtils;

public class TestDescriber
extends KeyedObjectDescriberBase<TestHistoryEntry> {
    private final Map<String, KeyedObjectDescriberBase.ValueDescriber> defaultValueDescriber = new HashMap<String, KeyedObjectDescriberBase.ValueDescriber>();

    public TestDescriber() {
        this.defaultValueDescriber.put("name", this.describerWithNaturalOrder(TestHistoryEntry::getName));
        this.defaultValueDescriber.put("codeLocation", this.describerWithNaturalOrder(TestHistoryEntry::getCodeLocation));
        this.defaultValueDescriber.put("partitions", this.describerWithNaturalOrder(testHistoryEntry -> EKeyedObjectType.collectionToListString(testHistoryEntry.getPartitions())));
        this.defaultValueDescriber.put("result", new KeyedObjectDescriberBase.ValueDescriber((KeyedObjectDescriberBase)this, testHistoryEntry -> EKeyedObjectType.mapToMapString(testHistoryEntry.getResults()), Comparator.comparing(testHistoryEntry -> testHistoryEntry.getResults().values().stream().mapToInt(Enum::ordinal).max().orElse(-1))));
        this.defaultValueDescriber.put("duration", new KeyedObjectDescriberBase.ValueDescriber((KeyedObjectDescriberBase)this, testHistoryEntry -> EKeyedObjectType.mapToMapString(testHistoryEntry.getDurations()), Comparator.comparing(testHistoryEntry -> testHistoryEntry.getDurations().values().stream().mapToLong(Long::longValue).max().orElse(-1L))));
        this.addFieldTypeMappings(Map.of("partitions", EKeyedObjectType.STRING_LIST, "result", EKeyedObjectType.STRING_MAP, "duration", EKeyedObjectType.NUMBER_MAP));
        this.defaultValueDescriber.put("executionUnit", this.describerWithNaturalOrder(testHistoryEntry -> {
            if (testHistoryEntry.getExecutionUnitUniformPath() != null) {
                return TestUniformPathUtils.convertCoverageUnitPathToTestName((String)testHistoryEntry.getExecutionUnitUniformPath());
            }
            return null;
        }));
    }

    public String getId(TestHistoryEntry test) {
        return test.getUniformPath();
    }

    public String ensureIsAbsoluteId(String objectId, String relativeId) {
        return relativeId;
    }

    public List<String> getKeys(TestHistoryEntry test) {
        return new ArrayList<String>(this.defaultValueDescriber.keySet());
    }

    public Function<TestHistoryEntry, String> getValueAccessor(String key) {
        KeyedObjectDescriberBase.ValueDescriber describer = this.defaultValueDescriber.get(key);
        if (describer != null) {
            return describer.getAccessor();
        }
        return test -> null;
    }

    public Comparator<TestHistoryEntry> getValueComparator(String key) {
        KeyedObjectDescriberBase.ValueDescriber describer = this.defaultValueDescriber.get(key);
        if (describer != null) {
            return describer.getComparator();
        }
        return Comparator.comparing(testHistoryEntry -> testHistoryEntry.getName().toLowerCase());
    }
}

