/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.tracking.index;

import com.teamscale.index.tracking.algorithm.EFindingIdentificationCriterion;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.function.BiConsumer;
import org.conqat.engine.persistence.index.IMountableStorageIndex;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.ByteArrayWrapper;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.digest.Digester;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.string.StringUtils;

@Index(name="finding-identification", options={EStorageOption.COMMIT_ISOLATED, EStorageOption.BACKUP, EStorageOption.NO_ROLLBACK, EStorageOption.CROSS_PROJECT_MOUNTABLE}, valueClasses={byte[].class})
public class FindingIdentificationIndex
extends IndexBase
implements IProjectIndex,
IMountableStorageIndex {
    public static final String INDEX_NAME = "finding-identification";
    private static final String MERGE_CHARACTERISTICS_LOCK = "mergeCharacteristicsLock";

    public FindingIdentificationIndex(IStore store) {
        super(store);
    }

    public List<List<String>> getFindingIdsForCriterionValues(List<byte[]> criterionAndValuesKeys) throws StorageException {
        List results = this.store.get(criterionAndValuesKeys);
        ArrayList<List<String>> ids = new ArrayList<List<String>>();
        for (byte[] result : results) {
            if (result == null) {
                ids.add(Collections.emptyList());
                continue;
            }
            Set<ByteArrayWrapper> idSet = FindingIdentificationIndex.deserializeFindingIds(result);
            ids.add(CollectionUtils.map(idSet, id -> StringUtils.encodeAsHex((byte[])id.getBytes())));
        }
        return ids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int mergeCharacteristics(SetMap<ByteArrayWrapper, ByteArrayWrapper> keyAndFindingIds) throws StorageException {
        Lock lock = this.store.obtainLock(MERGE_CHARACTERISTICS_LOCK);
        lock.lock();
        try {
            ArrayList keys = new ArrayList(keyAndFindingIds.getKeys());
            List oldResults = this.store.get(CollectionUtils.map(keys, ByteArrayWrapper::getBytes));
            SetMap newResults = new SetMap();
            for (int i = 0; i < keys.size(); ++i) {
                ByteArrayWrapper key = (ByteArrayWrapper)keys.get(i);
                byte[] oldResult = (byte[])oldResults.get(i);
                if (oldResult != null) {
                    Set<ByteArrayWrapper> ids = FindingIdentificationIndex.deserializeFindingIds(oldResult);
                    if (!ids.addAll(keyAndFindingIds.getCollection((Object)key))) continue;
                    newResults.addAll((Object)key, ids);
                    continue;
                }
                newResults.addAll((Object)key, keyAndFindingIds.getCollection((Object)key));
            }
            PairList serializedNewResults = new PairList();
            for (Map.Entry entry : newResults) {
                byte[] id = FindingIdentificationIndex.serializeFindingIds((Set)entry.getValue());
                serializedNewResults.add((Object)((ByteArrayWrapper)entry.getKey()).getBytes(), (Object)id);
            }
            this.store.put(serializedNewResults);
            int n = serializedNewResults.size();
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    public void addOrReplaceFindingMinHash(PairList<String, byte[]> findingIdsAndMinHashes) throws StorageException {
        this.store.putWithStrings(findingIdsAndMinHashes);
    }

    public List<byte[]> getMinHashesForFindingIds(List<String> findingIds) throws StorageException {
        return this.store.getWithStrings(findingIds);
    }

    private static byte[] serializeFindingIds(Set<ByteArrayWrapper> ids) throws StorageException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            for (ByteArrayWrapper id : ids) {
                output.write(id.getBytes());
            }
        }
        catch (IOException e) {
            throw new StorageException("Error serializing finding ids: " + e.getMessage(), (Throwable)e);
        }
        return output.toByteArray();
    }

    private static Set<ByteArrayWrapper> deserializeFindingIds(byte[] bytes) {
        if (bytes == null) {
            return CollectionUtils.emptySet();
        }
        HashSet<ByteArrayWrapper> result = new HashSet<ByteArrayWrapper>();
        for (int i = 0; i < bytes.length; i += 16) {
            byte[] id = new byte[16];
            System.arraycopy(bytes, i, id, 0, 16);
            result.add(new ByteArrayWrapper(id));
        }
        return result;
    }

    public static byte[] createKey(EFindingIdentificationCriterion criterion, String criterionValue) {
        return ByteArrayUtils.concat((byte[][])new byte[][]{criterion.getKeyPrefix(), Digester.createBinaryMD5Digest((byte[])StringUtils.stringToBytes((String)criterionValue))});
    }

    public Lock obtainStoreLock(String suffix) {
        return this.store.obtainLock(suffix);
    }

    public void listContents(BiConsumer<byte[], Set<ByteArrayWrapper>> findingCriterionCallback, BiConsumer<ByteArrayWrapper, byte[]> minHashCallback) throws StorageException {
        this.store.scan(new byte[0], (key, value) -> {
            char type = (char)key[0];
            if (Character.isDigit(type) || Character.isUpperCase(type)) {
                minHashCallback.accept(new ByteArrayWrapper(StringUtils.decodeFromHex((String)StringUtils.bytesToString((byte[])key))), value);
            } else {
                findingCriterionCallback.accept(key, FindingIdentificationIndex.deserializeFindingIds(value));
            }
        });
    }

    public void persistCleanupResults(PairList<byte[], Set<ByteArrayWrapper>> replacementValues, List<byte[]> keysToDelete) throws StorageException {
        if (!replacementValues.isEmpty()) {
            this.store.put(replacementValues.mapSecond(FindingIdentificationIndex::serializeFindingIds));
        }
        if (!keysToDelete.isEmpty()) {
            this.store.remove(keysToDelete);
        }
    }
}

