/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;
import org.sonar.api.ce.ComputeEngineSide;
import org.sonar.api.scanner.ScannerSide;
import org.sonar.api.server.ServerSide;
import org.sonar.api.utils.Preconditions;

@ScannerSide
@ServerSide
@ComputeEngineSide
public class UriReader {
    private final Map<String, SchemeProcessor> processorsByScheme = new HashMap<String, SchemeProcessor>();

    public UriReader(SchemeProcessor[] processors) {
        Stream.concat(Stream.of(new FileProcessor()), Arrays.stream(processors)).forEach(processor -> {
            for (String scheme : processor.getSupportedSchemes()) {
                this.processorsByScheme.put(scheme.toLowerCase(Locale.ENGLISH), (SchemeProcessor)processor);
            }
        });
    }

    public byte[] readBytes(URI uri) {
        return this.searchForSupportedProcessor(uri).readBytes(uri);
    }

    public String readString(URI uri, Charset charset) {
        return this.searchForSupportedProcessor(uri).readString(uri, charset);
    }

    public String description(URI uri) {
        SchemeProcessor reader = this.searchForSupportedProcessor(uri);
        return reader.description(uri);
    }

    SchemeProcessor searchForSupportedProcessor(URI uri) {
        SchemeProcessor processor = this.processorsByScheme.get(uri.getScheme().toLowerCase(Locale.ENGLISH));
        Preconditions.checkArgument(processor != null, "URI schema is not supported: " + uri.getScheme());
        return processor;
    }

    private static class FileProcessor
    extends SchemeProcessor {
        private FileProcessor() {
        }

        @Override
        public String[] getSupportedSchemes() {
            return new String[]{"file"};
        }

        @Override
        protected byte[] readBytes(URI uri) {
            try {
                return Files.readAllBytes(Paths.get(uri));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        protected String readString(URI uri, Charset charset) {
            try {
                return new String(Files.readAllBytes(Paths.get(uri)), charset);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        protected String description(URI uri) {
            return new File(uri).getAbsolutePath();
        }
    }

    public static abstract class SchemeProcessor {
        protected abstract String[] getSupportedSchemes();

        protected abstract byte[] readBytes(URI var1);

        protected abstract String readString(URI var1, Charset var2);

        protected abstract String description(URI var1);
    }
}

