/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonarsource.sonarlint.core.analysis.AnalysisEngine;
import org.sonarsource.sonarlint.core.analysis.api.AnalysisResults;
import org.sonarsource.sonarlint.core.analysis.api.ClientModuleFileEvent;
import org.sonarsource.sonarlint.core.analysis.api.ClientModuleInfo;
import org.sonarsource.sonarlint.core.analysis.command.AnalyzeCommand;
import org.sonarsource.sonarlint.core.analysis.command.NotifyModuleEventCommand;
import org.sonarsource.sonarlint.core.analysis.command.RegisterModuleCommand;
import org.sonarsource.sonarlint.core.analysis.command.UnregisterModuleCommand;
import org.sonarsource.sonarlint.core.client.api.common.SonarLintEngine;
import org.sonarsource.sonarlint.core.client.api.exceptions.SonarLintWrappedException;
import org.sonarsource.sonarlint.core.commons.Language;
import org.sonarsource.sonarlint.core.commons.log.ClientLogOutput;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.commons.progress.ClientProgressMonitor;
import org.sonarsource.sonarlint.core.commons.progress.ProgressMonitor;
import org.sonarsource.sonarlint.core.plugin.commons.LoadedPlugins;
import org.sonarsource.sonarlint.core.rule.extractor.RulesDefinitionExtractor;
import org.sonarsource.sonarlint.core.rule.extractor.SonarLintRuleDefinition;

public abstract class AbstractSonarLintEngine
implements SonarLintEngine {
    protected static final SonarLintLogger LOG = SonarLintLogger.get();
    protected final ClientLogOutput logOutput;

    public abstract AnalysisEngine getAnalysisEngine();

    protected AbstractSonarLintEngine(@Nullable ClientLogOutput logOutput) {
        this.logOutput = logOutput;
    }

    @Override
    public CompletableFuture<Void> declareModule(ClientModuleInfo module) {
        return this.getAnalysisEngine().post(new RegisterModuleCommand(module), new ProgressMonitor(null));
    }

    @Override
    public CompletableFuture<Void> stopModule(Object moduleKey) {
        return this.getAnalysisEngine().post(new UnregisterModuleCommand(moduleKey), new ProgressMonitor(null));
    }

    @Override
    public CompletableFuture<Void> fireModuleFileEvent(Object moduleKey, ClientModuleFileEvent event) {
        return this.getAnalysisEngine().post(new NotifyModuleEventCommand(moduleKey, event), new ProgressMonitor(null));
    }

    protected static Map<String, SonarLintRuleDefinition> loadPluginMetadata(LoadedPlugins loadedPlugins, Set<Language> enabledLanguages, boolean includeTemplateRules, boolean hotspotsEnabled) {
        RulesDefinitionExtractor ruleExtractor = new RulesDefinitionExtractor();
        return ruleExtractor.extractRules(loadedPlugins.getPluginInstancesByKeys(), enabledLanguages, includeTemplateRules, hotspotsEnabled).stream().collect(Collectors.toMap(SonarLintRuleDefinition::getKey, r -> r));
    }

    protected void setLogging(@Nullable ClientLogOutput logOutput) {
        if (logOutput != null) {
            SonarLintLogger.setTarget(logOutput);
        } else {
            SonarLintLogger.setTarget(this.logOutput);
        }
    }

    protected AnalysisResults postAnalysisCommandAndGetResult(AnalyzeCommand analyzeCommand, @Nullable ClientProgressMonitor monitor) {
        try {
            AnalysisResults analysisResults = this.getAnalysisEngine().post(analyzeCommand, new ProgressMonitor(monitor)).get();
            return analysisResults == null ? new AnalysisResults() : analysisResults;
        }
        catch (ExecutionException e) {
            throw SonarLintWrappedException.wrap(e.getCause());
        }
        catch (Exception e) {
            throw SonarLintWrappedException.wrap(e);
        }
    }
}

