/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.analysis.container.analysis.issue.ignore.pattern;

import javax.annotation.Nullable;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.utils.WildcardPattern;
import org.sonarsource.sonarlint.core.analysis.container.analysis.SonarLintPathPattern;
import org.sonarsource.sonarlint.shaded.org.apache.commons.lang3.builder.ToStringBuilder;
import org.sonarsource.sonarlint.shaded.org.apache.commons.lang3.builder.ToStringStyle;

public class IssuePattern {
    private final SonarLintPathPattern pathPattern;
    private final WildcardPattern rulePattern;

    public IssuePattern(String pathPattern, String rulePattern) {
        this.pathPattern = new SonarLintPathPattern(pathPattern);
        this.rulePattern = WildcardPattern.create(rulePattern);
    }

    public WildcardPattern getRulePattern() {
        return this.rulePattern;
    }

    public boolean matchRule(RuleKey rule) {
        return this.rulePattern.match(rule.toString());
    }

    public boolean matchFile(@Nullable String filePath) {
        return filePath != null && this.pathPattern.match(filePath);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

