/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.admin.backup;

import com.teamscale.core.analysis.configuration.ConnectorUtils;
import com.teamscale.index.backup.write.EBackupExportExcludeOptions;
import com.teamscale.index.backup.write.EExternalDataExportGranularity;
import com.teamscale.index.backup.write.EExternalDataExportTarget;
import com.teamscale.index.backup.write.ExternalUploadExportOption;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.FormParam;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.conqat.engine.index.shared.PublicProjectId;

public class BackupExportParameters {
    @Schema(description="Include global data in the backup.")
    @FormParam(value="backup-global")
    private boolean includeGlobalData;
    @Schema(description="Includes all user visible projects in the backup.")
    @FormParam(value="include-all-visible-projects")
    @DefaultValue(value="false")
    private boolean includeAllVisibleProjects;
    @Schema(description="Include project data in the backup. May be present multiple times.")
    @FormParam(value="include-project")
    private Set<PublicProjectId> includedProjects;
    @Schema(description="The backup path. If this is not set, a new internal path will be generated.")
    @FormParam(value="backup-path")
    private String backupPath;
    @Schema(description="The granularity to apply for export of external data (DISCARD, DAILY, WEEKLY, PRESERVE). May be present multiple times.")
    @FormParam(value="export-option-granularity")
    private List<EExternalDataExportGranularity> exportOptionGranularities = new ArrayList<EExternalDataExportGranularity>();
    @Schema(description="The target to apply for export of external data. May be present multiple times.")
    @FormParam(value="export-option-target")
    private List<EExternalDataExportTarget> exportOptionTargets = new ArrayList<EExternalDataExportTarget>();
    @Schema(description="The start date for export of external data. May be present multiple times.")
    @FormParam(value="export-option-date")
    private List<String> exportOptionDates = new ArrayList<String>();
    @Schema(description="The branch (pattern) for which rules are applied. May be present multiple times.")
    @FormParam(value="export-option-branch")
    private List<String> exportOptionBranches = new ArrayList<String>();
    @Schema(description="The partition (pattern) for which rules are applied. May be present multiple times.")
    @FormParam(value="export-option-partition")
    private List<String> exportOptionPartitions = new ArrayList<String>();
    @Schema(description="The partition (pattern) for which rules are applied. May be present multiple times.")
    @FormParam(value="export-option-project")
    private List<String> exportOptionProjects = new ArrayList<String>();
    @Schema(description="The set of excluded storages.")
    @FormParam(value="export-exclude-options")
    private Set<EBackupExportExcludeOptions> exportExcludeOptions = new HashSet<EBackupExportExcludeOptions>();

    public boolean isIncludeGlobalData() {
        return this.includeGlobalData;
    }

    public void setIncludeGlobalData(boolean includeGlobalData) {
        this.includeGlobalData = includeGlobalData;
    }

    public boolean isIncludeAllVisibleProjects() {
        return this.includeAllVisibleProjects;
    }

    public void setIncludeAllVisibleProjects(boolean includeAllVisibleProjects) {
        this.includeAllVisibleProjects = includeAllVisibleProjects;
    }

    public Set<PublicProjectId> getIncludedProjects() {
        return this.includedProjects;
    }

    public void setIncludedProjects(Set<PublicProjectId> includedProjects) {
        this.includedProjects = includedProjects;
    }

    public Set<EBackupExportExcludeOptions> getExportExcludeOptions() {
        return this.exportExcludeOptions;
    }

    public void setExportExcludeOptions(Set<EBackupExportExcludeOptions> exportExcludeOptions) {
        this.exportExcludeOptions = exportExcludeOptions;
    }

    public String getBackupPath() {
        return this.backupPath;
    }

    public void setBackupPath(String backupPath) {
        this.backupPath = backupPath;
    }

    public List<ExternalUploadExportOption> getExternalUploadExportOption() {
        int count = this.exportOptionGranularities.size();
        if (this.exportOptionTargets.size() != count || this.exportOptionDates.size() != count || this.exportOptionBranches.size() != count || this.exportOptionPartitions.size() != count) {
            throw new BadRequestException("Did not receive complete export rules. For some parts there were more instances than for the others.");
        }
        ArrayList<ExternalUploadExportOption> options = new ArrayList<ExternalUploadExportOption>();
        for (int i = 0; i < count; ++i) {
            String exportOptionDate = this.exportOptionDates.get(i);
            long beforeTimestamp = (Long)ConnectorUtils.getTimestampForDate((String)exportOptionDate).orElseThrow(() -> new BadRequestException("Failed to parse '" + exportOptionDate + "' as a date."));
            String branchPattern = this.exportOptionBranches.get(i);
            BackupExportParameters.validatePatternCompilation(branchPattern, "branch");
            String partitionPattern = this.exportOptionPartitions.get(i);
            BackupExportParameters.validatePatternCompilation(partitionPattern, "partition");
            String projectPattern = this.exportOptionProjects.get(i);
            BackupExportParameters.validatePatternCompilation(projectPattern, "project");
            options.add(new ExternalUploadExportOption(this.exportOptionGranularities.get(i), this.exportOptionTargets.get(i), beforeTimestamp, branchPattern, partitionPattern, projectPattern));
        }
        return options;
    }

    private static void validatePatternCompilation(String branchPattern, String name) {
        try {
            Pattern.compile(branchPattern);
        }
        catch (PatternSyntaxException e) {
            throw new BadRequestException("Invalid " + name + " pattern provided for rule: " + branchPattern + ". " + e.getMessage(), (Throwable)e);
        }
    }
}

