/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.ai.debug;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.ai.AiEngineUsageIndex;
import com.teamscale.core.ai.IAiEngineProvider;
import com.teamscale.core.ai.LlmPrompt;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.service.base.debug.DebugDumpServiceBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;

@Path(value="api/ai/debug/usage")
public class DebugAiUsageService
extends DebugDumpServiceBase {
    @GET
    @Operation(summary="Get AI usage information", description="Returns textual information about the configured AI providers and the current usage statistics.", tags={"Debugging"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Produces(value={"text/plain"})
    public String getAiUsageStatistics() throws StorageException {
        return this.getDebugDumpResults();
    }

    @Override
    protected void generateDump(PrintWriter writer) throws StorageException {
        this.dumpAndRunAvailableAiProviders(writer);
        this.dumpUsage(writer);
    }

    private void dumpAndRunAvailableAiProviders(PrintWriter writer) {
        List aiEngineDescriptions = this.serviceInfo.getAiEngineProvider().listAvailableAiEngines();
        if (aiEngineDescriptions.isEmpty()) {
            writer.println("No AI provider configured");
            return;
        }
        for (IAiEngineProvider.AiEngineDescription description : aiEngineDescriptions) {
            writer.println(description.displayName() + " (" + description.internalName() + "):");
            try {
                writer.println(this.serviceInfo.getAiEngineProvider().complete(description.internalName(), new LlmPrompt("Who are you?", new String[0])));
            }
            catch (ServiceCallException e) {
                writer.println("Completion failed: " + e.getMessage());
            }
            writer.println();
        }
    }

    private void dumpUsage(PrintWriter writer) throws StorageException {
        writer.println("\nUsage:");
        AiEngineUsageIndex usageIndex = this.openGlobalIndex(AiEngineUsageIndex.class);
        Map usageData = usageIndex.getUsageData();
        for (String key : CollectionUtils.sort(usageData.keySet())) {
            writer.println(key + ": " + String.valueOf(usageData.get(key)));
        }
    }
}

