/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.architecture;

import com.teamscale.core.concurrency.IParallelTaskExecutor;
import com.teamscale.index.architecture.ArchitectureEditorUtils;
import com.teamscale.index.architecture.assessment.TypeToComponentMapper;
import com.teamscale.index.architecture.commons.EFindingCreationType;
import com.teamscale.index.architecture.commons.EStereotype;
import com.teamscale.index.architecture.scope.ArchitectureDefinition;
import com.teamscale.index.architecture.scope.ArchitectureDefinitionReader;
import com.teamscale.index.architecture.scope.ComponentNode;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.service.framework.ITeamscaleServiceInfo;
import jakarta.ws.rs.BadRequestException;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.ArchitectureCreationModificationInfo;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.string.StringUtils;

public class ArchitectureConverter {
    private final ITeamscaleServiceInfo serviceInfo;
    private final String architecturePath;
    private final String templatePath;
    private final HistoryAccessOption historyAccessOption;
    private final IParallelTaskExecutor parallelTaskExecutor;

    public ArchitectureConverter(ITeamscaleServiceInfo serviceInfo, String templatePath, String architecturePath, HistoryAccessOption historyAccessOption, IParallelTaskExecutor parallelTaskExecutor) {
        this.serviceInfo = serviceInfo;
        this.architecturePath = architecturePath;
        this.templatePath = templatePath;
        this.historyAccessOption = historyAccessOption;
        this.parallelTaskExecutor = parallelTaskExecutor;
    }

    public String convertArchitecture(String content, EArchitectureFormat format) throws StorageException, BadRequestException {
        if (format == null) {
            format = EArchitectureFormat.TEAMSCALE_ARCHITECTURE;
        }
        return switch (format.ordinal()) {
            case 0 -> content;
            case 1 -> this.createFileListArchitecture(content);
            default -> throw new AssertionError((Object)("Unknown format: " + String.valueOf((Object)format)));
        };
    }

    private String createFileListArchitecture(String content) throws StorageException, BadRequestException {
        ArchitectureDefinition architecture;
        Optional<ArchitectureDefinition> templateArchitecture = this.obtainTemplateArchitecture();
        String architectureName = UniformPathUtils.getElementName((String)this.architecturePath);
        ArchitectureCreationModificationInfo creationAndModificationInfo = ArchitectureCreationModificationInfo.created((String)this.serviceInfo.getUser().getFullName(), (Long)System.currentTimeMillis());
        try {
            architecture = new ArchitectureDefinition(architectureName, true, EFindingCreationType.NONE, ".*", "", creationAndModificationInfo);
        }
        catch (ConQATException e) {
            throw new AssertionError("Should not happen, as patterns are fixed!", e);
        }
        ArrayList paths = CollectionUtils.sort((Collection)CollectionUtils.filterAndMap((Collection)StringUtils.splitLinesAsList((String)content), line -> !StringUtils.isEmpty((String)line), String::trim));
        if (templateArchitecture.isPresent()) {
            TypeToComponentMapper typeToComponentMapper = new TypeToComponentMapper(templateArchitecture.get(), this.parallelTaskExecutor);
            TypeToComponentMapper.MappingResult mappingResult = typeToComponentMapper.map(new HashSet(paths));
            HashMap<ComponentNode, ComponentNode> templateToTargetComponent = new HashMap<ComponentNode, ComponentNode>();
            this.duplicateComponentHierarchyFromTemplate((ComponentNode)architecture, (ComponentNode)templateArchitecture.get(), templateToTargetComponent);
            ArchitectureConverter.insertPathsIntoComponents(paths, templateToTargetComponent, mappingResult);
        } else {
            ComponentNode component = new ComponentNode("all", new Point(100, 100), new Dimension(400, 200), EStereotype.NONE);
            architecture.addSubComponent(component);
            paths.forEach(path -> component.addIncludePattern(Pattern.quote(path)));
        }
        return ArchitectureEditorUtils.architectureDefinitionToXML((ArchitectureDefinition)architecture, (PublicProjectId)this.serviceInfo.getPrimaryPublicId());
    }

    private static void insertPathsIntoComponents(List<String> paths, Map<ComponentNode, ComponentNode> templateToTargetComponent, TypeToComponentMapper.MappingResult mappingResult) {
        for (String path : paths) {
            ComponentNode mappedComponent = (ComponentNode)mappingResult.getMappedComponentForType(path).orElseThrow(() -> new IllegalStateException(path));
            ComponentNode targetComponent = templateToTargetComponent.get(mappedComponent);
            CCSMAssert.isNotNull((Object)targetComponent);
            targetComponent.addIncludePattern(Pattern.quote(path));
        }
    }

    private void duplicateComponentHierarchyFromTemplate(ComponentNode targetNode, ComponentNode templateNode, Map<ComponentNode, ComponentNode> templateToTargetComponent) {
        for (ComponentNode templateComponent : templateNode.getSubComponents()) {
            ComponentNode targetComponent = new ComponentNode(templateComponent.getName(), templateComponent.getPosition(), templateComponent.getDimension(), EStereotype.NONE);
            targetNode.addSubComponent(targetComponent);
            templateToTargetComponent.put(templateComponent, targetComponent);
            if (!templateComponent.hasSubComponents()) continue;
            this.duplicateComponentHierarchyFromTemplate(targetComponent, templateComponent, templateToTargetComponent);
        }
    }

    private Optional<ArchitectureDefinition> obtainTemplateArchitecture() throws StorageException, BadRequestException {
        if (StringUtils.isEmpty((String)this.templatePath)) {
            return Optional.empty();
        }
        TokenElementIndex contentIndex = (TokenElementIndex)this.serviceInfo.getProjectStorageSystem().openProjectIndex(TokenElementIndex.class, "content", this.historyAccessOption);
        TokenElementInfo element = contentIndex.getTokenElement(this.templatePath);
        if (element == null) {
            throw new BadRequestException("Could not find template architecture with path " + this.templatePath);
        }
        try {
            return Optional.of(ArchitectureDefinitionReader.read((String)element.getUniformPath(), (String)element.getText()));
        }
        catch (ConQATException e) {
            throw new BadRequestException("File stored at template architecture path " + this.templatePath + " is not a valid architecture file: " + e.getMessage(), (Throwable)e);
        }
    }

    @ExportToTypeScript
    public static enum EArchitectureFormat {
        TEAMSCALE_ARCHITECTURE,
        FILE_LIST;

    }
}

