/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.architecture;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.architecture.commons.EFindingCreationType;
import org.conqat.lib.commons.js_export.ExportToTypeScript;

public class ArchitectureOverviewInfo {
    private static final String UNIFORM_PATH_PROPERTY = "uniformPath";
    private static final String CHANGE_TYPE_PROPERTY = "changeType";
    private static final String IS_REPOSITORY_ARCHITECTURE_PROPERTY = "isRepositoryArchitecture";
    private static final String ORPHANS_PROPERTY = "orphans";
    private static final String VIOLATIONS_PROPERTY = "violations";
    private static final String FINDING_CREATION_PROPERTY = "findingCreation";
    private static final String CREATION_TIMESTAMP_PROPERTY = "creationTimestamp";
    private static final String MODIFICATION_TIMESTAMP_PROPERTY = "modificationTimestamp";
    @JsonProperty(value="uniformPath")
    private final String uniformPath;
    @JsonProperty(value="changeType")
    private final EArchitecturePendingChangeType changeType;
    @JsonProperty(value="isRepositoryArchitecture")
    private final boolean isRepositoryArchitecture;
    @JsonProperty(value="orphans")
    private final int orphans;
    @JsonProperty(value="violations")
    private final int violations;
    @JsonProperty(value="findingCreation")
    private final String findingCreation;
    @JsonProperty(value="creationTimestamp")
    private final long creationTimestamp;
    @JsonProperty(value="modificationTimestamp")
    private final long modificationTimestamp;

    public ArchitectureOverviewInfo(String uniformPath, EArchitecturePendingChangeType changeType, boolean isRepositoryArchitecture, int violations, int orphans, EFindingCreationType findingCreation, long creationTimestamp, long modificationTimestamp) {
        this(uniformPath, changeType, isRepositoryArchitecture, violations, orphans, findingCreation.getReadableName(), creationTimestamp, modificationTimestamp);
    }

    @JsonCreator
    public ArchitectureOverviewInfo(@JsonProperty(value="uniformPath") String uniformPath, @JsonProperty(value="changeType") EArchitecturePendingChangeType changeType, @JsonProperty(value="isRepositoryArchitecture") boolean isRepositoryArchitecture, @JsonProperty(value="violations") int violations, @JsonProperty(value="orphans") int orphans, @JsonProperty(value="findingCreation") String findingCreation, @JsonProperty(value="creationTimestamp") long creationTimestamp, @JsonProperty(value="modificationTimestamp") long modificationTimestamp) {
        this.uniformPath = uniformPath;
        this.changeType = changeType;
        this.isRepositoryArchitecture = isRepositoryArchitecture;
        this.violations = violations;
        this.orphans = orphans;
        this.findingCreation = findingCreation;
        this.creationTimestamp = creationTimestamp;
        this.modificationTimestamp = modificationTimestamp;
    }

    public String getUniformPath() {
        return this.uniformPath;
    }

    public EArchitecturePendingChangeType getChangeType() {
        return this.changeType;
    }

    public String toString() {
        return this.uniformPath + ": " + this.changeType.name();
    }

    public boolean equals(Object other) {
        if (other instanceof ArchitectureOverviewInfo) {
            ArchitectureOverviewInfo otherChangeInfo = (ArchitectureOverviewInfo)other;
            return this.uniformPath.equals(otherChangeInfo.uniformPath) && this.changeType.equals((Object)otherChangeInfo.changeType);
        }
        return false;
    }

    public int hashCode() {
        return this.uniformPath.hashCode() + this.changeType.hashCode();
    }

    @ExportToTypeScript
    public static enum EArchitecturePendingChangeType {
        ADD,
        MODIFY,
        DELETE,
        NONE;

    }
}

