/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.findings;

import com.google.common.collect.ImmutableList;
import com.teamscale.commons.links.TeamscaleCommitLinkProvider;
import com.teamscale.index.findings.calculation.EFindingsExportFormat;
import com.teamscale.index.findings.calculation.ExtendedFindingsWithCount;
import com.teamscale.index.findings.calculation.FilteredFindingsList;
import com.teamscale.index.findings.calculation.FindingsFilterSettings;
import com.teamscale.index.findings.calculation.FindingsPaginationOptions;
import com.teamscale.index.resource.path_lookup.PathLookupIndex;
import com.teamscale.index.tracking.ExtendedTrackedFinding;
import com.teamscale.index.tracking.index.TrackedFindingsByIdIndex;
import com.teamscale.service.findings.FilteredFindingsServiceBase;
import com.teamscale.service.findings.FindingsSortUtils;
import com.teamscale.service.findings.options.FindingSortOptions;
import com.teamscale.service.findings.options.LegacyFindingResponseFormatOptions;
import com.teamscale.service.framework.util.ResponseUtils;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;

public class ElementFindingsServiceBase
extends FilteredFindingsServiceBase {
    protected ExtendedFindingsWithCount retrieveFilteredFindingsWithSortingAndPagination(UniformPath uniformPath, boolean caseInsensitivePath, FindingsFilterSettings findingsFilterSettings, FindingSortOptions sortOptions, FindingsPaginationOptions paginationOptions) throws StorageException {
        HistoryAccessOption historyAccessOption;
        PathLookupIndex pathLookupIndex;
        ImmutableList possiblePaths;
        if (caseInsensitivePath && (possiblePaths = (pathLookupIndex = this.openProjectIndex(PathLookupIndex.class, historyAccessOption = this.determineHistoryOption(findingsFilterSettings.getCommit()))).lookupSuffix(uniformPath.toString())).size() == 1) {
            uniformPath = UniformPath.ofSegments((String[])((String)possiblePaths.getFirst()).split(UniformPathUtils.SEPARATOR));
        }
        FilteredFindingsList filteredFindings = this.retrieveFilteredFindings(uniformPath, findingsFilterSettings);
        List<ExtendedTrackedFinding> adjustedFindings = ElementFindingsServiceBase.applySortingAndPagination(filteredFindings.filteredFindings(), sortOptions, paginationOptions);
        adjustedFindings = this.updateDeathCommitsAndAdjustLocations(adjustedFindings, findingsFilterSettings.getCommit());
        return new ExtendedFindingsWithCount(adjustedFindings, filteredFindings.excludedFindingsCount());
    }

    protected Response applyLegacyType(ExtendedFindingsWithCount findingsWithCount, LegacyFindingResponseFormatOptions responseFormat, CommitDescriptor exportCommit) {
        if (responseFormat.getExportFormat() != null) {
            return ElementFindingsServiceBase.createFindingsExportDownload(responseFormat.getExportFormat(), findingsWithCount.findings(), this.serviceInfo.getRequestBaseUri(), this.serviceInfo.getPrimaryPublicId(), exportCommit);
        }
        if (responseFormat.isWrappedInCount()) {
            return Response.ok((Object)findingsWithCount).build();
        }
        List findings = CollectionUtils.map((Collection)findingsWithCount.findings(), finding -> {
            TrackedFinding trackedFinding = new TrackedFinding((TrackedFinding)finding);
            trackedFinding.setProperties(finding.getProperties());
            return trackedFinding;
        });
        return Response.ok((Object)findings).build();
    }

    protected static Response createFindingsExportDownload(EFindingsExportFormat format, List<ExtendedTrackedFinding> findings, URI baseUri, PublicProjectId projectId, CommitDescriptor exportCommit) {
        Object entity = format.createPayload(findings, new TeamscaleCommitLinkProvider(baseUri.toString(), projectId, null), exportCommit);
        MediaType contentType = format.getMediaType();
        String fileName = "findings-" + String.valueOf(projectId) + "." + format.getDownloadExtension();
        return ResponseUtils.getFileDownloadResponse((Object)entity, (MediaType)contentType, (String)fileName);
    }

    protected static List<ExtendedTrackedFinding> applySortingAndPagination(List<ExtendedTrackedFinding> findings, FindingSortOptions sortOptions, FindingsPaginationOptions paginationOptions) {
        ArrayList<ExtendedTrackedFinding> adjustedFindings = new ArrayList<ExtendedTrackedFinding>(findings);
        FindingsSortUtils.sortFindings(adjustedFindings, sortOptions);
        return paginationOptions.selectFindingsRange(adjustedFindings);
    }

    protected <T extends TrackedFinding> List<T> updateDeathCommitsAndAdjustLocations(List<T> findings, UnresolvedCommitDescriptor commit) throws StorageException {
        HistoryAccessOption historyAccessOption = this.determineHistoryOption(commit);
        this.updateDeathCommits(findings, historyAccessOption);
        return findings;
    }

    private <T extends TrackedFinding> void updateDeathCommits(List<T> findings, HistoryAccessOption historyAccessOption) throws StorageException {
        if (historyAccessOption.isReadHead()) {
            return;
        }
        String branchName = historyAccessOption.getBranchName();
        HistoryAccessOption accessBranchHead = HistoryAccessOption.readHead((String)branchName);
        this.openProjectIndex(TrackedFindingsByIdIndex.class, accessBranchHead).updateDeathCommits(findings);
    }
}

