/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.monitoring.prometheus.collectors;

import com.teamscale.core.index.IndexLayer;
import com.teamscale.service.monitoring.prometheus.collectors.IndexCallbackMetricsProviderBase;
import com.teamscale.service.system.health.GlobalStorageMetricsProvider;
import io.prometheus.metrics.core.metrics.CounterWithCallback;
import io.prometheus.metrics.model.snapshots.Unit;
import java.util.Map;
import java.util.function.Function;
import org.conqat.engine.persistence.store.profiler.DetailedStorageProfiler;
import org.conqat.engine.persistence.store.profiler.StoreOperationStatistics;
import org.conqat.lib.commons.collections.TwoDimHashMap;

public class GlobalStorageMetricCollector
extends IndexCallbackMetricsProviderBase {
    private static final String[] STORE_OPERATION_BASED_METRIC_LABELS = new String[]{"storage_system", "store", "operation"};

    private static void collectStorageMetricValue(CounterWithCallback.Callback cb, Function<StoreOperationStatistics, Double> valueAccessor) {
        Map<String, Map<DetailedStorageProfiler.EStoreOperation, StoreOperationStatistics>> operationStatisticsByStore = GlobalStorageMetricsProvider.getOperationStatisticsByStore();
        for (Map.Entry<String, Map<DetailedStorageProfiler.EStoreOperation, StoreOperationStatistics>> entry : operationStatisticsByStore.entrySet()) {
            String[] parts = entry.getKey().split("/", 2);
            String storageSystem = parts[0];
            String store = parts[1];
            for (Map.Entry<DetailedStorageProfiler.EStoreOperation, StoreOperationStatistics> operationEntry : entry.getValue().entrySet()) {
                String operation = operationEntry.getKey().name().toLowerCase();
                cb.call(valueAccessor.apply(operationEntry.getValue()).doubleValue(), new String[]{storageSystem, store, operation});
            }
        }
    }

    public GlobalStorageMetricCollector(IndexLayer indexLayer) {
        super(indexLayer);
    }

    private static TwoDimHashMap<String, String, Double> buildStoreOpenCountsMetrics() {
        TwoDimHashMap values = new TwoDimHashMap();
        for (Map.Entry<String, Integer> entry : GlobalStorageMetricsProvider.getStoreOpenCounts().entrySet()) {
            String[] parts = entry.getKey().split("/", 2);
            values.putValue((Object)parts[0], (Object)parts[1], (Object)entry.getValue());
        }
        return values;
    }

    static {
        ((CounterWithCallback.Builder)((CounterWithCallback.Builder)CounterWithCallback.builder().name("store_open").help("Number of opening operations for a store.")).labelNames(new String[]{"storage_system", "store"})).callback(cb -> {
            TwoDimHashMap<String, String, Double> storeOpenCountsByStorageSystemAndStore = GlobalStorageMetricCollector.buildStoreOpenCountsMetrics();
            GlobalStorageMetricCollector.collectMetricValueByTwoDimHashmap(cb, storeOpenCountsByStorageSystemAndStore);
        }).register();
        ((CounterWithCallback.Builder)((CounterWithCallback.Builder)CounterWithCallback.builder().name("store_operation").help("Number of storage operations")).labelNames(STORE_OPERATION_BASED_METRIC_LABELS)).callback(cb -> GlobalStorageMetricCollector.collectStorageMetricValue(cb, stats -> stats.getNumberOfOperations())).register();
        ((CounterWithCallback.Builder)((CounterWithCallback.Builder)CounterWithCallback.builder().name("store_operation_key").help("Number of overall affected keys in storage operations")).labelNames(STORE_OPERATION_BASED_METRIC_LABELS)).callback(cb -> GlobalStorageMetricCollector.collectStorageMetricValue(cb, stats -> stats.getKeysInOperation())).register();
        ((CounterWithCallback.Builder)((CounterWithCallback.Builder)((CounterWithCallback.Builder)CounterWithCallback.builder().name("store_operation_key_bytes").help("Number of overall bytes in keys")).labelNames(STORE_OPERATION_BASED_METRIC_LABELS)).unit(Unit.BYTES)).callback(cb -> GlobalStorageMetricCollector.collectStorageMetricValue(cb, stats -> stats.getKeyBytesRead())).register();
        ((CounterWithCallback.Builder)((CounterWithCallback.Builder)((CounterWithCallback.Builder)CounterWithCallback.builder().name("store_operation_value_bytes").help("Number of overall bytes in values")).labelNames(STORE_OPERATION_BASED_METRIC_LABELS)).unit(Unit.BYTES)).callback(cb -> GlobalStorageMetricCollector.collectStorageMetricValue(cb, stats -> stats.getValueBytesRead())).register();
        ((CounterWithCallback.Builder)((CounterWithCallback.Builder)((CounterWithCallback.Builder)CounterWithCallback.builder().name("store_operation_duration_seconds").help("Number of seconds of storage operations")).labelNames(STORE_OPERATION_BASED_METRIC_LABELS)).unit(Unit.SECONDS)).callback(cb -> GlobalStorageMetricCollector.collectStorageMetricValue(cb, stats -> (double)stats.getOperationDurationMs() / 1000.0)).register();
    }
}

