/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testimpact;

import com.teamscale.index.testimpact.ManualSapTestInfo;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.QueryParam;
import java.util.Optional;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.tests.ETestExecutionResult;

public class SapTestEventListenerServiceQueryOptions {
    @Parameter(description="Name of the user in the SAP system that executes the test as configured in the Chrome extension.", required=true)
    @QueryParam(value="sap-user-name")
    private String sapUser;
    @Parameter(description="Test id, which is identical to the Work Item Id in Azure DevOps, belonging to the test that is currently executed.", required=true)
    @QueryParam(value="test-id")
    private int testId;
    @Parameter(description="Test result, one of: PASSED, IGNORED, SKIPPED, FAILURE, ERROR")
    @QueryParam(value="result")
    private String result;
    @Parameter(description="Name of the test with (if existent) parameters. Different parameters in Azure DevOps happen in different iteration runs.")
    @QueryParam(value="extended-name")
    private String extendedName;
    @Parameter(description="Message or note that should be attached to the test run and displayed in Teamscale.")
    @QueryParam(value="message")
    private String message;

    public String getSapUser() {
        return this.sapUser.toUpperCase();
    }

    public int getTestId() {
        return this.testId;
    }

    public ETestExecutionResult getResult() {
        if (this.result == null || this.result.isEmpty()) {
            return null;
        }
        return ETestExecutionResult.valueOf((String)this.result);
    }

    public String getExtendedName() {
        if (this.extendedName == null || this.extendedName.isEmpty()) {
            return null;
        }
        return this.extendedName;
    }

    public String getMessage() {
        if (this.message == null || this.message.isEmpty()) {
            return null;
        }
        return this.message;
    }

    public ManualSapTestInfo toManualSapTestInfo(InternalProjectId projectId, String fallbackName) {
        return new ManualSapTestInfo(this.testId, this.getSapUser(), projectId, this.getResult(), Optional.ofNullable(this.getExtendedName()).orElse(fallbackName), this.getMessage());
    }

    public ManualSapTestInfo toManualSapTestInfo(InternalProjectId projectId) {
        return new ManualSapTestInfo(this.testId, this.getSapUser(), projectId, this.getResult(), this.getExtendedName(), this.getMessage());
    }
}

