/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testimpact;

import com.teamscale.index.testimpact.TestListDescriptor;
import com.teamscale.index.testimpact.TestListIndex;
import com.teamscale.service.base.ElementListServiceBase;
import com.teamscale.service.testimpact.IStoredTestListsService;
import jakarta.ws.rs.Path;
import java.util.List;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/projects/{project}/test-lists")
public class StoredTestListsService
extends ElementListServiceBase<TestListDescriptor>
implements IStoredTestListsService {
    @Override
    public List<TestListDescriptor> getStoredTestLists() throws StorageException {
        return this.getIndex().getAllTestLists();
    }

    @Override
    public List<String> getStoredTestListsNames() throws StorageException {
        return this.getIndex().getAllTestLists().stream().map(TestListDescriptor::getName).toList();
    }

    @Override
    public void saveTestListDescriptor(TestListDescriptor testListDescriptor) throws StorageException {
        this.createElementAndPermissions(testListDescriptor);
    }

    @Override
    public void deleteTestListDescriptor(String testListName) throws StorageException {
        TestListDescriptor paretoListDescriptor = (TestListDescriptor)this.getElementWithExistsCheck(testListName);
        this.deleteElementAndPermissions(paretoListDescriptor);
    }

    private TestListIndex getIndex() throws StorageException {
        return this.openProjectIndex(TestListIndex.class, null);
    }

    @Override
    protected void createPermissions(TestListDescriptor newElement) {
    }

    @Override
    protected void deleteElement(TestListDescriptor elementToDelete) throws StorageException {
        this.getIndex().removeTestList(elementToDelete.getName());
    }

    @Override
    protected void deletePermissions(TestListDescriptor deletedElement) {
    }

    @Override
    protected TestListDescriptor getElement(String elementName) throws StorageException {
        return this.getIndex().getTestList(elementName);
    }

    @Override
    protected void updateElement(TestListDescriptor oldElement, TestListDescriptor newElement) throws StorageException {
        this.getIndex().storeTestList(newElement);
    }

    @Override
    protected void createElement(TestListDescriptor newElement) throws StorageException {
        this.getIndex().storeTestList(newElement);
    }
}

