/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testimpact.prioritization.preprocessing;

import com.teamscale.service.testimpact.prioritization.preprocessing.ITestPrioritizationPreprocessingStep;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;

public class PreprocessingStepManager {
    private final Map<Class<? extends ITestPrioritizationPreprocessingStep>, ITestPrioritizationPreprocessingStep> registeredStepsByClass = new HashMap<Class<? extends ITestPrioritizationPreprocessingStep>, ITestPrioritizationPreprocessingStep>();

    public void registerStep(ITestPrioritizationPreprocessingStep step) {
        this.registerStep(step.getClass(), step);
    }

    private void registerStep(Class<? extends ITestPrioritizationPreprocessingStep> key, ITestPrioritizationPreprocessingStep step) {
        this.registeredStepsByClass.put(key, step);
    }

    public ITestPrioritizationPreprocessingStep getStep(Class<? extends ITestPrioritizationPreprocessingStep> stepClass) {
        ITestPrioritizationPreprocessingStep preprocessingStep = this.registeredStepsByClass.get(stepClass);
        if (preprocessingStep == null) {
            throw new NoSuchElementException("No step of type '" + stepClass.getName() + "' exists");
        }
        return preprocessingStep;
    }

    public boolean isRegistered(Class<? extends ITestPrioritizationPreprocessingStep> stepClass) {
        return this.registeredStepsByClass.containsKey(stepClass);
    }
}

