/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testimpact.prioritization.strategies;

import com.teamscale.index.testimpact.MethodId;
import com.teamscale.service.testimpact.MinimizationProgressCallback;
import com.teamscale.service.testimpact.prioritization.IPrioritizableTests;
import com.teamscale.service.testimpact.prioritization.PrioritizeUnderBudgetCallback;
import com.teamscale.service.testimpact.prioritization.strategies.TestPrioritizationStrategyBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.conqat.engine.persistence.store.StorageException;
import org.jspecify.annotations.Nullable;

public abstract class NonRoundBasedTestPrioritizationStrategyBase
extends TestPrioritizationStrategyBase {
    public NonRoundBasedTestPrioritizationStrategyBase(MinimizationProgressCallback progressCallback) {
        super(progressCallback);
    }

    abstract <T extends IPrioritizableTests> List<T> orderMultipleTests(Collection<T> var1);

    @Override
    public <T extends IPrioritizableTests> List<T> orderMultipleTests(Collection<T> relevantTests, Set<MethodId> methodsToTest, @Nullable Long maxTestSuiteRuntimeMs, PrioritizeUnderBudgetCallback<T> budgetCallback) throws InterruptedException, StorageException {
        List<T> orderedTests = this.orderMultipleTests(relevantTests);
        return NonRoundBasedTestPrioritizationStrategyBase.getOrderedTestsUntilBudgetExceeded(orderedTests, maxTestSuiteRuntimeMs, budgetCallback);
    }

    private static <T extends IPrioritizableTests> List<T> getOrderedTestsUntilBudgetExceeded(List<T> orderedTests, Long maxTestSuiteRuntimeMs, PrioritizeUnderBudgetCallback<T> budgetCallback) throws InterruptedException, StorageException {
        if (maxTestSuiteRuntimeMs == null) {
            return orderedTests.stream().toList();
        }
        ArrayList<IPrioritizableTests> timeBoxedOrderedTests = new ArrayList<IPrioritizableTests>();
        long remainingBudget = maxTestSuiteRuntimeMs;
        for (IPrioritizableTests element : orderedTests) {
            long testDuration = (element = budgetCallback.prioritizeTests(element, remainingBudget)).getDurationInMs(10000L);
            if (remainingBudget < testDuration) continue;
            timeBoxedOrderedTests.add(element);
            if ((remainingBudget -= testDuration) != 0L) continue;
            break;
        }
        return timeBoxedOrderedTests;
    }
}

