/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.preprocessor.c;

import com.google.common.collect.MoreCollectors;
import eu.cqse.check.framework.preprocessor.c.CPreprocessingUtils;
import eu.cqse.check.framework.preprocessor.c.CPreprocessor;
import eu.cqse.check.framework.preprocessor.c.CompilerDefinedMacroNames;
import eu.cqse.check.framework.preprocessor.c.MacroDefinition;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.conqat.lib.commons.assertion.CCSMAssert;

class CompilerDefinedMacroSupplier {
    private static final Map<String, CompilerDefinedMacroNames> NAMES = Arrays.stream(CompilerDefinedMacroNames.values()).collect(Collectors.groupingBy(name -> name.macroName, MoreCollectors.onlyElement()));

    CompilerDefinedMacroSupplier() {
    }

    static Optional<MacroDefinition> getMacroForName(String macroName, CPreprocessor.IncludedFilesContext includedFiles, CPreprocessor.FilePreprocessorContext context) {
        CompilerDefinedMacroNames macroNameElement = NAMES.get(macroName);
        if (macroNameElement == null) {
            return Optional.empty();
        }
        switch (macroNameElement) {
            case FILE: {
                return Optional.of(MacroDefinition.parseMacroDefinition("__FILE__ \"" + context.uniformPath + "\"", CPreprocessingUtils.LOCATION_FOR_INTERNAL_DEFAULT_DEFINES, context.translationUnitLanguage));
            }
            case LINE: {
                return Optional.of(MacroDefinition.parseMacroDefinition("__LINE__ " + (context.lineNumber + 1), CPreprocessingUtils.LOCATION_FOR_INTERNAL_DEFAULT_DEFINES, context.translationUnitLanguage));
            }
            case INCLUDE_LEVEL: {
                return Optional.of(MacroDefinition.parseMacroDefinition("__INCLUDE_LEVEL__ " + (includedFiles.getCurrentIncludeHierarchy().size() - 1), CPreprocessingUtils.LOCATION_FOR_INTERNAL_DEFAULT_DEFINES, context.translationUnitLanguage));
            }
            case TEAMSCALE_IS_C: {
                return Optional.of(CompilerDefinedMacroSupplier.getLanguageQueryMacro(CompilerDefinedMacroNames.TEAMSCALE_IS_C, ELanguage.C, context));
            }
            case TEAMSCALE_IS_CPP: {
                return Optional.of(CompilerDefinedMacroSupplier.getLanguageQueryMacro(CompilerDefinedMacroNames.TEAMSCALE_IS_CPP, ELanguage.CPP, context));
            }
            case TEAMSCALE_IS_OBJECTIVE_C: {
                return Optional.of(CompilerDefinedMacroSupplier.getLanguageQueryMacro(CompilerDefinedMacroNames.TEAMSCALE_IS_OBJECTIVE_C, ELanguage.OBJECTIVE_C, context));
            }
            case TEAMSCALE_IS_OBJECTIVE_CPP: {
                return Optional.of(CompilerDefinedMacroSupplier.getLanguageQueryMacro(CompilerDefinedMacroNames.TEAMSCALE_IS_OBJECTIVE_CPP, ELanguage.OBJECTIVE_CPP, context));
            }
        }
        if (macroNameElement.getDefinition(context.translationUnitLanguage) == null) {
            CCSMAssert.fail((String)("missing case for context-sensitive default macro " + String.valueOf((Object)macroNameElement)));
            return Optional.empty();
        }
        return Optional.ofNullable(macroNameElement.getDefinition(context.translationUnitLanguage));
    }

    private static MacroDefinition getLanguageQueryMacro(CompilerDefinedMacroNames macro, ELanguage queriedLanguage, CPreprocessor.FilePreprocessorContext context) {
        ELanguage actualLanguage = context.translationUnitLanguage;
        String expansion = queriedLanguage == actualLanguage ? "1" : "0";
        return MacroDefinition.parseMacroDefinition(macro.macroName + " " + expansion, CPreprocessingUtils.LOCATION_FOR_INTERNAL_DEFAULT_DEFINES, actualLanguage);
    }
}

