/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.typetracker.abap;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.typetracker.TypeInfoExtractorBase;
import eu.cqse.check.framework.typetracker.TypedVariable;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;

public class AbapTypeInfoExtractor
extends TypeInfoExtractorBase {
    public static final String DYNAMIC_TYPE_MARKER = "dynamicType";
    public static final String STRUCTURED_DATATYPE = "Structured Datatype";
    public static final Set<String> VARIABLE_DECLARATION_SUBTYPES = CollectionUtils.asHashSet((Object[])new String[]{"class-data", "constants", "data", "field-symbols", "parameters", "statics"});
    private static final ETokenType[] LOCAL_TABLE_DECLARATION = new ETokenType[]{ETokenType.INTO, ETokenType.TABLE, ETokenType.IDENTIFIER, ETokenType.LPAREN, ETokenType.IDENTIFIER, ETokenType.RPAREN};
    private List<ShallowEntity> rootEntities;

    public AbapTypeInfoExtractor(List<ShallowEntity> rootEntities) {
        this.rootEntities = rootEntities;
    }

    @Override
    public List<TypedVariable> extractFromStatement(ShallowEntity statementEntity) {
        if (VARIABLE_DECLARATION_SUBTYPES.contains(statementEntity.getSubtype())) {
            return AbapTypeInfoExtractor.extractFromVariableDeclarationEntity(statementEntity);
        }
        if ("single select".equals(statementEntity.getSubtype()) && TokenStreamUtils.containsSequence((List<IToken>)statementEntity.ownStartTokens(), (ITokenMatcher[])LOCAL_TABLE_DECLARATION)) {
            return AbapTypeInfoExtractor.extractFromLocalTableDeclaration(statementEntity);
        }
        return super.extractFromStatement(statementEntity);
    }

    private static List<TypedVariable> extractFromLocalTableDeclaration(ShallowEntity statementEntity) {
        ArrayList<TypedVariable> extractedVariables = new ArrayList<TypedVariable>();
        UnmodifiableList tokens = statementEntity.ownStartTokens();
        List<Integer> startIndices = TokenStreamUtils.allStartingIndicesOfTypeSequence((List<IToken>)tokens, 0, tokens.size(), LOCAL_TABLE_DECLARATION);
        for (Integer startIndex : startIndices) {
            if (!"@DATA".equalsIgnoreCase(((IToken)tokens.get(startIndex + 2)).getText())) continue;
            String tableName = LanguageFeatureParser.ABAP.normalizeVariable(((IToken)tokens.get(startIndex + 4)).getText());
            extractedVariables.add(new TypedVariable(tableName, "TABLE", (List<IToken>)CollectionUtils.emptyList(), statementEntity));
        }
        return extractedVariables;
    }

    @Override
    public List<TypedVariable> extractFromAttribute(ShallowEntity attributeEntity) {
        if (VARIABLE_DECLARATION_SUBTYPES.contains(attributeEntity.getSubtype())) {
            return AbapTypeInfoExtractor.extractFromVariableDeclarationEntity(attributeEntity);
        }
        if (attributeEntity.getSubtype().equals("select-options")) {
            return AbapTypeInfoExtractor.extractFromSelectOptionsEntity(attributeEntity);
        }
        return super.extractFromAttribute(attributeEntity);
    }

    @Override
    public List<TypedVariable> extractFromMethod(ShallowEntity entity) {
        switch (entity.getSubtype()) {
            case "form": 
            case "function": {
                return AbapTypeInfoExtractor.extractFromForm(entity, (List<IToken>)entity.ownStartTokens());
            }
            case "method declaration": {
                return AbapTypeInfoExtractor.extractFromForm(entity, (List<IToken>)entity.includedTokens());
            }
            case "method implementation": {
                return this.extractFromMethodImplementation(entity);
            }
        }
        return super.extractFromMethod(entity);
    }

    private List<TypedVariable> extractFromMethodImplementation(ShallowEntity methodEntity) {
        if (this.rootEntities == null) {
            return CollectionUtils.emptyList();
        }
        List<IToken> declaration = LanguageFeatureParser.ABAP.getDeclarationTokensForMethod(this.rootEntities, methodEntity);
        if (declaration == null) {
            return CollectionUtils.emptyList();
        }
        return AbapTypeInfoExtractor.extractFromForm(methodEntity, declaration);
    }

    private static List<TypedVariable> extractFromForm(ShallowEntity entity, List<IToken> formTokens) {
        return LanguageFeatureParser.ABAP.getTypeInfoForMethodParameters(entity, formTokens.subList(2, formTokens.size()));
    }

    private static List<TypedVariable> extractFromVariableDeclarationEntity(ShallowEntity entity) {
        String typeName;
        String variableName;
        UnmodifiableList tokens = entity.ownStartTokens();
        if (tokens.size() <= 1) {
            return Collections.emptyList();
        }
        if (TokenStreamUtils.hasTokenTypeSequence((List<IToken>)tokens, 1, ETokenType.BEGIN, ETokenType.OF)) {
            variableName = ((IToken)tokens.get(3)).getText();
            typeName = STRUCTURED_DATATYPE;
        } else if (TokenStreamUtils.hasTokenTypeSequence((List<IToken>)tokens, 0, ETokenType.DATA, ETokenType.LPAREN, ETokenType.IDENTIFIER, ETokenType.RPAREN, ETokenType.EQ)) {
            variableName = ((IToken)tokens.get(2)).getText();
            typeName = DYNAMIC_TYPE_MARKER;
        } else if (TokenStreamUtils.hasTokenTypeSequence((List<IToken>)tokens, 1, ETokenType.LT, ETokenType.IDENTIFIER, ETokenType.GT)) {
            variableName = TokenStreamTextUtils.concatTokenTexts(tokens.subList(1, 4));
            int startOffsetOfType = 4;
            typeName = (String)LanguageFeatureParser.ABAP.getNextTypeName((List<IToken>)tokens, startOffsetOfType).getFirst();
        } else {
            variableName = ((IToken)tokens.get(1)).getText();
            int startOffsetOfType = 2;
            typeName = (String)LanguageFeatureParser.ABAP.getNextTypeName((List<IToken>)tokens, startOffsetOfType).getFirst();
        }
        return Collections.singletonList(new TypedVariable(LanguageFeatureParser.ABAP.normalizeVariable(variableName), typeName, (List<IToken>)CollectionUtils.emptyList(), entity));
    }

    public static List<TypedVariable> extractFromVariableDeclarationLikeEntity(ShallowEntity entity) {
        UnmodifiableList tokens = entity.ownStartTokens();
        if (tokens.size() <= 1) {
            return Collections.emptyList();
        }
        if (TokenStreamUtils.hasTokenTypeSequence((List<IToken>)tokens, 1, ETokenType.BEGIN, ETokenType.OF)) {
            String variableName = ((IToken)tokens.get(3)).getText();
            return Collections.singletonList(new TypedVariable(LanguageFeatureParser.ABAP.normalizeVariable(variableName), STRUCTURED_DATATYPE, (List<IToken>)CollectionUtils.emptyList(), entity));
        }
        String variableName = ((IToken)tokens.get(1)).getText();
        return Collections.singletonList(new TypedVariable(LanguageFeatureParser.ABAP.normalizeVariable(variableName), null, (List<IToken>)CollectionUtils.emptyList(), entity));
    }

    private static List<TypedVariable> extractFromSelectOptionsEntity(ShallowEntity entity) {
        UnmodifiableList tokens = entity.ownStartTokens();
        String variableName = LanguageFeatureParser.ABAP.normalizeVariable(((IToken)tokens.get(1)).getText());
        return Collections.singletonList(new TypedVariable(variableName, "select-options", (List<IToken>)CollectionUtils.emptyList(), entity));
    }
}

