/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.util;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.preprocessor.c.CPreprocessingUtils;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.PreprocessedTokenStreamUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.languages.cpp.CppShallowParser;
import eu.cqse.check.framework.util.CLikeLanguageFeatureParserBase;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import eu.cqse.check.framework.util.variable.CLikeVariableUseExtractor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;

public class CppLanguageFeatureParser
extends CLikeLanguageFeatureParserBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ITokenMatcher ADDITIONAL_TYPE_TOKENS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.AUTO});
    private static final ITokenMatcher PRIMITIVE_TYPE_TOKENS = CppShallowParser.TYPES_TOKENS;
    private static final ITokenMatcher VALID_IDENTIFIERS_CPP = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.OPERATOR, ETokenType.INITONLY});
    private static final ITokenMatcher VALID_IDENTIFIERS_C = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.ASM, ETokenType.EXPLICIT, ETokenType.OPERATOR, ETokenType.THIS, ETokenType.DELETE, ETokenType.TYPEID, ETokenType.DYNAMIC_CAST, ETokenType.NEW, ETokenType.TEMPLATE, ETokenType.INLINE, ETokenType.MUTABLE, ETokenType.TYPENAME, ETokenType.NAMESPACE, ETokenType.STATIC_CAST, ETokenType.FRIEND, ETokenType.PUBLIC, ETokenType.PROTECTED, ETokenType.USING, ETokenType.REINTERPRET_CAST, ETokenType.FALSE, ETokenType.PRIVATE, ETokenType.THROW, ETokenType.TRUE, ETokenType.VIRTUAL, ETokenType.BOOL, ETokenType.CATCH, ETokenType.CLASS, ETokenType.CONST_CAST, ETokenType.TRY, ETokenType.WCHAR_T, ETokenType.IDENTIFIER, ETokenType.OVERRIDE, ETokenType.WHERE, ETokenType.CONCEPT, ETokenType.FINAL});
    private static final Set<ETokenType> FUNCTION_SPECIFIER_TOKENS = EnumSet.of(ETokenType.TYPEDEF, new ETokenType[]{ETokenType.INLINE, ETokenType.VIRTUAL, ETokenType.EXPLICIT, ETokenType.FRIEND, ETokenType.CONSTEXPR, ETokenType.CONSTINIT, ETokenType.CONSTEVAL, ETokenType.REGISTER, ETokenType.STATIC, ETokenType.THREAD_LOCAL, ETokenType.EXTERN, ETokenType.MUTABLE});
    private static final TokenPattern TRAILING_RETURN_TYPE_PATTERN = new TokenPattern().beginningOfStream().repeated(new TokenPattern().sequence(ETokenType.LBRACK, ETokenType.LBRACK).skipTo(ETokenType.RBRACK).sequence(ETokenType.RBRACK)).repeated(FUNCTION_SPECIFIER_TOKENS).sequence(ETokenType.AUTO).skipTo(ETokenType.LPAREN).skipNested(ETokenType.LPAREN, ETokenType.RPAREN, true).skipTo(ETokenType.RPAREN).skipTo(ETokenType.POINTERTO).group(0).alternative(new TokenPattern().skipTo(ETokenType.SEMICOLON), new TokenPattern().skipTo(ETokenType.LBRACE));
    private static final TokenPattern POINTER_DECLARATION_PATTERN = new TokenPattern().alternative(PRIMITIVE_TYPE_TOKENS, ETokenType.IDENTIFIER).skipTo(ETokenType.MULT).optional(ETokenType.LPAREN).skipTo(ETokenType.IDENTIFIER);
    private static final Pattern VALID_IDENTIFIER_PATTERN = Pattern.compile("[\\p{Alpha}_]\\w*");
    private static final String NAME_AUTO = "auto";
    private static final Set<ETokenType> NON_GENERIC_PREFIX_TOKENS = EnumSet.of(ETokenType.LT, ETokenType.OPERATOR);
    private static final Set<String> UNCONDITIONAL_SWITCH_EXIT_STATEMENT_NAMES = CollectionUtils.asHashSet((Object[])new String[]{"break", "return", "goto", "continue", "throw", "__builtin_trap", "exit"});
    private static final Set<String> UNCONDITIONAL_NESTED_SWITCH_EXIT_STATEMENT_NAMES = CollectionUtils.asHashSet((Object[])new String[]{"return", "throw", "__builtin_trap"});
    private static final int ALIAS_EXPANSION_SIZE_LIMIT = 1000;
    private static final Set<String> STD_LIB_PROGRAM_TERMINATION_FUNCTIONS = CollectionUtils.asHashSet((Object[])new String[]{"abort", "terminate", "exit", "quick_exit", "_Exit"});
    private static final ETokenType ADDRESS_OF_OPERATOR = ETokenType.AND;
    private static final TokenPattern EXPANDED_ASSERT_MACRO_MATCHER = new TokenPattern().beginningOfStream().sequence(ETokenType.DO, ETokenType.LBRACE, ETokenType.IF, ETokenType.LPAREN, ETokenType.NOT, ETokenType.LPAREN, TokenPattern.text("false"), ETokenType.RPAREN, ETokenType.RPAREN, ETokenType.LBRACE, TokenPattern.text("exit"), ETokenType.LPAREN, ETokenType.INTEGER_LITERAL, ETokenType.RPAREN, ETokenType.SEMICOLON, ETokenType.RBRACE, ETokenType.RBRACE, ETokenType.WHILE, ETokenType.LPAREN, ETokenType.INTEGER_LITERAL, ETokenType.RPAREN, ETokenType.SEMICOLON).endOfStream();

    private CppLanguageFeatureParser(ITokenMatcher validIdentifiers, ELanguage language) {
        super(language, validIdentifiers, PRIMITIVE_TYPE_TOKENS, ADDITIONAL_TYPE_TOKENS, ETokenType.SCOPE, "::", new CLikeVariableUseExtractor(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.DOT, ETokenType.POINTERTO, ETokenType.SCOPE}), validIdentifiers), ETokenType.COMMA);
    }

    static CppLanguageFeatureParser createParser(boolean isCpp) {
        if (isCpp) {
            return new CppLanguageFeatureParser(VALID_IDENTIFIERS_CPP, ELanguage.CPP);
        }
        return new CppLanguageFeatureParser(VALID_IDENTIFIERS_C, ELanguage.C);
    }

    public Pattern getValidIdentifierPattern() {
        return VALID_IDENTIFIER_PATTERN;
    }

    public boolean isCpp11DeletedFunctionOrConstructor(ShallowEntity entity) {
        return CollectionUtils.asHashSet((Object[])new String[]{"constructor declaration", "function declaration", "operator declaration"}).contains(entity.getSubtype()) && TokenStreamUtils.endsWith((List<IToken>)entity.ownStartTokens(), ETokenType.EQ, ETokenType.DELETE, ETokenType.SEMICOLON);
    }

    @Override
    public boolean isImport(ShallowEntity entity) {
        return entity.getType() == EShallowEntityType.META && entity.getSubtype().equals("using namespace");
    }

    @Override
    public String getImportName(ShallowEntity entity) {
        CCSMAssert.isTrue((boolean)this.isImport(entity), (String)"entity.getType() must be equal to EShallowEntityType.META and entity.getSubtype() must be equal to SubTypeNames.USING_NAMESPACE");
        return entity.getName();
    }

    @Override
    public boolean hasVoidReturnType(ShallowEntity method) {
        CppLanguageFeatureParser.assertMethod(method);
        return "void".equals(this.getReturnType(method));
    }

    @Override
    public String getReturnType(ShallowEntity method) {
        CppLanguageFeatureParser.assertMethod(method);
        String returnType = super.getReturnType(method);
        if (returnType != null && !returnType.equals(NAME_AUTO)) {
            return returnType;
        }
        return this.getReturnTypeFromTrailingReturnSyntax(method);
    }

    private String getReturnTypeFromTrailingReturnSyntax(ShallowEntity method) {
        int pointerToTokenIndex;
        List<IToken> possibleReturnTypeTokens;
        ETokenType typeOfTokenAfterLambdaArrow;
        UnmodifiableList methodTokens = method.ownStartTokens();
        TokenPatternMatch tokenPatternMatch = TRAILING_RETURN_TYPE_PATTERN.findFirstMatch((List<IToken>)methodTokens);
        if (tokenPatternMatch == null) {
            return null;
        }
        List<IToken> pointerToTokens = tokenPatternMatch.groupTokens(0);
        if (pointerToTokens.isEmpty()) {
            return null;
        }
        int lastTokenIndex = methodTokens.size() - 1;
        IToken lastToken = (IToken)methodTokens.get(lastTokenIndex);
        if (lastToken.getType() == ETokenType.RBRACE) {
            --lastTokenIndex;
        }
        if ((typeOfTokenAfterLambdaArrow = ((IToken)(possibleReturnTypeTokens = methodTokens.subList((pointerToTokenIndex = methodTokens.indexOf(pointerToTokens.getFirst())) + 1, lastTokenIndex)).getFirst()).getType()) == ETokenType.DECLTYPE) {
            return this.extractDecltypeFunctionReturnType(method, possibleReturnTypeTokens);
        }
        if (typeOfTokenAfterLambdaArrow == ETokenType.VOID) {
            return possibleReturnTypeTokens.getFirst().getText();
        }
        String returnType = TokenStreamTextUtils.concatTokenTexts(possibleReturnTypeTokens);
        if (NAME_AUTO.equals(returnType)) {
            return null;
        }
        return TokenStreamTextUtils.concatTokenTexts(possibleReturnTypeTokens);
    }

    private String extractDecltypeFunctionReturnType(ShallowEntity entity, List<IToken> tokens) {
        int openingParenthesisIndex = TokenStreamUtils.firstTokenMatching(tokens, (ITokenMatcher)ETokenType.LPAREN);
        int closingParenthesisIndex = TokenStreamUtils.findMatchingClosingToken(tokens, openingParenthesisIndex + 1, ETokenType.LPAREN, ETokenType.RPAREN);
        if (openingParenthesisIndex == -1 || closingParenthesisIndex == -1) {
            return null;
        }
        List<IToken> methodCallTokens = tokens.subList(openingParenthesisIndex, closingParenthesisIndex);
        if (!CppLanguageFeatureParser.isMethodCall(methodCallTokens, 1)) {
            return null;
        }
        int methodNameIndex = TokenStreamUtils.firstTokenMatching(methodCallTokens, (ITokenMatcher)ETokenType.IDENTIFIER);
        String methodName = methodCallTokens.get(methodNameIndex).getText();
        ShallowEntity parentEntity = entity.getParent();
        List allSiblingMethods = parentEntity.getChildrenOfType(EShallowEntityType.METHOD);
        allSiblingMethods.addAll(CppLanguageFeatureParser.getAttributeLambdaExpressionEntities(entity));
        Optional<ShallowEntity> matchingMethodEntity = allSiblingMethods.stream().filter(e -> methodName.equals(e.getName())).findFirst();
        if (matchingMethodEntity.isEmpty()) {
            return null;
        }
        String matchingMethodReturnType = super.getReturnType(entity);
        if (matchingMethodReturnType.equals(NAME_AUTO) && !CppLanguageFeatureParser.hasReturnStatement(matchingMethodEntity.get())) {
            return "void";
        }
        return matchingMethodReturnType;
    }

    private static List<ShallowEntity> getAttributeLambdaExpressionEntities(ShallowEntity entity) {
        ArrayList<ShallowEntity> result = new ArrayList<ShallowEntity>();
        if (entity.getParent() != null) {
            List attributes = entity.getParent().getChildrenOfType(EShallowEntityType.ATTRIBUTE);
            for (ShallowEntity attribute : attributes) {
                if (!attribute.hasChildren()) continue;
                UnmodifiableList children = attribute.getChildren();
                ShallowEntity firstChild = (ShallowEntity)children.getFirst();
                if (children.size() > 1 || firstChild.getType() != EShallowEntityType.METHOD || !"lambda expression".equals(firstChild.getSubtype()) && !"block expression".equals(firstChild.getSubtype())) continue;
                result.add(attribute);
            }
        }
        return result;
    }

    private static boolean hasReturnStatement(ShallowEntity entity) {
        if (!entity.hasChildren()) {
            return false;
        }
        ShallowEntity entityBeingAnalyzed = entity;
        ShallowEntity firstChild = (ShallowEntity)entityBeingAnalyzed.getChildren().getFirst();
        if (entityBeingAnalyzed.getType() == EShallowEntityType.ATTRIBUTE && ("lambda expression".equalsIgnoreCase(firstChild.getSubtype()) || "block expression".equalsIgnoreCase(firstChild.getSubtype()))) {
            entityBeingAnalyzed = firstChild;
        }
        return entityBeingAnalyzed.getChildrenOfType(EShallowEntityType.STATEMENT).stream().anyMatch(e -> "simple statement".equals(e.getSubtype()) && ETokenType.RETURN.toString().equalsIgnoreCase(e.getName()));
    }

    private static boolean isMethodCall(List<IToken> tokens, int startIndex) {
        int methodCallIndex = TokenStreamUtils.firstTokenOfTypeSequence(tokens, startIndex, ETokenType.IDENTIFIER, ETokenType.LPAREN);
        if (methodCallIndex == -1) {
            return false;
        }
        int nextTokenIndexAfterParenthesis = methodCallIndex + 2;
        if (nextTokenIndexAfterParenthesis >= tokens.size()) {
            return false;
        }
        int closingParenthesisIndex = TokenStreamUtils.findMatchingClosingToken(tokens, nextTokenIndexAfterParenthesis, ETokenType.LPAREN, ETokenType.RPAREN);
        return closingParenthesisIndex != -1;
    }

    private static void assertMethod(ShallowEntity entity) {
        CCSMAssert.isTrue((entity.getType() == EShallowEntityType.METHOD ? 1 : 0) != 0, (String)"Entity is no method");
    }

    public boolean isVirtual(ShallowEntity entity) {
        return TokenStreamUtils.contains((List<IToken>)entity.ownStartTokens(), ETokenType.VIRTUAL);
    }

    public boolean isNoreturn(ShallowEntity entity) {
        return TokenStreamUtils.contains((List<IToken>)entity.ownStartTokens(), ETokenType.NORETURN);
    }

    public boolean isConstant(ShallowEntity entity) {
        UnmodifiableList tokens = entity.ownStartTokens();
        return TokenStreamUtils.containsAny((List<IToken>)tokens, ETokenType.CONST, ETokenType.CONSTEXPR) && !this.isPointerDeclaration(entity);
    }

    private boolean isPointerDeclaration(ShallowEntity entity) {
        Object tokens = entity.ownStartTokens();
        int assignmentOperatorIndex = TokenStreamUtils.firstTokenMatching((List<IToken>)tokens, (ITokenMatcher)ETokenType.EQ);
        if (assignmentOperatorIndex != -1) {
            tokens = tokens.subList(0, assignmentOperatorIndex);
        }
        return POINTER_DECLARATION_PATTERN.findFirstMatch((List<IToken>)tokens) != null;
    }

    public boolean containsAddressOfUsage(List<IToken> tokens) {
        List<Integer> addressOperatorIndexes = TokenStreamUtils.findAll(tokens, (ITokenMatcher)ADDRESS_OF_OPERATOR);
        return addressOperatorIndexes.stream().filter(index -> index >= 0).filter(index -> ((IToken)tokens.get(index + 1)).getType().isIdentifier()).filter(index -> ((IToken)tokens.get(index + 2)).getType() != ETokenType.EQ).anyMatch(index -> {
            if (index == 0) {
                return true;
            }
            ETokenType predecessorType = ((IToken)tokens.get(index - 1)).getType();
            return predecessorType != ETokenType.RBRACE && predecessorType != ETokenType.IDENTIFIER;
        });
    }

    public Set<String> getPlainPointerDereferences(List<IToken> tokens) {
        HashSet<String> dereferencedVariables = new HashSet<String>();
        this.computePlainPointerDereference(tokens, (variableName, offset) -> dereferencedVariables.add((String)variableName));
        return dereferencedVariables;
    }

    public void computePlainPointerDereference(List<IToken> tokens, BiConsumer<String, Integer> dereferenceVariableConsumer) {
        int firstEqTokenIndex = TokenStreamUtils.firstTokenMatching(tokens, (ITokenMatcher)ETokenType.EQ);
        int firstLparenTokenIndex = TokenStreamUtils.firstTokenMatching(tokens, (ITokenMatcher)ETokenType.LPAREN);
        for (int starIndex : TokenStreamUtils.allStartingIndicesOfTypeSequence(tokens, 0, tokens.size(), ETokenType.MULT, ETokenType.IDENTIFIER)) {
            if (starIndex != 0 && (firstEqTokenIndex == -1 || starIndex <= firstEqTokenIndex) && (firstLparenTokenIndex == -1 || starIndex <= firstLparenTokenIndex) || starIndex > 0 && CppLanguageFeatureParser.isLikelyMultiplicationPrefix(tokens.get(starIndex - 1)) || starIndex > 0 && tokens.get(starIndex - 1).getType() == ETokenType.NOT || starIndex > 0 && TokenStreamUtils.hasTokenTypeSequence(tokens, starIndex, ETokenType.MULT, ETokenType.IDENTIFIER, ETokenType.DOT, ETokenType.IDENTIFIER)) continue;
            IToken dereferencedVariableToken = tokens.get(starIndex + 1);
            String variableName = dereferencedVariableToken.getText();
            int offset = dereferencedVariableToken.getOffset();
            dereferenceVariableConsumer.accept(variableName, offset);
        }
    }

    private static boolean isLikelyMultiplicationPrefix(IToken token) {
        ETokenType type = token.getType();
        return type == ETokenType.RBRACK || type == ETokenType.RPAREN || EnumSet.of(ETokenType.ETokenClass.IDENTIFIER, ETokenType.ETokenClass.LITERAL).contains(type.getTokenClass());
    }

    public boolean containsPointerOperator(List<IToken> tokens) {
        return !this.getPlainPointerDereferences(tokens).isEmpty();
    }

    public String getVisibility(ShallowEntity entity, ShallowEntity childEntity, boolean isStruct) {
        String currentVisibility = "private";
        if (isStruct) {
            currentVisibility = "public";
        }
        for (ShallowEntity child : entity.getChildren()) {
            if (child.getType() == EShallowEntityType.META) {
                currentVisibility = child.getSubtype();
                continue;
            }
            if (child != childEntity) continue;
            break;
        }
        return currentVisibility;
    }

    public boolean isCppMethod(ShallowEntity entity) {
        CppLanguageFeatureParser.assertMethod(entity);
        if (TokenStreamUtils.contains((List<IToken>)entity.ownStartTokens(), ETokenType.SCOPE)) {
            return true;
        }
        return CppLanguageFeatureParser.isInClassOrStruct(entity);
    }

    private static boolean isInClassOrStruct(ShallowEntity entity) {
        ShallowEntity parent = entity.getParent();
        if (parent == null) {
            return false;
        }
        return parent.getSubtype().equals("class") || parent.getSubtype().equals("struct");
    }

    public boolean isTopLevelClass(ShallowEntity entity) {
        ShallowEntity parent = entity.getParent();
        boolean isTopLevel = parent == null || parent.getType() == EShallowEntityType.MODULE;
        boolean isClass = entity.getType() == EShallowEntityType.TYPE && "class".equals(entity.getSubtype());
        return isTopLevel && isClass;
    }

    @Override
    protected int reverseSkipToDeclaredVariableOrMethodName(List<IToken> tokens) {
        int endIndex = this.reverseSkipPastVariableAssignment(tokens);
        int operatorIndex = TokenStreamUtils.firstTokenMatching(tokens, 0, endIndex, (ITokenMatcher)ETokenType.OPERATOR);
        if (operatorIndex != -1) {
            endIndex = operatorIndex + 1;
        }
        if ((endIndex = CppLanguageFeatureParser.skipTrailingParenthesisLikeConstruct(tokens, endIndex, ETokenType.LBRACK, ETokenType.RBRACK)) == -1) {
            return endIndex;
        }
        if ((endIndex = CppLanguageFeatureParser.skipTrailingParenthesisLikeConstruct(tokens, endIndex, ETokenType.LT, ETokenType.GT)) == -1) {
            return endIndex;
        }
        if ((endIndex = TokenStreamUtils.lastTokenMatching(tokens, 0, endIndex, this.validIdentifierMatcher())) == -1) {
            return endIndex;
        }
        return this.reverseSkipScope(tokens, endIndex);
    }

    private int reverseSkipScope(List<IToken> tokens, int endIndex) {
        while (endIndex > 1 && tokens.get(endIndex - 1).getType() == ETokenType.SCOPE) {
            endIndex = tokens.get(endIndex - 2).getType() == ETokenType.GT ? this.skipGenericReverse(tokens, endIndex - 2) : --endIndex;
            if (endIndex <= 0 || !this.isValidIdentifier(tokens.get(endIndex - 1))) {
                return -1;
            }
            --endIndex;
        }
        return endIndex;
    }

    @Override
    protected int reverseSkipPastVariableAssignment(List<IToken> tokens) {
        int endIndex = tokens.size();
        if (TokenStreamUtils.endsWith(tokens, ETokenType.SEMICOLON)) {
            --endIndex;
        }
        if ((endIndex = CppLanguageFeatureParser.skipTrailingParenthesisLikeConstruct(tokens, endIndex, ETokenType.LBRACE, ETokenType.RBRACE)) != -1) {
            endIndex = super.reverseSkipPastVariableAssignment(tokens.subList(0, endIndex));
        }
        return endIndex;
    }

    @Override
    public int skipGeneric(List<IToken> tokens, int startIndex) {
        int angleDepth = 1;
        int parenDepth = 0;
        block6: for (int i = startIndex + 1; i < tokens.size(); ++i) {
            switch (tokens.get(i).getType()) {
                case LPAREN: {
                    ++parenDepth;
                    continue block6;
                }
                case RPAREN: {
                    --parenDepth;
                    continue block6;
                }
                case LT: {
                    if (parenDepth > 0) continue block6;
                    ++angleDepth;
                    continue block6;
                }
                case GT: {
                    if (parenDepth > 0 || --angleDepth != 0) continue block6;
                    return i;
                }
            }
        }
        return -1;
    }

    @Override
    public int skipGenericReverse(List<IToken> tokens, int startIndex) {
        int angleDepth = 1;
        int parenDepth = 0;
        block6: for (int i = startIndex - 1; i >= 0; --i) {
            switch (tokens.get(i).getType()) {
                case LPAREN: {
                    --parenDepth;
                    continue block6;
                }
                case RPAREN: {
                    ++parenDepth;
                    continue block6;
                }
                case LT: {
                    if (parenDepth > 0 || --angleDepth != 0) continue block6;
                    return i;
                }
                case GT: {
                    if (parenDepth > 0) continue block6;
                    ++angleDepth;
                    continue block6;
                }
            }
        }
        return -1;
    }

    private static int skipAttribute(List<IToken> tokens, int startIndex) {
        int firstRBrackIndex = TokenStreamUtils.firstTokenOfTypeSequence(tokens, startIndex, ETokenType.RBRACK, ETokenType.RBRACK);
        if (firstRBrackIndex == -1) {
            return -1;
        }
        return firstRBrackIndex + 1;
    }

    @Override
    protected int getMethodOpeningParenthesisIndex(List<IToken> methodTokens) {
        block5: for (int i = 0; i < methodTokens.size(); ++i) {
            switch (methodTokens.get(i).getType()) {
                case LT: {
                    if (i != 0 && NON_GENERIC_PREFIX_TOKENS.contains(methodTokens.get(i - 1).getType()) || (i = this.skipGeneric(methodTokens, i)) >= 0) continue block5;
                    return -1;
                }
                case LBRACK: {
                    if (i + 1 >= methodTokens.size() || methodTokens.get(i + 1).getType() != ETokenType.LBRACK) continue block5;
                    i = CppLanguageFeatureParser.skipAttribute(methodTokens, i);
                    continue block5;
                }
                case LPAREN: {
                    return i;
                }
            }
        }
        return -1;
    }

    public boolean isMethodDeclaration(ShallowEntity entity) {
        if (entity.getType() != EShallowEntityType.METHOD || entity.getSubtype() == null) {
            return false;
        }
        String subtype = entity.getSubtype();
        return "method declaration".equals(subtype) || "operator declaration".equals(subtype) || "function declaration".equals(subtype) || "function pointer declaration".equals(subtype) || "destructor declaration".equals(subtype) || "constructor declaration".equals(subtype);
    }

    public boolean isCaseOrDefaultExitStatement(ShallowEntity entity, Set<String> additionalExitNames, boolean isNestedSwitch) {
        if (EXPANDED_ASSERT_MACRO_MATCHER.matchFully((List<IToken>)entity.includedTokens()) != null) {
            return true;
        }
        if (entity.getType() == EShallowEntityType.STATEMENT && entity.getSubtype().equals("simple statement")) {
            if (CppLanguageFeatureParser.getUnconditionalSwitchExitStatementNames(isNestedSwitch).contains(entity.getName()) || additionalExitNames.contains(entity.getName())) {
                return true;
            }
            return TokenStreamUtils.hasTokenTypeSequence((List<IToken>)entity.ownStartTokens(), 0, ETokenType.IDENTIFIER, ETokenType.SCOPE, ETokenType.IDENTIFIER) && "std".equals(((IToken)entity.ownStartTokens().get(0)).getText()) && STD_LIB_PROGRAM_TERMINATION_FUNCTIONS.contains(((IToken)entity.ownStartTokens().get(2)).getText());
        }
        return false;
    }

    private static Set<String> getUnconditionalSwitchExitStatementNames(boolean isNestedSwitch) {
        if (isNestedSwitch) {
            return UNCONDITIONAL_NESTED_SWITCH_EXIT_STATEMENT_NAMES;
        }
        return UNCONDITIONAL_SWITCH_EXIT_STATEMENT_NAMES;
    }

    public boolean isUnconditionalSwitchExit(ShallowEntity lastEntity, Set<String> additionalExitNames, boolean isNestedSwitch) {
        if (lastEntity.getSubtype().equals("else")) {
            return this.isUnconditionalSwitchExitGivenElseAsLastEntity(lastEntity, additionalExitNames, isNestedSwitch);
        }
        return this.isCaseOrDefaultExitStatement(lastEntity, additionalExitNames, isNestedSwitch);
    }

    private boolean isUnconditionalSwitchExitGivenElseAsLastEntity(ShallowEntity lastEntity, Set<String> additionalExitNames, boolean isNestedSwitch) {
        UnmodifiableList siblings = lastEntity.getParent().getChildren();
        int index = siblings.indexOf(lastEntity);
        if (!this.isUnconditionalSwitchExit((List<ShallowEntity>)lastEntity.getChildren(), additionalExitNames, isNestedSwitch)) {
            return false;
        }
        --index;
        while (index > 0 && "else if".equals(((ShallowEntity)siblings.get(index)).getSubtype())) {
            if (!this.isUnconditionalSwitchExit((List<ShallowEntity>)((ShallowEntity)siblings.get(index)).getChildren(), additionalExitNames, isNestedSwitch)) {
                return false;
            }
            --index;
        }
        return this.isUnconditionalSwitchExit((List<ShallowEntity>)((ShallowEntity)siblings.get(index)).getChildren(), additionalExitNames, isNestedSwitch);
    }

    private boolean isUnconditionalSwitchExit(List<ShallowEntity> entities, Set<String> additionalExitNames, boolean isNestedSwitch) {
        return !entities.isEmpty() && this.isUnconditionalSwitchExit(entities.getLast(), additionalExitNames, isNestedSwitch);
    }

    public Map<String, List<IToken>> getAliasMapping(List<IToken> tokens) {
        HashMap<String, List<IToken>> aliases = new HashMap<String, List<IToken>>();
        for (int i = 0; i < tokens.size(); ++i) {
            int semicolonIndex;
            IToken current = tokens.get(i);
            ETokenType currentType = current.getType();
            if (currentType != ETokenType.TYPEDEF && currentType != ETokenType.USING || (semicolonIndex = TokenStreamUtils.findFirstTopLevel(tokens, i + 2, (ITokenMatcher)ETokenType.SEMICOLON, Collections.singletonList(ETokenType.LBRACE), Collections.singletonList(ETokenType.RBRACE))) == -1) continue;
            List<IToken> tokenBuffer = tokens.subList(i + 1, semicolonIndex);
            i = semicolonIndex;
            if (currentType == ETokenType.TYPEDEF && CppLanguageFeatureParser.isTypedefUsedForAliasResolution(tokenBuffer)) {
                IToken lastToken = tokenBuffer.getLast();
                this.insertAlias(lastToken.getText(), tokenBuffer.subList(0, tokenBuffer.size() - 1), aliases);
                continue;
            }
            if (currentType != ETokenType.USING || !TokenStreamUtils.startsWith(tokenBuffer, ETokenType.IDENTIFIER, ETokenType.EQ)) continue;
            this.insertAlias(tokenBuffer.getFirst().getText(), tokenBuffer.subList(2, tokenBuffer.size()), aliases);
        }
        return aliases;
    }

    private static boolean isTypedefUsedForAliasResolution(List<IToken> tokens) {
        return !TokenStreamUtils.containsAny(tokens, ETokenType.LBRACE, ETokenType.LPAREN);
    }

    private void insertAlias(String name, List<IToken> tokens, Map<String, List<IToken>> aliases) {
        List<IToken> resolved = this.resolveAliases(tokens, aliases);
        if (resolved.size() > 1000) {
            LOGGER.warn("Skipping alias for " + name + " as resolved replacement would exceed 1000 tokens in file " + Objects.requireNonNull((IToken)CollectionUtils.getAny(tokens)).getOriginId());
        } else {
            aliases.put(name, resolved);
        }
    }

    public List<IToken> resolveAliases(List<IToken> tokens, Map<String, List<IToken>> aliasMapping) {
        ArrayList<IToken> resolved = new ArrayList<IToken>();
        for (IToken token : tokens) {
            if (token.getType() == ETokenType.IDENTIFIER && aliasMapping.containsKey(token.getText())) {
                resolved.addAll((Collection<IToken>)aliasMapping.get(token.getText()));
                continue;
            }
            resolved.add(token);
        }
        return resolved;
    }

    public boolean containsMacroExpandedContent(ShallowEntity entity) {
        return CppLanguageFeatureParser.containsMacroExpandedContent((List<IToken>)entity.includedTokens());
    }

    private static boolean containsMacroExpandedContent(List<IToken> tokens) {
        if (tokens.isEmpty() || !CPreprocessingUtils.C_PREPROCESSOR_LANGUAGES.contains(tokens.getFirst().getLanguage())) {
            return false;
        }
        return PreprocessedTokenStreamUtils.containsMacroExpandedContent(tokens);
    }

    public boolean entityHasInternalLinkage(ShallowEntity entity) {
        ShallowEntity previousEntity;
        int index;
        ELanguage language = TokenStreamUtils.getLanguage(entity.getAllTokensOfFile());
        EnumSet<ETokenType> targetTokenTypes = language == ELanguage.C ? EnumSet.of(ETokenType.STATIC) : EnumSet.of(ETokenType.STATIC, ETokenType.CONST);
        if (entity.getParent() != null && (index = entity.getParent().getChildren().indexOf((Object)entity)) > 0 && (previousEntity = (ShallowEntity)entity.getParent().getChildren().get(index - 1)).getType() == EShallowEntityType.TYPE && "<anonymous>".equals(previousEntity.getName())) {
            return TokenStreamUtils.containsAny((List<IToken>)previousEntity.ownStartTokens(), targetTokenTypes);
        }
        UnmodifiableList tokens = entity.ownStartTokens();
        int firstIdentifierIndex = TokenStreamUtils.firstTokenMatching((List<IToken>)tokens, (ITokenMatcher)ETokenType.IDENTIFIER);
        if (firstIdentifierIndex == -1) {
            return false;
        }
        return TokenStreamUtils.containsAny((List<IToken>)tokens, 0, firstIdentifierIndex, targetTokenTypes);
    }

    public boolean hasAutoReturnType(ShallowEntity method) {
        String returnType = super.getReturnType(method);
        return returnType != null && returnType.equals(NAME_AUTO) && !CppLanguageFeatureParser.hasTrailingReturnType(method);
    }

    private static boolean hasTrailingReturnType(ShallowEntity method) {
        UnmodifiableList methodTokens = method.ownStartTokens();
        TokenPatternMatch tokenPatternMatch = TRAILING_RETURN_TYPE_PATTERN.findFirstMatch((List<IToken>)methodTokens);
        return tokenPatternMatch != null && !tokenPatternMatch.groupTokens(0).isEmpty();
    }

    public boolean hasCoroutineKeywords(ShallowEntity method) {
        return TokenStreamUtils.containsAny((List<IToken>)method.includedTokens(), ETokenType.CO_YIELD, ETokenType.CO_AWAIT);
    }
}

