/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.util.variable;

import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.util.variable.IVariableUseFilter;
import java.util.EnumSet;
import java.util.List;

public class VariableWriteFilter
implements IVariableUseFilter {
    public static final VariableWriteFilter INSTANCE = new VariableWriteFilter();
    private static final EnumSet<ETokenType> PREDECESSOR_TOKEN_TYPES = EnumSet.of(ETokenType.PLUSPLUS, ETokenType.MINUSMINUS);
    private static final EnumSet<ETokenType> SUCCESSOR_TOKEN_TYPES = EnumSet.of(ETokenType.EQ, new ETokenType[]{ETokenType.PLUSPLUS, ETokenType.MINUSMINUS, ETokenType.PLUSEQ, ETokenType.MINUSEQ, ETokenType.MULTEQ, ETokenType.DIVEQ, ETokenType.ANDEQ, ETokenType.OREQ, ETokenType.XOREQ, ETokenType.MODEQ, ETokenType.LSHIFTEQ, ETokenType.RSHIFTEQ, ETokenType.URSHIFTEQ});

    @Override
    public boolean isFiltered(List<IToken> tokens, int index, boolean isField) {
        return VariableWriteFilter.hasSuffixOperator(tokens, index) || VariableWriteFilter.hasPrefixOperator(tokens, index) || VariableWriteFilter.hasPrefixOperatorWithFieldAccess(tokens, index, isField);
    }

    private static boolean hasSuffixOperator(List<IToken> tokens, int index) {
        return index < tokens.size() - 1 && SUCCESSOR_TOKEN_TYPES.contains(tokens.get(index + 1).getType());
    }

    private static boolean hasPrefixOperator(List<IToken> tokens, int index) {
        return index > 0 && PREDECESSOR_TOKEN_TYPES.contains(tokens.get(index - 1).getType());
    }

    private static boolean hasPrefixOperatorWithFieldAccess(List<IToken> tokens, int index, boolean isField) {
        return isField && index > 2 && PREDECESSOR_TOKEN_TYPES.contains(tokens.get(index - 3).getType());
    }
}

