/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cloud_smells.config;

import eu.cqse.check.cloud_smells.config.XmlAnyElementAttributeCheckHandlerBase;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.xml.XmlCheckBase;
import eu.cqse.check.xml.XmlCheckHandlerBase;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class XmlAnyElementAttributeRegexCheckBase
extends XmlCheckBase {
    private Pattern unwantedRegex;

    protected abstract Pattern getUnwantedRegex();

    public void initialize() throws CheckException {
        super.initialize();
        this.unwantedRegex = this.getUnwantedRegex();
    }

    private boolean shouldCreateFinding(String elementName, String localAttributeName, String attributeValue, MatchResult matchResult) {
        return !this.shouldIgnore(elementName, localAttributeName, attributeValue, matchResult);
    }

    protected boolean shouldIgnore(String elementName, String localAttributeName, String attributeValue, MatchResult matchResult) {
        return false;
    }

    @Override
    public XmlCheckHandlerBase getHandler() {
        return new XmlAnyElementAttributeCheckHandlerBase(){

            @Override
            protected void checkAttributeValue(String localAttributeName, String attributeValue) {
                Matcher attributeValueMatcher = XmlAnyElementAttributeRegexCheckBase.this.unwantedRegex.matcher(attributeValue);
                if (!attributeValueMatcher.find()) {
                    return;
                }
                MatchResult attributeMatchResult = attributeValueMatcher.toMatchResult();
                if (XmlAnyElementAttributeRegexCheckBase.this.shouldCreateFinding(this.getCurrentElementName(), localAttributeName, attributeValue, attributeMatchResult)) {
                    this.createFinding(XmlAnyElementAttributeRegexCheckBase.this.getFindingText(this.getCurrentElementName(), localAttributeName, attributeValue, attributeMatchResult));
                }
            }
        };
    }

    protected abstract String getFindingText(String var1, String var2, String var3, MatchResult var4);
}

