/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cs;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.List;

@Check(id="cqse-abstract-types-should-not-have-constructors", languages={ELanguage.CS}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class AbstractTypesShouldNotHaveConstructorsCheck
extends CheckImplementationBase {
    public void execute() throws CheckException {
        List rootEntities = this.context.getAbstractSyntaxTree(this.getCodeViewOption());
        List types = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)rootEntities, (EShallowEntityType)EShallowEntityType.TYPE);
        for (ShallowEntity type : types) {
            if (!TokenStreamUtils.contains((List)type.ownStartTokens(), (ETokenType)ETokenType.PUBLIC) || !TokenStreamUtils.contains((List)type.ownStartTokens(), (ETokenType)ETokenType.ABSTRACT)) continue;
            this.analyzeMethodsInType(type);
        }
    }

    private void analyzeMethodsInType(ShallowEntity type) {
        List topLevelMethods = type.getChildrenOfType(EShallowEntityType.METHOD);
        for (ShallowEntity topLevelMethod : topLevelMethods) {
            if (!topLevelMethod.getSubtype().equals("constructor") || !TokenStreamUtils.contains((List)topLevelMethod.ownStartTokens(), (ETokenType)ETokenType.PUBLIC)) continue;
            this.buildFinding("An `abstract` type should not have a `public` constructor", this.buildLocation().forEntity(topLevelMethod)).createAndStore();
        }
    }
}

