/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.general;

import eu.cqse.check.cpp.misra.TokenFilterCheckBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.wia.KeywordCheckUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.commons.string.StringUtils;

@Check(id="cqse-forbidden-literals", languages={ELanguage.ABAP, ELanguage.JAVA, ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C, ELanguage.OPEN_CL, ELanguage.RUST, ELanguage.VB, ELanguage.COBOL, ELanguage.CS, ELanguage.ADA, ELanguage.SQLSCRIPT, ELanguage.PLSQL, ELanguage.TSQL, ELanguage.MATLAB, ELanguage.PHP, ELanguage.JAVASCRIPT, ELanguage.DELPHI, ELanguage.IEC61131, ELanguage.FORTRAN, ELanguage.XTEND, ELanguage.SWIFT, ELanguage.OCAML, ELanguage.OSCRIPT, ELanguage.GROOVY, ELanguage.GOSU, ELanguage.KOTLIN, ELanguage.PYTHON, ELanguage.OBJECTIVE_C, ELanguage.OBJECTIVE_CPP, ELanguage.ESQL, ELanguage.GO}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class ForbiddenLiteralsCheck
extends TokenFilterCheckBase {
    private static final String CHECK_NAME = "Forbidden literals";
    private static final int MAX_NUMBER_OF_LITERAL_CHARS_IN_MESSAGE = 20;
    private static final ITokenMatcher EXCEPTIONS_CLAUSE_END_TOKEN = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.DOT, ETokenType.EXPORTING, ETokenType.IMPORTING, ETokenType.TABLES, ETokenType.CHANGING, ETokenType.RPAREN});
    @CheckOption(name="Forbidden literals - Excluded files", description="A list of java-regex patterns for ignored file names. The specified files can be used for declaring literals as they are excluded from the check.")
    private List<String> ignoredUniformPathRegexes = new ArrayList<String>(Arrays.asList(".*/constant\\..*", ".*/literals\\..*"));
    @CheckOption(name="Forbidden literals - Excluded literals", description="A list of java-regex patterns for allowed literals. The specified literals are ignored by the check.")
    private List<String> ignoredLiteralRegexes = new ArrayList<String>(Arrays.asList("0", "1", "\"\"", "''", "\".*_constant\""));
    private Pattern ignoredUniformPathPatterns;
    private Pattern ignoredLiteralPatterns;

    public void initialize() {
        this.ignoredUniformPathPatterns = KeywordCheckUtils.compileIgnorePattern(this.ignoredUniformPathRegexes);
        this.ignoredLiteralPatterns = KeywordCheckUtils.compileIgnorePattern(this.ignoredLiteralRegexes);
    }

    @Override
    public void execute() throws CheckException {
        String uniformPath = this.context.getUniformPath();
        if (this.ignoredUniformPathPatterns.matcher(uniformPath).matches()) {
            return;
        }
        super.execute();
    }

    @Override
    protected List<IToken> getTokens() throws CheckException {
        List<IToken> originalTokens = super.getTokens();
        if (!this.isAbap()) {
            return originalTokens;
        }
        ArrayList<IToken> tokens = new ArrayList<IToken>(originalTokens);
        ForbiddenLiteralsCheck.removeExceptionsClauseTokens(tokens);
        TokenStreamUtils.removeAllOfSequence(tokens, (ETokenType[])new ETokenType[]{ETokenType.CALL, ETokenType.FUNCTION, ETokenType.CHARACTER_LITERAL});
        TokenStreamUtils.removeAllOfSequence(tokens, (ETokenType[])new ETokenType[]{ETokenType.SET, ETokenType.PF_STATUS, ETokenType.CHARACTER_LITERAL});
        TokenStreamUtils.removeAllOfSequence(tokens, (ETokenType[])new ETokenType[]{ETokenType.SET, ETokenType.TITLEBAR, ETokenType.CHARACTER_LITERAL});
        TokenStreamUtils.removeAllOfSequence(tokens, (ETokenType[])new ETokenType[]{ETokenType.CALL, ETokenType.SCREEN, ETokenType.INTEGER_LITERAL});
        TokenStreamUtils.removeAllOfSequence(tokens, (ETokenType[])new ETokenType[]{ETokenType.CALL, ETokenType.SELECTION_SCREEN, ETokenType.INTEGER_LITERAL});
        TokenStreamUtils.removeAllOfSequence(tokens, (ETokenType[])new ETokenType[]{ETokenType.LEAVE, ETokenType.TO, ETokenType.SCREEN, ETokenType.INTEGER_LITERAL});
        TokenStreamUtils.removeAllOfSequence(tokens, (ETokenType[])new ETokenType[]{ETokenType.CALL, ETokenType.SCREEN, ETokenType.CHARACTER_LITERAL});
        TokenStreamUtils.removeAllOfSequence(tokens, (ETokenType[])new ETokenType[]{ETokenType.CALL, ETokenType.SELECTION_SCREEN, ETokenType.CHARACTER_LITERAL});
        TokenStreamUtils.removeAllOfSequence(tokens, (ETokenType[])new ETokenType[]{ETokenType.LINE_SIZE, ETokenType.INTEGER_LITERAL});
        TokenStreamUtils.removeAllOfSequence(tokens, (ETokenType[])new ETokenType[]{ETokenType.LENGTH, ETokenType.INTEGER_LITERAL});
        return tokens;
    }

    private static void removeExceptionsClauseTokens(List<IToken> tokens) {
        int exceptionsEnd;
        int exceptionsStart;
        int searchStartIndex = 0;
        while (searchStartIndex < tokens.size() && (exceptionsStart = TokenStreamUtils.firstTokenMatching(tokens, (int)searchStartIndex, (ITokenMatcher)ETokenType.EXCEPTIONS)) != -1 && (exceptionsEnd = TokenStreamUtils.firstTokenMatching(tokens, (int)(exceptionsStart + 1), (int)tokens.size(), (ITokenMatcher)EXCEPTIONS_CLAUSE_END_TOKEN)) != -1) {
            TokenStreamUtils.removeTokensInRange(tokens, (int)exceptionsStart, (int)(exceptionsEnd - 1));
            searchStartIndex = exceptionsStart;
        }
    }

    @Override
    protected boolean isValidToken(IToken token) {
        if (!token.getType().isLiteral() || this.isStringTemplateFragment(token)) {
            return true;
        }
        return this.ignoredLiteralPatterns.matcher(token.getText()).matches();
    }

    private boolean isStringTemplateFragment(IToken token) {
        if (this.isAbap()) {
            return token.getType() == ETokenType.STRING_LITERAL && (token.getText().startsWith("}") || token.getText().endsWith("{"));
        }
        return false;
    }

    @Override
    protected String getFindingMessage(IToken token) {
        String truncatedLiteral = MarkupUtils.escapeMarkdownRelevantSymbols((String)StringUtils.truncateWithThreeDots((String)token.getText(), (int)20));
        return "`" + truncatedLiteral + "` should be defined in separate file";
    }
}

