/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

@Check(id="cqse-do-not-compare-this-with-null", languages={ELanguage.JAVA, ELanguage.XTEND}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class DoNotCompareThisWithNullCheck
extends CheckImplementationBase {
    private static final ITokenMatcher COMPARE_OPERATORS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.EQEQ, ETokenType.NOTEQ});

    public void execute() throws CheckException {
        List methods = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.METHOD);
        for (ShallowEntity method : methods) {
            if (TokenStreamUtils.contains((List)method.ownStartTokens(), (ETokenType)ETokenType.STATIC)) continue;
            List statementsInMethod = ShallowEntityTraversalUtils.listEntitiesOfType(Collections.singletonList(method), (EShallowEntityType)EShallowEntityType.STATEMENT);
            for (ShallowEntity statementInMethod : statementsInMethod) {
                this.processTokens((List<IToken>)statementInMethod.ownStartTokens());
                this.processTokens((List<IToken>)statementInMethod.ownEndTokens());
            }
        }
    }

    private void processTokens(List<IToken> tokens) throws CheckException {
        List compareIndices = TokenStreamUtils.findAll(tokens, (int)1, (int)(tokens.size() - 1), (ITokenMatcher)COMPARE_OPERATORS);
        Iterator iterator = compareIndices.iterator();
        while (iterator.hasNext()) {
            int compareIndex = (Integer)iterator.next();
            IToken leftOperand = tokens.get(compareIndex - 1);
            IToken rightOperand = tokens.get(compareIndex + 1);
            ETokenType leftType = leftOperand.getType();
            ETokenType rightType = rightOperand.getType();
            if (leftType == ETokenType.THIS && rightType == ETokenType.NULL_LITERAL) {
                this.createFinding(leftOperand, rightOperand);
                continue;
            }
            if (leftType != ETokenType.NULL_LITERAL || rightType != ETokenType.THIS || tokens.size() >= compareIndex + 2 && tokens.get(compareIndex + 2).getType() == ETokenType.DOT) continue;
            this.createFinding(leftOperand, rightOperand);
        }
    }

    private void createFinding(IToken leftOperand, IToken rightOperand) throws CheckException {
        this.buildFinding("`this` should not be compared with `null`", this.buildLocation().betweenTokens(leftOperand, rightOperand)).createAndStore();
    }
}

