/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.JavaLanguageFeatureParser;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Check(id="java:S6814", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class OptionalRestParametersShouldBeObjectsCheck
extends CheckImplementationBase {
    private static final Set<String> PATH_VARIABLE_OR_REQUEST_PARAM_ANNOTATION = Set.of("org.springframework.web.bind.annotation.PathVariable", "org.springframework.web.bind.annotation.RequestParam");

    public void execute() throws CheckException {
        List methods = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.METHOD);
        for (ShallowEntity method : methods) {
            List methodParameters = LanguageFeatureParser.JAVA.getSplitParameterTokens(method);
            methodParameters.forEach(this::checkOptionShouldBeObject);
        }
    }

    private void checkOptionShouldBeObject(List<IToken> parameterTokens) {
        if (parameterTokens.get(parameterTokens.size() - 2).getType().getTokenClass() != ETokenType.ETokenClass.KEYWORD) {
            return;
        }
        List annotations = LanguageFeatureParser.JAVA.getMethodParameterAnnotationParameters(parameterTokens, PATH_VARIABLE_OR_REQUEST_PARAM_ANNOTATION);
        for (List annotation : annotations) {
            Map parameters;
            if (annotation.isEmpty() || !OptionalRestParametersShouldBeObjectsCheck.optionalWithoutDefault(parameters = LanguageFeatureParser.JAVA.extractAnnotationParameters(annotation.subList(1, annotation.size() - 1), Set.of("required", "defaultValue")))) continue;
            this.buildFinding("An optional parameter without a default cannot be a primitive type", this.buildLocation().forTokens(parameterTokens)).createAndStore();
        }
    }

    private static boolean optionalWithoutDefault(Map<String, List<JavaLanguageFeatureParser.ParameterValue>> parameters) {
        return parameters.get("required") != null && parameters.get("required").getFirst().isFalse() && parameters.get("defaultValue") == null;
    }
}

