/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.stateflow;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.util.simulink.StateflowCheckUtils;
import java.util.Collection;
import java.util.HashSet;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.simulink.model.ParameterizedElement;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.stateflow.StateflowChart;
import org.conqat.lib.simulink.model.stateflow.StateflowJunction;
import org.conqat.lib.simulink.model.stateflow.StateflowNodeBase;
import org.conqat.lib.simulink.model.stateflow.StateflowState;
import org.conqat.lib.simulink.util.StateflowUtils;

@Check(id="cqse.jmaab.jc_0775", languages={ELanguage.SIMULINK})
public class SimulinkTerminatingJunctionsInStateflowChartsCheck
extends CheckImplementationBase {
    @CheckOption(name="Check incoming transitions of terminating junctions (jc_0775_a2)", description="If set, the check will flag terminating junctions that do not have exactly one unconditional transition as input.")
    private boolean checkForMultipleUnconditionalInTransitions = false;
    private static final String MULTIPLE_TERMINATING_JUNCTIONS_FINDINGS_MESSAGE = "Multiple terminating junctions in Stateflow chart";
    private static final String CONDITIONAL_IN_TRANSITIONS_FINDINGS_MESSAGE = "Conditional transitions as input for terminating junction";
    private static final String MULTIPLE_IN_TRANSITIONS_FINDINGS_MESSAGE = "Multiple transitions as input for terminating junction";
    private static final FindingPropertyList MULTIPLE_TERMINATING_JUNCTIONS_RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Modify the chart so that only one terminating junction is used.");
    private static final FindingPropertyList MULTIPLE_UNCONDITIONAL_IN_TRANSITIONS_RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Modify the chart so that only one terminating junction with a single unconditional transition as input is used.");

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        for (StateflowChart chart : StateflowUtils.getStateflowChartsFromModel((SimulinkModel)model, (boolean)false)) {
            this.checkTerminatingNodesFromChart(chart);
        }
    }

    private void checkTerminatingNodesFromChart(StateflowChart chart) {
        this.checkTerminatingNodes((Collection<StateflowNodeBase>)chart.getNodes());
        for (StateflowState state : StateflowUtils.listStatesDepthFirst((StateflowChart)chart, (boolean)false)) {
            this.checkTerminatingNodes((Collection<StateflowNodeBase>)state.getNodes());
            if (!state.isSubChart()) continue;
            this.checkTerminatingNodes((Collection<StateflowNodeBase>)state.getSubViewer().getNodes());
        }
    }

    private void checkTerminatingNodes(Collection<StateflowNodeBase> subNodes) {
        HashSet<StateflowNodeBase> terminatingJunctions = new HashSet<StateflowNodeBase>();
        for (StateflowNodeBase node : subNodes) {
            if (StateflowUtils.isCommented((ParameterizedElement)node) || !SimulinkTerminatingJunctionsInStateflowChartsCheck.isTerminatingJunction(node)) continue;
            terminatingJunctions.add(node);
            if (!this.checkForMultipleUnconditionalInTransitions) continue;
            this.checkForMultipleOrUnconditionalInTransitions(node);
        }
        if (terminatingJunctions.size() > 1) {
            for (StateflowNodeBase terminatingJunction : terminatingJunctions) {
                this.buildFinding(MULTIPLE_TERMINATING_JUNCTIONS_FINDINGS_MESSAGE, (ElementLocation)this.buildLocation().forStateflowNode(terminatingJunction)).addFindingProperties(MULTIPLE_TERMINATING_JUNCTIONS_RECOMMENDED_ACTION).createAndStore();
            }
        }
    }

    private static boolean isTerminatingJunction(StateflowNodeBase node) {
        if (!(node instanceof StateflowJunction)) {
            return false;
        }
        return !node.getInTransitions().isEmpty() && node.getOutTransitions().isEmpty();
    }

    private void checkForMultipleOrUnconditionalInTransitions(StateflowNodeBase node) {
        if (node.getInTransitions().size() > 1) {
            this.buildFinding(MULTIPLE_IN_TRANSITIONS_FINDINGS_MESSAGE, (ElementLocation)this.buildLocation().forStateflowNode(node)).addFindingProperties(MULTIPLE_UNCONDITIONAL_IN_TRANSITIONS_RECOMMENDED_ACTION).createAndStore();
        }
        if (!node.getInTransitions().stream().allMatch(StateflowCheckUtils::isUnconditionalTransition)) {
            this.buildFinding(CONDITIONAL_IN_TRANSITIONS_FINDINGS_MESSAGE, (ElementLocation)this.buildLocation().forStateflowNode(node)).addFindingProperties(MULTIPLE_UNCONDITIONAL_IN_TRANSITIONS_RECOMMENDED_ACTION).createAndStore();
        }
    }
}

