/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.sqlscript.sqlstatement;

import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.sqlscript.sqlstatement.SqlQuery;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionUtils;

public class SqlStatement {
    public static final Set<String> SUBQUERY_TOLERANT_STATEMENTS = CollectionUtils.asHashSet((Object[])new String[]{"insert", "upsert", "replace"});
    private final ShallowEntity entity;
    private final SqlQuery query;

    public SqlStatement(ShallowEntity entity) throws CheckException {
        if (entity.getType() != EShallowEntityType.STATEMENT && entity.getSubtype().equals("SQL")) {
            throw new CheckException(String.valueOf(entity) + " is not a SQL statement, thus can not be analyzed as SQL statement.");
        }
        this.entity = entity;
        this.query = new SqlQuery(this);
    }

    public List<IToken> getTokens() {
        return this.entity.ownStartTokens();
    }

    private String getStatementName() {
        return this.entity.getName();
    }

    public IToken getToken(int index) {
        return this.getTokens().get(index);
    }

    public SqlQuery getQuery() {
        return this.query;
    }

    public List<IToken> findSubquerySelectTokensWithoutParentheses() {
        ArrayList<IToken> subqueriesWithoutParentheses = new ArrayList<IToken>();
        for (int tokenIndex : this.findSelectTokenIndices()) {
            if (tokenIndex <= 0 || this.getToken(tokenIndex - 1).getType() == ETokenType.LPAREN) continue;
            subqueriesWithoutParentheses.add(this.getToken(tokenIndex));
        }
        return subqueriesWithoutParentheses;
    }

    private List<Integer> findSelectTokenIndices() {
        List selectTokenIndices = TokenStreamUtils.findAll(this.getTokens(), (ITokenMatcher)ETokenType.SELECT);
        selectTokenIndices.remove((Object)0);
        return selectTokenIndices;
    }

    public List<SqlQuery> findSubqueriesDeeperThan(int threshold) {
        ArrayList<SqlQuery> result = new ArrayList<SqlQuery>();
        if (this.query.getMaximumNestingDepth() <= threshold) {
            return result;
        }
        this.query.collectSubqueriesDeeperThan(threshold, result);
        return result;
    }

    public boolean isSubqueryTolerant() {
        return SUBQUERY_TOLERANT_STATEMENTS.contains(this.getStatementName());
    }
}

