/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.model.datahandler;

import java.awt.Font;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.simulink.model.ParameterizedElement;
import org.conqat.lib.simulink.model.datahandler.FontData;

public abstract class LayoutHandlerBase {
    private static final Logger LOGGER = LogManager.getLogger();
    protected static final int DEFAULT_FONT_SIZE = 10;
    private static final FontRenderContext FONT_RENDER_CONTEXT = new FontRenderContext(null, false, false);

    protected LayoutHandlerBase() {
    }

    public static FontData extractFontData(ParameterizedElement element) {
        return LayoutHandlerBase.extractFontData(element, false);
    }

    public static FontData extractFontData(ParameterizedElement element, boolean useDefaultFontName) {
        String fontName;
        if (useDefaultFontName) {
            fontName = "SansSerif";
        } else {
            fontName = element.getParameter("FontName");
            if (fontName == null) {
                LOGGER.error("Missing font name for element! Using default.");
                fontName = "SansSerif";
            }
        }
        int fontSize = 10;
        String fontSizeValue = element.getParameter("FontSize");
        if (fontSizeValue != null) {
            try {
                fontSize = (int)Math.round(Double.parseDouble(fontSizeValue));
            }
            catch (NumberFormatException e) {
                LOGGER.error("Invalid font size value: " + fontSizeValue);
            }
        }
        boolean bold = "bold".equals(element.getParameter("FontWeight"));
        boolean italic = "italic".equals(element.getParameter("FontAngle"));
        return new FontData(fontName, fontSize, bold, italic);
    }

    public static Rectangle determineTextBounds(String text, Font font) {
        double maxWidth = 0.0;
        double sumHeight = 0.0;
        LineMetrics lineMetrics = font.getLineMetrics(text, FONT_RENDER_CONTEXT);
        for (String line : StringUtils.splitLinesAsList((String)text)) {
            Rectangle2D bounds = LayoutHandlerBase.getTextBounds(line, font);
            maxWidth = Math.max(maxWidth, bounds.getWidth());
            sumHeight += (double)lineMetrics.getHeight();
        }
        return new Rectangle((int)maxWidth, (int)sumHeight);
    }

    private static Rectangle2D getTextBounds(String line, Font font) {
        if (StringUtils.isEmpty((String)line)) {
            return new Rectangle();
        }
        return new TextLayout(line, font, FONT_RENDER_CONTEXT).getBounds();
    }

    public static double getTextWidth(String text, Font font) {
        return LayoutHandlerBase.getTextBounds(text, font).getWidth();
    }
}

