/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.dotnet.resource.parser;

import java.util.HashSet;
import java.util.Set;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.core.util.XMLReaderBase;
import org.conqat.engine.dotnet.resource.parser.EProjectXmlAttribute;
import org.conqat.engine.dotnet.resource.parser.EProjectXmlElement;
import org.conqat.engine.dotnet.resource.parser.ESolutionFormatVersion;
import org.conqat.engine.dotnet.resource.parser.ProjectParser8;
import org.conqat.engine.dotnet.resource.parser.ProjectParser9;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.xml.IXMLElementProcessor;

public abstract class ProjectParser
extends XMLReaderBase<EProjectXmlElement, EProjectXmlAttribute, ConQATException> {
    protected final VisualStudioProject vsProject = new VisualStudioProject();

    protected ProjectParser(String projectFileContent) {
        super(projectFileContent, EProjectXmlAttribute.class);
    }

    public static VisualStudioProject parse(String projectFileContent) throws ConQATException, ESolutionFormatVersion.UnsupportedFormatException {
        ESolutionFormatVersion formatVersion = ESolutionFormatVersion.determineProjectFormat(projectFileContent);
        return switch (formatVersion) {
            default -> throw new MatchException(null, null);
            case ESolutionFormatVersion.VERSION_9 -> new ProjectParser9(projectFileContent).parse();
            case ESolutionFormatVersion.VERSION_8 -> new ProjectParser8(projectFileContent).parse();
        };
    }

    public VisualStudioProject parse() throws ConQATException {
        this.parseAndWrapExceptions();
        this.processProjectElement();
        this.processDecendantElements(this.createSourceFileProcessor());
        this.processDecendantElements(this.createProjectReferenceProcessor());
        return this.vsProject;
    }

    protected void processProjectElement() throws ConQATException {
    }

    private IXMLElementProcessor<EProjectXmlElement, ConQATException> createProjectReferenceProcessor() {
        return new IXMLElementProcessor<EProjectXmlElement, ConQATException>(){

            public EProjectXmlElement getTargetElement() {
                return EProjectXmlElement.ProjectReference;
            }

            public void process() {
                ProjectParser.this.vsProject.projectReferences.add(ProjectParser.this.getStringAttribute(EProjectXmlAttribute.Include));
            }
        };
    }

    public abstract SourceFileProcessor createSourceFileProcessor();

    protected String getLocation() {
        return "vs-project-file";
    }

    public static class VisualStudioProject {
        private final Set<String> relativeSources = new HashSet<String>();
        private final Set<String> projectReferences = new HashSet<String>();
        private boolean sdkStyle = false;

        public Set<String> getRelativeSources() {
            return CollectionUtils.asUnmodifiable(this.relativeSources);
        }

        public Set<String> getProjectReferences() {
            return CollectionUtils.asUnmodifiable(this.projectReferences);
        }

        public void setSdkStyle(boolean sdkStyle) {
            this.sdkStyle = sdkStyle;
        }

        public boolean isSdkStyle() {
            return this.sdkStyle;
        }
    }

    protected abstract class SourceFileProcessor
    implements IXMLElementProcessor<EProjectXmlElement, ConQATException> {
        protected SourceFileProcessor() {
        }

        public void addSourceFile(String file) {
            ProjectParser.this.vsProject.relativeSources.add(file);
        }
    }
}

